/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.util.EnumHand;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.ModeSetting;

@Mod.Info(category=Mod.Category.COMBAT, description="Automatically leaves the server when your health is low.\nThe Chars, TP and SelfHurt modes can bypass CombatLog and similar plugins.", name="AutoLeave", tutorial="Mods/AutoLeave")
public class AutoLeaveMod
extends Mod
implements UpdateListener {
    private int mode = 0;
    private String[] modes = new String[]{"Quit", "Chars", "TP", "SelfHurt"};

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{AutoLeaveMod.wurst.commands.leaveCmd};
    }

    @Override
    public String getRenderName() {
        String name = String.valueOf(this.getName()) + "[" + this.modes[this.mode] + "]";
        return name;
    }

    @Override
    public void initSettings() {
        this.settings.add(new ModeSetting("Mode", this.modes, this.mode){

            @Override
            public void update() {
                AutoLeaveMod.this.mode = this.getSelected();
            }
        });
    }

    @Override
    public void onEnable() {
        AutoLeaveMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (!(!((double)AutoLeaveMod.mc.thePlayer.getHealth() <= 8.0) || AutoLeaveMod.mc.thePlayer.capabilities.isCreativeMode || mc.isIntegratedServerRunning() && Minecraft.getMinecraft().thePlayer.sendQueue.getPlayerInfoMap().size() <= 1)) {
            switch (this.mode) {
                case 0: {
                    AutoLeaveMod.mc.theWorld.sendQuittingDisconnectingPacket();
                    break;
                }
                case 1: {
                    AutoLeaveMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketChatMessage("\u00a7"));
                    break;
                }
                case 2: {
                    AutoLeaveMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayer.C04PacketPlayerPosition(3.1E7, 100.0, 3.1E7, false));
                    break;
                }
                case 3: {
                    AutoLeaveMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketUseEntity(AutoLeaveMod.mc.thePlayer, EnumHand.MAIN_HAND));
                    break;
                }
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void onDisable() {
        AutoLeaveMod.wurst.events.remove(UpdateListener.class, this);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        ((ModeSetting)this.settings.get(1)).setSelected(mode);
    }

    public String[] getModes() {
        return this.modes;
    }
}

