/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.block.Block;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.utils.BlockUtils;

@Mod.Info(category=Mod.Category.BLOCKS, description="Places random blocks around you.", name="BuildRandom")
public class BuildRandomMod
extends Mod
implements UpdateListener {
    private float range = 6.0f;

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{BuildRandomMod.wurst.mods.autoBuildMod, BuildRandomMod.wurst.mods.fastPlaceMod, BuildRandomMod.wurst.mods.autoSwitchMod};
    }

    @Override
    public void onEnable() {
        BuildRandomMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (BuildRandomMod.wurst.mods.freecamMod.isActive() || BuildRandomMod.wurst.mods.remoteViewMod.isActive() || BuildRandomMod.mc.objectMouseOver == null || BuildRandomMod.mc.objectMouseOver.typeOfHit != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (BuildRandomMod.mc.rightClickDelayTimer > 0 && !BuildRandomMod.wurst.mods.fastPlaceMod.isActive()) {
            return;
        }
        float xDiff = 0.0f;
        float yDiff = 0.0f;
        float zDiff = 0.0f;
        float distance = this.range + 1.0f;
        boolean hasBlocks = false;
        int y = (int)this.range;
        while ((float)y >= -this.range) {
            int x = (int)this.range;
            while ((float)x >= -this.range - 1.0f) {
                int z = (int)this.range;
                while ((float)z >= -this.range) {
                    if (Block.getIdFromBlock(BuildRandomMod.mc.theWorld.getBlockState(new BlockPos((int)((double)x + BuildRandomMod.mc.thePlayer.posX), (int)((double)y + BuildRandomMod.mc.thePlayer.posY), (int)((double)z + BuildRandomMod.mc.thePlayer.posZ))).getBlock()) != 0 && BlockUtils.getBlockDistance(x, y, z) <= this.range) {
                        hasBlocks = true;
                        break;
                    }
                    --z;
                }
                if (hasBlocks) break;
                --x;
            }
            if (hasBlocks) break;
            --y;
        }
        if (!hasBlocks) {
            return;
        }
        BlockPos randomPos = null;
        while (distance > this.range || distance < -this.range || randomPos == null || Block.getIdFromBlock(BuildRandomMod.mc.theWorld.getBlockState(randomPos).getBlock()) == 0) {
            xDiff = (int)(Math.random() * (double)this.range * 2.0 - (double)this.range - 1.0);
            yDiff = (int)(Math.random() * (double)this.range * 2.0 - (double)this.range);
            zDiff = (int)(Math.random() * (double)this.range * 2.0 - (double)this.range);
            distance = BlockUtils.getBlockDistance(xDiff, yDiff, zDiff);
            int randomPosX = (int)((double)xDiff + BuildRandomMod.mc.thePlayer.posX);
            int randomPosY = (int)((double)yDiff + BuildRandomMod.mc.thePlayer.posY);
            int randomPosZ = (int)((double)zDiff + BuildRandomMod.mc.thePlayer.posZ);
            randomPos = new BlockPos(randomPosX, randomPosY, randomPosZ);
        }
        BlockUtils.faceBlockPacket(randomPos);
        BuildRandomMod.mc.thePlayer.swingArm(EnumHand.MAIN_HAND);
        BuildRandomMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerTryUseItem(randomPos, BuildRandomMod.mc.objectMouseOver.sideHit, EnumHand.MAIN_HAND, (float)BuildRandomMod.mc.objectMouseOver.hitVec.xCoord - (float)BuildRandomMod.mc.objectMouseOver.getBlockPos().getX(), (float)BuildRandomMod.mc.objectMouseOver.hitVec.yCoord - (float)BuildRandomMod.mc.objectMouseOver.getBlockPos().getY(), (float)BuildRandomMod.mc.objectMouseOver.hitVec.zCoord - (float)BuildRandomMod.mc.objectMouseOver.getBlockPos().getZ()));
    }

    @Override
    public void onDisable() {
        BuildRandomMod.wurst.events.remove(UpdateListener.class, this);
    }
}

