/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Allows you to see chests through walls.", name="ChestESP")
public class ChestEspMod
extends Mod
implements RenderListener {
    private int maxChests = 1000;
    public boolean shouldInform = true;

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{ChestEspMod.wurst.mods.itemEspMod, ChestEspMod.wurst.mods.searchMod, ChestEspMod.wurst.mods.xRayMod};
    }

    @Override
    public void onEnable() {
        this.shouldInform = true;
        ChestEspMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        int i = 0;
        for (Object o : ChestEspMod.mc.theWorld.loadedTileEntityList) {
            if (i >= this.maxChests) break;
            if (o instanceof TileEntityChest) {
                ++i;
                RenderUtils.blockESPBox(((TileEntityChest)o).getPos());
                continue;
            }
            if (!(o instanceof TileEntityEnderChest)) continue;
            ++i;
            RenderUtils.blockESPBox(((TileEntityEnderChest)o).getPos());
        }
        for (Object o : ChestEspMod.mc.theWorld.loadedEntityList) {
            if (i >= this.maxChests) break;
            if (!(o instanceof EntityMinecartChest)) continue;
            ++i;
            RenderUtils.blockESPBox(((EntityMinecartChest)o).getPosition());
        }
        if (i >= this.maxChests && this.shouldInform) {
            ChestEspMod.wurst.chat.warning(String.valueOf(this.getName()) + " found \u00a7lA LOT\u00a7r of chests.");
            ChestEspMod.wurst.chat.message("To prevent lag, it will only show the first " + this.maxChests + " chests.");
            this.shouldInform = false;
        } else if (i < this.maxChests) {
            this.shouldInform = true;
        }
    }

    @Override
    public void onDisable() {
        ChestEspMod.wurst.events.remove(RenderListener.class, this);
    }
}

