/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.ai.PathUtils;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.BlockUtils;

@Mod.Info(category=Mod.Category.HIDDEN, description="", name="GoTo")
public class GoToCmdMod
extends Mod
implements UpdateListener {
    private static ArrayList<BlockPos> path;
    private static BlockPos goal;
    private int index;

    @Override
    public String getRenderName() {
        if (goal != null) {
            return "Go to " + goal.getX() + " " + goal.getY() + " " + goal.getZ();
        }
        return "GoTo";
    }

    @Override
    public void onEnable() {
        this.index = 0;
        GoToCmdMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (path == null || goal == null) {
            this.setEnabled(false);
            return;
        }
        BlockPos currentPos = new BlockPos(GoToCmdMod.mc.thePlayer);
        BlockPos nextPos = path.get(this.index);
        float dist = BlockUtils.getPlayerBlockDistance(nextPos);
        float hDist = BlockUtils.getHorizontalPlayerBlockDistance(nextPos);
        double vDist = Math.abs(GoToCmdMod.mc.thePlayer.posY - (double)nextPos.getY());
        GoToCmdMod.mc.gameSettings.keyBindForward.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindBack.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindRight.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindLeft.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindJump.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindSneak.pressed = false;
        GoToCmdMod.mc.thePlayer.rotationPitch = 10.0f;
        BlockUtils.faceBlockClientHorizontally(nextPos);
        if ((double)hDist > 0.25) {
            GoToCmdMod.mc.gameSettings.keyBindForward.pressed = true;
        }
        if (vDist > 0.75) {
            if (PathUtils.isFlyable(currentPos)) {
                if (currentPos.getY() > nextPos.getY()) {
                    GoToCmdMod.mc.gameSettings.keyBindSneak.pressed = true;
                } else {
                    GoToCmdMod.mc.gameSettings.keyBindJump.pressed = true;
                }
            } else if (PathUtils.isClimbable(currentPos) && currentPos.getY() < nextPos.getY()) {
                BlockPos[] neighbors;
                BlockPos[] blockPosArray = neighbors = new BlockPos[]{currentPos.add(0, 0, -1), currentPos.add(0, 0, 1), currentPos.add(1, 0, 0), currentPos.add(-1, 0, 0)};
                int n = neighbors.length;
                int n2 = 0;
                while (n2 < n) {
                    BlockPos neigbor = blockPosArray[n2];
                    if (PathUtils.isSolid(neigbor)) {
                        BlockUtils.faceBlockClientHorizontally(neigbor);
                        GoToCmdMod.mc.gameSettings.keyBindForward.pressed = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (dist < 1.0f) {
            ++this.index;
        }
        if (this.index >= path.size()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void onDisable() {
        GoToCmdMod.wurst.events.remove(UpdateListener.class, this);
        path = null;
        goal = null;
        GoToCmdMod.mc.gameSettings.keyBindForward.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindBack.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindRight.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindLeft.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindJump.pressed = false;
        GoToCmdMod.mc.gameSettings.keyBindSneak.pressed = false;
    }

    public static void setPath(ArrayList<BlockPos> path) {
        GoToCmdMod.path = path;
    }

    public static BlockPos getGoal() {
        return goal;
    }

    public static void setGoal(BlockPos goal) {
        GoToCmdMod.goal = goal;
    }
}

