/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import org.darkstorm.minecraft.gui.component.BoundedRangeComponent;
import tk.wurst_client.events.listeners.LeftClickListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.AutoToolMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.ModeSetting;
import tk.wurst_client.navigator.settings.SliderSetting;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.BLOCKS, description="Destroys blocks around you.\nUse .nuker mode <mode> to change the mode.", name="Nuker", tutorial="Mods/Nuker")
public class NukerMod
extends Mod
implements LeftClickListener,
RenderListener,
UpdateListener {
    public float normalRange = 5.0f;
    public float yesCheatRange = 4.25f;
    private float realRange;
    private static Block currentBlock;
    private float currentDamage;
    private EnumFacing side = EnumFacing.UP;
    private byte blockHitDelay = 0;
    public static int id;
    private BlockPos pos;
    private boolean shouldRenderESP;
    private int oldSlot = -1;
    private int mode = 0;
    private String[] modes = new String[]{"Normal", "ID", "Flat", "Smash"};

    static {
        id = 0;
    }

    @Override
    public String getRenderName() {
        switch (this.mode) {
            case 0: {
                return "Nuker";
            }
            case 1: {
                return "IDNuker [" + id + "]";
            }
        }
        return String.valueOf(this.modes[this.mode]) + "Nuker";
    }

    @Override
    public void initSettings() {
        this.settings.add(new SliderSetting("Range", this.normalRange, 1.0, 6.0, 0.05, BoundedRangeComponent.ValueDisplay.DECIMAL){

            @Override
            public void update() {
                NukerMod.this.normalRange = (float)this.getValue();
                NukerMod.this.yesCheatRange = Math.min(NukerMod.this.normalRange, 4.25f);
            }
        });
        this.settings.add(new ModeSetting("Mode", this.modes, this.mode){

            @Override
            public void update() {
                NukerMod.this.mode = this.getSelected();
            }
        });
    }

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{NukerMod.wurst.mods.nukerLegitMod, NukerMod.wurst.mods.speedNukerMod, NukerMod.wurst.mods.tunnellerMod, NukerMod.wurst.mods.fastBreakMod, NukerMod.wurst.mods.autoMineMod, NukerMod.wurst.mods.overlayMod};
    }

    @Override
    public void onEnable() {
        if (NukerMod.wurst.mods.nukerLegitMod.isEnabled()) {
            NukerMod.wurst.mods.nukerLegitMod.setEnabled(false);
        }
        if (NukerMod.wurst.mods.speedNukerMod.isEnabled()) {
            NukerMod.wurst.mods.speedNukerMod.setEnabled(false);
        }
        if (NukerMod.wurst.mods.tunnellerMod.isEnabled()) {
            NukerMod.wurst.mods.tunnellerMod.setEnabled(false);
        }
        NukerMod.wurst.events.add(LeftClickListener.class, this);
        NukerMod.wurst.events.add(UpdateListener.class, this);
        NukerMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        if (this.blockHitDelay == 0 && this.shouldRenderESP) {
            if (!NukerMod.mc.thePlayer.capabilities.isCreativeMode && currentBlock.getPlayerRelativeBlockHardness(NukerMod.mc.theWorld.getBlockState(this.pos), NukerMod.mc.thePlayer, NukerMod.mc.theWorld, this.pos) < 1.0f) {
                RenderUtils.nukerBox(this.pos, this.currentDamage);
            } else {
                RenderUtils.nukerBox(this.pos, 1.0f);
            }
        }
    }

    @Override
    public void onUpdate() {
        this.realRange = NukerMod.wurst.mods.yesCheatMod.isActive() ? this.yesCheatRange : this.normalRange;
        this.shouldRenderESP = false;
        BlockPos newPos = this.find();
        if (newPos == null) {
            if (this.oldSlot != -1) {
                NukerMod.mc.thePlayer.inventory.currentItem = this.oldSlot;
                this.oldSlot = -1;
            }
            return;
        }
        if (this.pos == null || !this.pos.equals(newPos)) {
            this.currentDamage = 0.0f;
        }
        this.pos = newPos;
        currentBlock = NukerMod.mc.theWorld.getBlockState(this.pos).getBlock();
        if (this.blockHitDelay > 0) {
            this.blockHitDelay = (byte)(this.blockHitDelay - 1);
            return;
        }
        BlockUtils.faceBlockPacket(this.pos);
        if (this.currentDamage == 0.0f) {
            NukerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, this.pos, this.side));
            if (NukerMod.wurst.mods.autoToolMod.isActive() && this.oldSlot == -1) {
                this.oldSlot = NukerMod.mc.thePlayer.inventory.currentItem;
            }
            if (NukerMod.mc.thePlayer.capabilities.isCreativeMode || currentBlock.getPlayerRelativeBlockHardness(NukerMod.mc.theWorld.getBlockState(this.pos), NukerMod.mc.thePlayer, NukerMod.mc.theWorld, this.pos) >= 1.0f) {
                this.currentDamage = 0.0f;
                if (NukerMod.mc.thePlayer.capabilities.isCreativeMode && !NukerMod.wurst.mods.yesCheatMod.isActive()) {
                    this.nukeAll();
                } else {
                    this.shouldRenderESP = true;
                    NukerMod.mc.thePlayer.swingArm(EnumHand.MAIN_HAND);
                    NukerMod.mc.playerController.onPlayerDestroyBlock(this.pos);
                }
                return;
            }
        }
        if (NukerMod.wurst.mods.autoToolMod.isActive()) {
            AutoToolMod.setSlot(this.pos);
        }
        NukerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketAnimation());
        this.shouldRenderESP = true;
        BlockUtils.faceBlockPacket(this.pos);
        this.currentDamage += currentBlock.getPlayerRelativeBlockHardness(NukerMod.mc.theWorld.getBlockState(this.pos), NukerMod.mc.thePlayer, NukerMod.mc.theWorld, this.pos) * (NukerMod.wurst.mods.fastBreakMod.isActive() && NukerMod.wurst.options.fastbreakMode == 0 ? NukerMod.wurst.mods.fastBreakMod.speed : 1.0f);
        NukerMod.mc.theWorld.sendBlockBreakProgress(NukerMod.mc.thePlayer.getEntityId(), this.pos, (int)(this.currentDamage * 10.0f) - 1);
        if (this.currentDamage >= 1.0f) {
            NukerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
            NukerMod.mc.playerController.onPlayerDestroyBlock(this.pos);
            this.blockHitDelay = (byte)4;
            this.currentDamage = 0.0f;
        } else if (NukerMod.wurst.mods.fastBreakMod.isActive() && NukerMod.wurst.options.fastbreakMode == 1) {
            NukerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
        }
    }

    @Override
    public void onDisable() {
        NukerMod.wurst.events.remove(LeftClickListener.class, this);
        NukerMod.wurst.events.remove(UpdateListener.class, this);
        NukerMod.wurst.events.remove(RenderListener.class, this);
        if (this.oldSlot != -1) {
            NukerMod.mc.thePlayer.inventory.currentItem = this.oldSlot;
            this.oldSlot = -1;
        }
        this.currentDamage = 0.0f;
        this.shouldRenderESP = false;
        id = 0;
        NukerMod.wurst.files.saveOptions();
    }

    @Override
    public void onLeftClick() {
        if (NukerMod.mc.objectMouseOver == null || NukerMod.mc.objectMouseOver.getBlockPos() == null) {
            return;
        }
        if (this.mode == 1 && NukerMod.mc.theWorld.getBlockState(NukerMod.mc.objectMouseOver.getBlockPos()).getBlock().getMaterial(null) != Material.air) {
            id = Block.getIdFromBlock(NukerMod.mc.theWorld.getBlockState(NukerMod.mc.objectMouseOver.getBlockPos()).getBlock());
            NukerMod.wurst.files.saveOptions();
        }
    }

    private BlockPos find() {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> alreadyProcessed = new HashSet<BlockPos>();
        queue.add(new BlockPos(NukerMod.mc.thePlayer));
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            if (alreadyProcessed.contains(currentPos)) continue;
            alreadyProcessed.add(currentPos);
            if (BlockUtils.getPlayerBlockDistance(currentPos) > this.realRange) continue;
            int currentID = Block.getIdFromBlock(NukerMod.mc.theWorld.getBlockState(currentPos).getBlock());
            if (currentID != 0) {
                switch (this.mode) {
                    case 1: {
                        if (currentID != id) break;
                        return currentPos;
                    }
                    case 2: {
                        if (!((double)currentPos.getY() >= NukerMod.mc.thePlayer.posY)) break;
                        return currentPos;
                    }
                    case 3: {
                        if (!(NukerMod.mc.theWorld.getBlockState(currentPos).getBlock().getPlayerRelativeBlockHardness(NukerMod.mc.theWorld.getBlockState(this.pos), NukerMod.mc.thePlayer, NukerMod.mc.theWorld, currentPos) >= 1.0f)) break;
                        return currentPos;
                    }
                    default: {
                        return currentPos;
                    }
                }
            }
            if (NukerMod.wurst.mods.yesCheatMod.isActive() && NukerMod.mc.theWorld.getBlockState(currentPos).getBlock().getMaterial(null).blocksMovement()) continue;
            queue.add(currentPos.add(0, 0, -1));
            queue.add(currentPos.add(0, 0, 1));
            queue.add(currentPos.add(-1, 0, 0));
            queue.add(currentPos.add(1, 0, 0));
            queue.add(currentPos.add(0, -1, 0));
            queue.add(currentPos.add(0, 1, 0));
        }
        return null;
    }

    private void nukeAll() {
        int y = (int)this.realRange;
        while ((float)y >= (this.mode == 2 ? 0.0f : -this.realRange)) {
            int x = (int)this.realRange;
            while ((float)x >= -this.realRange - 1.0f) {
                int z = (int)this.realRange;
                while ((float)z >= -this.realRange) {
                    int posX = (int)(Math.floor(NukerMod.mc.thePlayer.posX) + (double)x);
                    int posY = (int)(Math.floor(NukerMod.mc.thePlayer.posY) + (double)y);
                    int posZ = (int)(Math.floor(NukerMod.mc.thePlayer.posZ) + (double)z);
                    BlockPos blockPos = new BlockPos(posX, posY, posZ);
                    Block block = NukerMod.mc.theWorld.getBlockState(blockPos).getBlock();
                    float xDiff = (float)(NukerMod.mc.thePlayer.posX - (double)posX);
                    float yDiff = (float)(NukerMod.mc.thePlayer.posY - (double)posY);
                    float zDiff = (float)(NukerMod.mc.thePlayer.posZ - (double)posZ);
                    float currentDistance = BlockUtils.getBlockDistance(xDiff, yDiff, zDiff);
                    if (!(Block.getIdFromBlock(block) == 0 || posY < 0 || !(currentDistance <= this.realRange) || this.mode == 1 && Block.getIdFromBlock(block) != id || this.mode == 3 && block.getPlayerRelativeBlockHardness(NukerMod.mc.theWorld.getBlockState(blockPos), NukerMod.mc.thePlayer, NukerMod.mc.theWorld, blockPos) < 1.0f)) {
                        this.side = NukerMod.mc.objectMouseOver.sideHit;
                        this.shouldRenderESP = true;
                        BlockUtils.faceBlockPacket(this.pos);
                        NukerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, blockPos, this.side));
                        block.onBlockDestroyedByPlayer(NukerMod.mc.theWorld, blockPos, NukerMod.mc.theWorld.getBlockState(blockPos));
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        ((ModeSetting)this.settings.get(1)).setSelected(mode);
    }

    public String[] getModes() {
        return this.modes;
    }
}

