/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(name="Trajectories", description="Predicts the flight path of arrows and throwable items.", category=Mod.Category.RENDER, tags="AimAssist,ArrowPrediction,aim assist,arrow prediction", tutorial="Mods/Trajectories")
public class TrajectoriesMod
extends Mod
implements RenderListener {
    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{TrajectoriesMod.wurst.mods.bowAimbotMod, TrajectoriesMod.wurst.mods.fastBowMod, TrajectoriesMod.wurst.mods.throwMod};
    }

    @Override
    public void onEnable() {
        TrajectoriesMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        EntityPlayerSP player = TrajectoriesMod.mc.thePlayer;
        ItemStack stack = player.inventory.getCurrentItem();
        if (stack == null) {
            return;
        }
        Item item = stack.getItem();
        if (!(item instanceof ItemBow || item instanceof ItemSnowball || item instanceof ItemEgg || item instanceof ItemEnderPearl || item instanceof ItemSplashPotion || item instanceof ItemLingeringPotion || item instanceof ItemFishingRod)) {
            return;
        }
        boolean usingBow = player.inventory.getCurrentItem().getItem() instanceof ItemBow;
        double arrowPosX = player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)TrajectoriesMod.mc.timer.renderPartialTicks - (double)(MathHelper.cos((float)Math.toRadians(player.rotationYaw)) * 0.16f);
        double arrowPosY = player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)Minecraft.getMinecraft().timer.renderPartialTicks + (double)player.getEyeHeight() - 0.1;
        double arrowPosZ = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)Minecraft.getMinecraft().timer.renderPartialTicks - (double)(MathHelper.sin((float)Math.toRadians(player.rotationYaw)) * 0.16f);
        float arrowMotionFactor = usingBow ? 1.0f : 0.4f;
        float yaw = (float)Math.toRadians(player.rotationYaw);
        float pitch = (float)Math.toRadians(player.rotationPitch);
        float arrowMotionX = -MathHelper.sin(yaw) * MathHelper.cos(pitch) * arrowMotionFactor;
        float arrowMotionY = -MathHelper.sin(pitch) * arrowMotionFactor;
        float arrowMotionZ = MathHelper.cos(yaw) * MathHelper.cos(pitch) * arrowMotionFactor;
        double arrowMotion = Math.sqrt(arrowMotionX * arrowMotionX + arrowMotionY * arrowMotionY + arrowMotionZ * arrowMotionZ);
        arrowMotionX = (float)((double)arrowMotionX / arrowMotion);
        arrowMotionY = (float)((double)arrowMotionY / arrowMotion);
        arrowMotionZ = (float)((double)arrowMotionZ / arrowMotion);
        if (usingBow) {
            float bowPower = (float)(72000 - player.getItemInUseCount()) / 20.0f;
            if ((bowPower = (bowPower * bowPower + bowPower * 2.0f) / 3.0f) > 1.0f) {
                bowPower = 1.0f;
            }
            if (bowPower <= 0.1f) {
                bowPower = 1.0f;
            }
            arrowMotionX *= (bowPower *= 3.0f);
            arrowMotionY *= bowPower;
            arrowMotionZ *= bowPower;
        } else {
            arrowMotionX = (float)((double)arrowMotionX * 1.5);
            arrowMotionY = (float)((double)arrowMotionY * 1.5);
            arrowMotionZ = (float)((double)arrowMotionZ * 1.5);
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)2848);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)32925);
        GL11.glDepthMask((boolean)false);
        GL11.glLineWidth((float)1.8f);
        RenderManager renderManager = mc.getRenderManager();
        double gravity = usingBow ? 0.05 : (item instanceof ItemPotion ? 0.4 : (item instanceof ItemFishingRod ? 0.15 : 0.03));
        Vec3d playerVector = new Vec3d(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ);
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        GL11.glBegin((int)3);
        int i = 0;
        while (i < 1000) {
            GL11.glVertex3d((double)(arrowPosX - renderManager.renderPosX), (double)(arrowPosY - renderManager.renderPosY), (double)(arrowPosZ - renderManager.renderPosZ));
            arrowMotionX = (float)((double)arrowMotionX * 0.999);
            arrowMotionY = (float)((double)arrowMotionY * 0.999);
            arrowMotionZ = (float)((double)arrowMotionZ * 0.999);
            arrowMotionY = (float)((double)arrowMotionY - gravity * 0.1);
            if (TrajectoriesMod.mc.theWorld.rayTraceBlocks(playerVector, new Vec3d(arrowPosX += (double)arrowMotionX * 0.1, arrowPosY += (double)arrowMotionY * 0.1, arrowPosZ += (double)arrowMotionZ * 0.1)) != null) break;
            ++i;
        }
        GL11.glEnd();
        double renderX = arrowPosX - renderManager.renderPosX;
        double renderY = arrowPosY - renderManager.renderPosY;
        double renderZ = arrowPosZ - renderManager.renderPosZ;
        AxisAlignedBB bb = new AxisAlignedBB(renderX - 0.5, renderY - 0.5, renderZ - 0.5, renderX + 0.5, renderY + 0.5, renderZ + 0.5);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.15f);
        RenderUtils.drawColorBox(bb, 0.0f, 1.0f, 0.0f, 0.15f);
        GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)0.5);
        RenderGlobal.drawSelectionBoundingBox(bb);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)32925);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2848);
        GL11.glPopMatrix();
    }

    @Override
    public void onDisable() {
        TrajectoriesMod.wurst.events.remove(RenderListener.class, this);
    }
}

