/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.block.Block;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.AutoToolMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.BLOCKS, description="Digs a 3x3 tunnel around you.", name="Tunneller")
public class TunnellerMod
extends Mod
implements RenderListener,
UpdateListener {
    private static Block currentBlock;
    private float currentDamage;
    private EnumFacing side = EnumFacing.UP;
    private byte blockHitDelay = 0;
    private BlockPos pos;
    private boolean shouldRenderESP;
    private int oldSlot = -1;

    @Override
    public void onEnable() {
        if (TunnellerMod.wurst.mods.nukerMod.isEnabled()) {
            TunnellerMod.wurst.mods.nukerMod.setEnabled(false);
        }
        if (TunnellerMod.wurst.mods.nukerLegitMod.isEnabled()) {
            TunnellerMod.wurst.mods.nukerLegitMod.setEnabled(false);
        }
        if (TunnellerMod.wurst.mods.speedNukerMod.isEnabled()) {
            TunnellerMod.wurst.mods.speedNukerMod.setEnabled(false);
        }
        TunnellerMod.wurst.events.add(UpdateListener.class, this);
        TunnellerMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{TunnellerMod.wurst.mods.nukerMod, TunnellerMod.wurst.mods.nukerLegitMod, TunnellerMod.wurst.mods.speedNukerMod, TunnellerMod.wurst.mods.fastBreakMod, TunnellerMod.wurst.mods.autoMineMod};
    }

    @Override
    public void onRender() {
        if (this.blockHitDelay == 0 && this.shouldRenderESP) {
            if (!TunnellerMod.mc.thePlayer.capabilities.isCreativeMode && currentBlock.getPlayerRelativeBlockHardness(TunnellerMod.mc.theWorld.getBlockState(this.pos), TunnellerMod.mc.thePlayer, TunnellerMod.mc.theWorld, this.pos) < 1.0f) {
                RenderUtils.nukerBox(this.pos, this.currentDamage);
            } else {
                RenderUtils.nukerBox(this.pos, 1.0f);
            }
        }
    }

    @Override
    public void onUpdate() {
        this.shouldRenderESP = false;
        BlockPos newPos = this.find();
        if (newPos == null) {
            if (this.oldSlot != -1) {
                TunnellerMod.mc.thePlayer.inventory.currentItem = this.oldSlot;
                this.oldSlot = -1;
            }
            return;
        }
        if (this.pos == null || !this.pos.equals(newPos)) {
            this.currentDamage = 0.0f;
        }
        this.pos = newPos;
        currentBlock = TunnellerMod.mc.theWorld.getBlockState(this.pos).getBlock();
        if (this.blockHitDelay > 0) {
            this.blockHitDelay = (byte)(this.blockHitDelay - 1);
            return;
        }
        BlockUtils.faceBlockPacket(this.pos);
        if (this.currentDamage == 0.0f) {
            TunnellerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, this.pos, this.side));
            if (TunnellerMod.wurst.mods.autoToolMod.isActive() && this.oldSlot == -1) {
                this.oldSlot = TunnellerMod.mc.thePlayer.inventory.currentItem;
            }
            if (TunnellerMod.mc.thePlayer.capabilities.isCreativeMode || currentBlock.getPlayerRelativeBlockHardness(TunnellerMod.mc.theWorld.getBlockState(this.pos), TunnellerMod.mc.thePlayer, TunnellerMod.mc.theWorld, this.pos) >= 1.0f) {
                this.currentDamage = 0.0f;
                if (TunnellerMod.mc.thePlayer.capabilities.isCreativeMode && !TunnellerMod.wurst.mods.yesCheatMod.isActive()) {
                    this.nukeAll();
                } else {
                    this.shouldRenderESP = true;
                    TunnellerMod.mc.thePlayer.swingArm(EnumHand.MAIN_HAND);
                    TunnellerMod.mc.playerController.onPlayerDestroyBlock(this.pos);
                }
                return;
            }
        }
        if (TunnellerMod.wurst.mods.autoToolMod.isActive()) {
            AutoToolMod.setSlot(this.pos);
        }
        TunnellerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketAnimation());
        this.shouldRenderESP = true;
        BlockUtils.faceBlockPacket(this.pos);
        this.currentDamage += currentBlock.getPlayerRelativeBlockHardness(TunnellerMod.mc.theWorld.getBlockState(this.pos), TunnellerMod.mc.thePlayer, TunnellerMod.mc.theWorld, this.pos) * (TunnellerMod.wurst.mods.fastBreakMod.isActive() && TunnellerMod.wurst.options.fastbreakMode == 0 ? TunnellerMod.wurst.mods.fastBreakMod.speed : 1.0f);
        TunnellerMod.mc.theWorld.sendBlockBreakProgress(TunnellerMod.mc.thePlayer.getEntityId(), this.pos, (int)(this.currentDamage * 10.0f) - 1);
        if (this.currentDamage >= 1.0f) {
            TunnellerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
            TunnellerMod.mc.playerController.onPlayerDestroyBlock(this.pos);
            this.blockHitDelay = (byte)4;
            this.currentDamage = 0.0f;
        } else if (TunnellerMod.wurst.mods.fastBreakMod.isActive() && TunnellerMod.wurst.options.fastbreakMode == 1) {
            TunnellerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, this.pos, this.side));
        }
    }

    @Override
    public void onDisable() {
        TunnellerMod.wurst.events.remove(UpdateListener.class, this);
        TunnellerMod.wurst.events.remove(RenderListener.class, this);
        if (this.oldSlot != -1) {
            TunnellerMod.mc.thePlayer.inventory.currentItem = this.oldSlot;
            this.oldSlot = -1;
        }
        this.currentDamage = 0.0f;
        this.shouldRenderESP = false;
    }

    private BlockPos find() {
        BlockPos closest = null;
        float closestDistance = 16.0f;
        int y = 2;
        while (y >= 0) {
            int x = 1;
            while (x >= -1) {
                int z = 1;
                while (z >= -1) {
                    if (TunnellerMod.mc.thePlayer != null) {
                        int posX = (int)(Math.floor(TunnellerMod.mc.thePlayer.posX) + (double)x);
                        int posY = (int)(Math.floor(TunnellerMod.mc.thePlayer.posY) + (double)y);
                        int posZ = (int)(Math.floor(TunnellerMod.mc.thePlayer.posZ) + (double)z);
                        BlockPos blockPos = new BlockPos(posX, posY, posZ);
                        Block block = TunnellerMod.mc.theWorld.getBlockState(blockPos).getBlock();
                        float xDiff = (float)(TunnellerMod.mc.thePlayer.posX - (double)posX);
                        float yDiff = (float)(TunnellerMod.mc.thePlayer.posY - (double)posY);
                        float zDiff = (float)(TunnellerMod.mc.thePlayer.posZ - (double)posZ);
                        float currentDistance = xDiff + yDiff + zDiff;
                        if (!(Block.getIdFromBlock(block) == 0 || posY < 0 || TunnellerMod.wurst.mods.nukerMod.getMode() == 3 && block.getPlayerRelativeBlockHardness(TunnellerMod.mc.theWorld.getBlockState(blockPos), TunnellerMod.mc.thePlayer, TunnellerMod.mc.theWorld, blockPos) < 1.0f)) {
                            this.side = TunnellerMod.mc.objectMouseOver.sideHit;
                            if (closest == null) {
                                closest = blockPos;
                                closestDistance = currentDistance;
                            } else if (currentDistance < closestDistance) {
                                closest = blockPos;
                                closestDistance = currentDistance;
                            }
                        }
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
        return closest;
    }

    private void nukeAll() {
        int y = 2;
        while (y >= 0) {
            int x = 1;
            while (x >= -1) {
                int z = 1;
                while (z >= -1) {
                    int posZ;
                    int posY;
                    int posX = (int)(Math.floor(TunnellerMod.mc.thePlayer.posX) + (double)x);
                    BlockPos blockPos = new BlockPos(posX, posY = (int)(Math.floor(TunnellerMod.mc.thePlayer.posY) + (double)y), posZ = (int)(Math.floor(TunnellerMod.mc.thePlayer.posZ) + (double)z));
                    Block block = TunnellerMod.mc.theWorld.getBlockState(blockPos).getBlock();
                    if (!(Block.getIdFromBlock(block) == 0 || posY < 0 || TunnellerMod.wurst.mods.nukerMod.getMode() == 3 && block.getPlayerRelativeBlockHardness(TunnellerMod.mc.theWorld.getBlockState(blockPos), TunnellerMod.mc.thePlayer, TunnellerMod.mc.theWorld, blockPos) < 1.0f)) {
                        this.side = TunnellerMod.mc.objectMouseOver.sideHit;
                        this.shouldRenderESP = true;
                        BlockUtils.faceBlockPacket(this.pos);
                        TunnellerMod.mc.thePlayer.sendQueue.addToSendQueue(new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, blockPos, this.side));
                        block.onBlockDestroyedByPlayer(TunnellerMod.mc.theWorld, blockPos, TunnellerMod.mc.theWorld.getBlockState(blockPos));
                    }
                    --z;
                }
                --x;
            }
            --y;
        }
    }
}

