/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import tk.wurst_client.WurstClient;
import tk.wurst_client.analytics.AnalyticsManager;
import tk.wurst_client.commands.CmdManager;
import tk.wurst_client.mods.ModManager;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.special.SpfManager;

public class Navigator {
    private ArrayList<NavigatorItem> navigatorList = new ArrayList();
    private final HashMap<String, Long> preferences = new HashMap();
    public AnalyticsManager analytics = new AnalyticsManager("UA-52838431-7", "navigator.client.wurst-client.tk");

    public Navigator() {
        int n;
        Field[] modFields = ModManager.class.getFields();
        try {
            Field[] fieldArray = modFields;
            n = modFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().endsWith("Mod")) {
                    this.navigatorList.add((NavigatorItem)field.get(WurstClient.INSTANCE.mods));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Field[] cmdFields = CmdManager.class.getFields();
        try {
            Field[] fieldArray = cmdFields;
            int n3 = cmdFields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (field.getName().endsWith("Cmd")) {
                    this.navigatorList.add((NavigatorItem)field.get(WurstClient.INSTANCE.commands));
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Field[] specialFields = SpfManager.class.getFields();
        try {
            Field[] fieldArray = specialFields;
            int n4 = specialFields.length;
            int n5 = 0;
            while (n5 < n4) {
                Field field = fieldArray[n5];
                if (field.getName().endsWith("Spf")) {
                    this.navigatorList.add((NavigatorItem)field.get(WurstClient.INSTANCE.special));
                }
                ++n5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyNavigatorList(ArrayList<NavigatorItem> list) {
        if (!list.equals(this.navigatorList)) {
            list.clear();
            list.addAll(this.navigatorList);
        }
    }

    public void getSearchResults(ArrayList<NavigatorItem> list, final String query) {
        list.clear();
        for (NavigatorItem mod : this.navigatorList) {
            if (!mod.getName().toLowerCase().contains(query) && !mod.getTags().toLowerCase().contains(query) && !mod.getDescription().toLowerCase().contains(query)) continue;
            list.add(mod);
        }
        list.sort(new Comparator<NavigatorItem>(){

            @Override
            public int compare(NavigatorItem o1, NavigatorItem o2) {
                int result = this.compareNext(o1.getName(), o2.getName());
                if (result != 0) {
                    return result;
                }
                result = this.compareNext(o1.getTags(), o2.getTags());
                if (result != 0) {
                    return result;
                }
                result = this.compareNext(o1.getDescription(), o2.getDescription());
                return result;
            }

            private int compareNext(String o1, String o2) {
                int index2;
                int index1 = o1.toLowerCase().indexOf(query);
                if (index1 == (index2 = o2.toLowerCase().indexOf(query))) {
                    return 0;
                }
                if (index1 == -1) {
                    return 1;
                }
                if (index2 == -1) {
                    return -1;
                }
                return index1 - index2;
            }
        });
    }

    public long getPreference(String feature) {
        Long preference = this.preferences.get(feature);
        if (preference == null) {
            preference = 0L;
        }
        return preference;
    }

    public void addPreference(String feature) {
        Long preference = this.preferences.get(feature);
        if (preference == null) {
            preference = 0L;
        }
        preference = preference + 1L;
        this.preferences.put(feature, preference);
    }

    public void setPreference(String feature, long preference) {
        this.preferences.put(feature, preference);
    }

    public void forEach(Consumer<NavigatorItem> action) {
        this.navigatorList.forEach(action);
    }

    public Iterator<NavigatorItem> iterator() {
        return this.navigatorList.iterator();
    }

    public void sortFeatures() {
        this.navigatorList.sort(new Comparator<NavigatorItem>(){

            @Override
            public int compare(NavigatorItem o1, NavigatorItem o2) {
                long preference2;
                long preference1 = Navigator.this.getPreference(o1.getName());
                if (preference1 < (preference2 = Navigator.this.getPreference(o2.getName()))) {
                    return 1;
                }
                if (preference1 > preference2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public int countAllFeatures() {
        return this.navigatorList.size();
    }
}

