/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.SoundEvents;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.WurstClient;
import tk.wurst_client.font.Fonts;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorMainScreen;
import tk.wurst_client.navigator.gui.NavigatorNewKeybindScreen;
import tk.wurst_client.navigator.gui.NavigatorRemoveKeybindScreen;
import tk.wurst_client.navigator.gui.NavigatorScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;
import tk.wurst_client.utils.MiscUtils;

public class NavigatorFeatureScreen
extends NavigatorScreen {
    private NavigatorItem item;
    private NavigatorMainScreen parent;
    private ButtonData activeButton;
    private GuiButton primaryButton;
    private int sliding = -1;
    private String text;
    private ArrayList<ButtonData> buttonDatas = new ArrayList();
    private ArrayList<SliderData> sliderDatas = new ArrayList();
    private ArrayList<CheckboxData> checkboxDatas = new ArrayList();

    public NavigatorFeatureScreen(NavigatorItem item, NavigatorMainScreen parent) {
        this.item = item;
        this.parent = parent;
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        WurstClient wurst = WurstClient.INSTANCE;
        switch (button.id) {
            case 0: {
                this.item.doPrimaryAction();
                this.primaryButton.displayString = this.item.getPrimaryAction();
                break;
            }
            case 1: {
                MiscUtils.openLink("https://www.wurst-client.tk/wiki/" + this.item.getTutorialPage() + "/");
                wurst.navigator.analytics.trackEvent("tutorial", "open", this.item.getName());
            }
        }
        wurst.navigator.addPreference(this.item.getName());
        wurst.files.saveNavigatorData();
    }

    @Override
    protected void onResize() {
        NavigatorItem[] seeAlso;
        ArrayList<PossibleKeybind> possibleKeybinds;
        boolean hasTutorial;
        this.buttonDatas.clear();
        String primaryAction = this.item.getPrimaryAction();
        boolean hasPrimaryAction = !primaryAction.isEmpty();
        boolean bl = hasTutorial = !this.item.getTutorialPage().isEmpty();
        if (hasPrimaryAction) {
            this.primaryButton = new GuiButton(0, this.width / 2 - 151, this.height - 65, hasTutorial ? 149 : 302, 18, primaryAction);
            this.buttonList.add(this.primaryButton);
        }
        if (hasTutorial) {
            this.buttonList.add(new GuiButton(1, this.width / 2 + (hasPrimaryAction ? 2 : -151), this.height - 65, hasPrimaryAction ? 149 : 302, 20, "Tutorial"));
        }
        this.text = "Type: " + this.item.getType();
        String description = this.item.getDescription();
        if (!description.isEmpty()) {
            this.text = String.valueOf(this.text) + "\n\nDescription:\n" + description;
        }
        Rectangle area = new Rectangle(this.middleX - 154, 60, 308, this.height - 103);
        ArrayList<NavigatorSetting> settings = this.item.getSettings();
        if (!settings.isEmpty()) {
            this.text = String.valueOf(this.text) + "\n\nSettings:";
            this.sliderDatas.clear();
            this.checkboxDatas.clear();
            for (NavigatorSetting setting : settings) {
                setting.addToFeatureScreen(this);
            }
        }
        if (!(possibleKeybinds = this.item.getPossibleKeybinds()).isEmpty()) {
            this.text = String.valueOf(this.text) + "\n\nKeybinds:";
            ButtonData addKeybindButton = new ButtonData(this, area.x + area.width - 16, area.y + Fonts.segoe15.getStringHeight(this.text) - 8, 12, 8, "+", 65280){

                @Override
                public void press() {
                    mc.displayGuiScreen(new NavigatorNewKeybindScreen(possibleKeybinds, this));
                }
            };
            this.buttonDatas.add(addKeybindButton);
            HashMap<String, String> possibleKeybindsMap = new HashMap<String, String>();
            for (PossibleKeybind possibleKeybind : possibleKeybinds) {
                possibleKeybindsMap.put(possibleKeybind.getCommand(), possibleKeybind.getDescription());
            }
            final TreeMap<String, PossibleKeybind> existingKeybinds = new TreeMap<String, PossibleKeybind>();
            boolean noKeybindsSet = true;
            for (Map.Entry entry : WurstClient.INSTANCE.keybinds.entrySet()) {
                String keybindDescription = (String)possibleKeybindsMap.get(entry.getValue());
                if (keybindDescription == null) continue;
                if (noKeybindsSet) {
                    noKeybindsSet = false;
                }
                this.text = String.valueOf(this.text) + "\n" + (String)entry.getKey() + ": " + keybindDescription;
                existingKeybinds.put((String)entry.getKey(), new PossibleKeybind((String)entry.getValue(), keybindDescription));
            }
            if (noKeybindsSet) {
                this.text = String.valueOf(this.text) + "\nNone";
            } else {
                this.buttonDatas.add(new ButtonData(this, addKeybindButton.x, addKeybindButton.y, addKeybindButton.width, addKeybindButton.height, "-", 0xFF0000){

                    @Override
                    public void press() {
                        mc.displayGuiScreen(new NavigatorRemoveKeybindScreen(existingKeybinds, this));
                    }
                });
                addKeybindButton.x -= 16;
            }
        }
        if ((seeAlso = this.item.getSeeAlso()).length != 0) {
            this.text = String.valueOf(this.text) + "\n\nSee also:\n";
            int i = 0;
            while (i < seeAlso.length) {
                int y = 60 + this.getTextHeight() + 2;
                final NavigatorItem seeAlsoItem = seeAlso[i];
                String name = seeAlsoItem.getName();
                this.text = String.valueOf(this.text) + "- " + name + (i == seeAlso.length - 1 ? "" : "\n");
                this.buttonDatas.add(new ButtonData(this, this.middleX - 148, y, Fonts.segoe15.getStringWidth(name) + 3, 8, "", 0x404040){

                    @Override
                    public void press() {
                        mc.displayGuiScreen(new NavigatorFeatureScreen(seeAlsoItem, parent));
                    }
                });
                ++i;
            }
        }
        this.setContentHeight(Fonts.segoe15.getStringHeight(this.text));
    }

    @Override
    protected void onKeyPress(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.parent.setExpanding(false);
            this.mc.displayGuiScreen(this.parent);
        }
    }

    @Override
    protected void onMouseClick(int x, int y, int button) {
        Rectangle area = new Rectangle(this.width / 2 - 154, 60, 308, this.height - 103);
        if (!area.contains(x, y)) {
            return;
        }
        if (this.activeButton != null) {
            this.mc.getSoundHandler().playSound(PositionedSoundRecord.createPositionedSoundRecord(SoundEvents.ui_button_click, 1.0f));
            this.activeButton.press();
            WurstClient wurst = WurstClient.INSTANCE;
            wurst.navigator.addPreference(this.item.getName());
            wurst.files.saveNavigatorData();
            return;
        }
        area.height = 12;
        int i = 0;
        while (i < this.sliderDatas.size()) {
            area.y = this.sliderDatas.get((int)i).y + this.scroll;
            if (area.contains(x, y)) {
                this.sliding = i;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.checkboxDatas.size()) {
            CheckboxData checkboxData = this.checkboxDatas.get(i);
            area.y = checkboxData.y + this.scroll;
            if (area.contains(x, y)) {
                checkboxData.checked = !checkboxData.checked;
                checkboxData.toggle();
                WurstClient wurst = WurstClient.INSTANCE;
                wurst.navigator.addPreference(this.item.getName());
                wurst.files.saveNavigatorData();
                return;
            }
            ++i;
        }
    }

    @Override
    protected void onMouseDrag(int x, int y, int button, long timeDragged) {
        if (button != 0) {
            return;
        }
        if (this.sliding != -1) {
            this.sliderDatas.get(this.sliding).slideTo(x);
        }
    }

    @Override
    protected void onMouseRelease(int x, int y, int button) {
        if (this.sliding != -1) {
            WurstClient wurst = WurstClient.INSTANCE;
            this.sliding = -1;
            wurst.navigator.addPreference(this.item.getName());
            wurst.files.saveNavigatorData();
        }
    }

    @Override
    protected void onUpdate() {
    }

    @Override
    protected void onRender(int mouseX, int mouseY, float partialTicks) {
        int y2;
        int y1;
        int x2;
        int x1;
        this.drawCenteredString(Fonts.segoe22, this.item.getName(), this.middleX, 32, 0xFFFFFF);
        GL11.glDisable((int)3553);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.height - 43;
        RenderUtil.scissorBox(bgx1, bgy1, bgx2, bgy2 - (this.buttonList.isEmpty() ? 0 : 24));
        GL11.glEnable((int)3089);
        for (SliderData sliderData : this.sliderDatas) {
            x1 = bgx1 + 2;
            x2 = bgx2 - 2;
            y1 = sliderData.y + this.scroll + 4;
            y2 = y1 + 4;
            this.setColorToForeground();
            this.drawEngravedBox(x1, y1, x2, y2);
            x1 = sliderData.x;
            x2 = x1 + 8;
            float percentage = sliderData.percentage;
            GL11.glColor4f((float)percentage, (float)(1.0f - percentage), (float)0.0f, (float)0.75f);
            this.drawBox(x1, y1 -= 2, x2, y2 += 2);
            String value = sliderData.value;
            x1 = bgx2 - Fonts.segoe15.getStringWidth(value) - 2;
            this.drawString(Fonts.segoe15, value, x1, y1 -= 12, 0xFFFFFF);
            GL11.glDisable((int)3553);
        }
        this.activeButton = null;
        for (ButtonData buttonData : this.buttonDatas) {
            float alpha;
            x1 = buttonData.x;
            x2 = x1 + buttonData.width;
            y1 = buttonData.y + this.scroll;
            y2 = y1 + buttonData.height;
            if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                alpha = 0.75f;
                this.activeButton = buttonData;
            } else {
                alpha = 0.375f;
            }
            float[] rgb = buttonData.color.getColorComponents(null);
            GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
            this.drawBox(x1, y1, x2, y2);
            this.drawCenteredString(Fonts.segoe18, buttonData.buttonText, (x1 + x2) / 2 - 1, y1 + (buttonData.height - 12) / 2 - 1, buttonData.textColor);
            GL11.glDisable((int)3553);
        }
        for (CheckboxData checkboxData : this.checkboxDatas) {
            boolean hovering;
            x1 = bgx1 + 2;
            x2 = x1 + 10;
            y1 = checkboxData.y + this.scroll + 2;
            y2 = y1 + 10;
            boolean bl = hovering = mouseX >= x1 && mouseX <= bgx2 - 2 && mouseY >= y1 && mouseY <= y2;
            if (hovering) {
                GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            this.drawBox(x1, y1, x2, y2);
            if (checkboxData.checked) {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(hovering ? 0.75f : 0.375f));
                GL11.glBegin((int)7);
                GL11.glVertex2i((int)(x1 + 3), (int)(y1 + 5));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 8));
                GL11.glVertex2i((int)(x1 + 2), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 7), (int)(y1 + 2));
                GL11.glVertex2i((int)(x1 + 8), (int)(y1 + 3));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 8));
                GL11.glEnd();
                GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)(hovering ? 0.75f : 0.375f));
                GL11.glBegin((int)2);
                GL11.glVertex2i((int)(x1 + 3), (int)(y1 + 5));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 7), (int)(y1 + 2));
                GL11.glVertex2i((int)(x1 + 8), (int)(y1 + 3));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 8));
                GL11.glVertex2i((int)(x1 + 2), (int)(y1 + 6));
                GL11.glEnd();
            }
            this.drawString(Fonts.segoe15, checkboxData.name, x1 += 12, --y1, 0xFFFFFF);
            GL11.glDisable((int)3553);
        }
        this.drawString(Fonts.segoe15, this.text, bgx1 + 2, bgy1 + this.scroll, 0xFFFFFF);
        GL11.glDisable((int)3089);
        int i = 0;
        while (i < this.buttonList.size()) {
            boolean hovering;
            GuiButton button = (GuiButton)this.buttonList.get(i);
            x1 = button.xPosition;
            x2 = x1 + button.getButtonWidth();
            y1 = button.yPosition;
            y2 = y1 + 18;
            boolean bl = hovering = mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
            if (this.item.isEnabled() && button.id == 0) {
                if (this.item.isBlocked()) {
                    GL11.glColor4f((float)(hovering ? 1.0f : 0.875f), (float)0.0f, (float)0.0f, (float)0.25f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)(hovering ? 1.0f : 0.875f), (float)0.0f, (float)0.25f);
                }
            } else if (hovering) {
                GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            GL11.glDisable((int)3553);
            this.drawBox(x1, y1, x2, y2);
            this.drawCenteredString(Fonts.segoe18, button.displayString, (x1 + x2) / 2, y1 + 2, 0xFFFFFF);
            ++i;
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public NavigatorItem getItem() {
        return this.item;
    }

    public int getMiddleX() {
        return this.middleX;
    }

    public void addText(String text) {
        this.text = String.valueOf(this.text) + text;
    }

    public int getTextHeight() {
        return Fonts.segoe15.getStringHeight(this.text);
    }

    public void addButton(ButtonData button) {
        this.buttonDatas.add(button);
    }

    public void addSlider(SliderData slider) {
        this.sliderDatas.add(slider);
    }

    public void addCheckbox(CheckboxData checkbox) {
        this.checkboxDatas.add(checkbox);
    }

    public abstract class ButtonData
    extends Rectangle {
        public String buttonText;
        public Color color;
        public int textColor;

        public ButtonData(int x, int y, int width, int height, String buttonText, int color) {
            super(x, y, width, height);
            this.textColor = 0xFFFFFF;
            this.buttonText = buttonText;
            this.color = new Color(color);
        }

        public abstract void press();
    }

    public abstract class CheckboxData {
        public String name;
        public boolean checked;
        public int y;

        public CheckboxData(String name, boolean checked, int y) {
            this.name = name;
            this.checked = checked;
            this.y = y;
        }

        public abstract void toggle();
    }

    public class SliderData {
        public BasicSlider slider;
        public int x;
        public int y;
        public float percentage;
        public String value;

        public SliderData(BasicSlider slider, int y) {
            this.slider = slider;
            this.y = y;
            this.update();
        }

        private void update() {
            switch (this.slider.getValueDisplay()) {
                case DECIMAL: {
                    this.value = Double.toString(this.slider.getValue());
                    break;
                }
                case DEGREES: {
                    this.value = String.valueOf((int)this.slider.getValue()) + "\u00b0";
                    break;
                }
                case INTEGER: {
                    this.value = Integer.toString((int)this.slider.getValue());
                    break;
                }
                case PERCENTAGE: {
                    this.value = String.valueOf(this.slider.getValue() * 1000000.0 * 100.0 * 1000000.0 / 1.0E12) + "%";
                    break;
                }
                default: {
                    this.value = "";
                }
            }
            this.percentage = (float)((this.slider.getValue() - this.slider.getMinimumValue()) / (this.slider.getMaximumValue() - this.slider.getMinimumValue()));
            this.x = NavigatorFeatureScreen.this.middleX - 154 + (int)(this.percentage * 298.0f) + 1;
        }

        public void slideTo(int mouseX) {
            float mousePercentage = (float)(mouseX - (NavigatorFeatureScreen.this.middleX - 150)) / 298.0f;
            if (mousePercentage > 1.0f) {
                mousePercentage = 1.0f;
            } else if (mousePercentage < 0.0f) {
                mousePercentage = 0.0f;
            }
            this.slider.setValue((double)((long)((this.slider.getMaximumValue() - this.slider.getMinimumValue()) * (double)mousePercentage / this.slider.getIncrement())) * 1000000.0 * this.slider.getIncrement() / 1000000.0 + this.slider.getMinimumValue());
            this.update();
        }
    }
}

