/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import tk.wurst_client.WurstClient;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public abstract class ModeSetting
implements NavigatorSetting {
    private String name;
    private String[] modes;
    private int selected;

    public ModeSetting(String name, String[] modes, int selected) {
        this.name = name;
        this.modes = modes;
        this.selected = selected;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n" + this.name + ":");
        int y = 0;
        final NavigatorFeatureScreen.ButtonData[] buttons = new NavigatorFeatureScreen.ButtonData[this.modes.length];
        int i = 0;
        while (i < this.modes.length) {
            NavigatorFeatureScreen.ButtonData button;
            int x = featureScreen.getMiddleX();
            switch (i % 4) {
                case 0: {
                    x -= 132;
                    featureScreen.addText("\n\n");
                    y = 60 + featureScreen.getTextHeight() - 2;
                    break;
                }
                case 1: {
                    x -= 61;
                    break;
                }
                case 2: {
                    x += 11;
                    break;
                }
                case 3: {
                    x += 83;
                }
            }
            final int iFinal = i;
            NavigatorFeatureScreen navigatorFeatureScreen = featureScreen;
            navigatorFeatureScreen.getClass();
            buttons[i] = button = new NavigatorFeatureScreen.ButtonData(navigatorFeatureScreen, x, y, 50, 16, this.modes[i], i == this.selected ? 65280 : 0x404040){

                @Override
                public void press() {
                    buttons[((ModeSetting)ModeSetting.this).selected].color = new Color(0x404040);
                    this.color = new Color(65280);
                    ModeSetting.this.setSelected(iFinal);
                    WurstClient.INSTANCE.files.saveNavigatorData();
                }
            };
            featureScreen.addButton(button);
            ++i;
        }
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>();
        String fullName = String.valueOf(featureName) + " " + this.name;
        String command = ".setmode " + featureName.toLowerCase() + " " + this.name.toLowerCase().replace(" ", "_") + " ";
        String description = "Set " + fullName + " to ";
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "next", "Next " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "prev", "Previous " + fullName));
        String[] stringArray = this.modes;
        int n = this.modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + mode.toLowerCase(), String.valueOf(description) + mode));
            ++n2;
        }
        return possibleKeybinds;
    }

    protected int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        this.selected = selected;
        this.update();
    }

    public void nextMode() {
        ++this.selected;
        if (this.selected >= this.modes.length) {
            this.selected = 0;
        }
        this.update();
    }

    public void prevMode() {
        --this.selected;
        if (this.selected <= -1) {
            this.selected = this.modes.length - 1;
        }
        this.update();
    }

    public int indexOf(String mode) {
        int i = 0;
        while (i < this.modes.length) {
            if (this.modes[i].equalsIgnoreCase(mode)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void save(JsonObject json) {
        json.addProperty(this.name, (Number)this.selected);
    }

    @Override
    public void load(JsonObject json) {
        this.setSelected(json.get(this.name).getAsInt());
    }
}

