/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.darkstorm.minecraft.gui.component.BoundedRangeComponent;
import org.darkstorm.minecraft.gui.component.basic.BasicSlider;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public abstract class SliderSetting
extends BasicSlider
implements NavigatorSetting {
    public SliderSetting() {
    }

    public SliderSetting(String text, double value, double minimum, double maximum, double increment, BoundedRangeComponent.ValueDisplay display) {
        super(text, value, minimum, maximum, increment, display);
    }

    public SliderSetting(String text, double value, double minimum, double maximum, int increment) {
        super(text, value, minimum, maximum, increment);
    }

    public SliderSetting(String text, double value, double minimum, double maximum) {
        super(text, value, minimum, maximum);
    }

    public SliderSetting(String text, double value) {
        super(text, value);
    }

    public SliderSetting(String text) {
        super(text);
    }

    @Override
    public String getName() {
        return this.getText();
    }

    @Override
    public void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n" + this.getText() + ":\n");
        NavigatorFeatureScreen navigatorFeatureScreen = featureScreen;
        navigatorFeatureScreen.getClass();
        featureScreen.addSlider(navigatorFeatureScreen.new NavigatorFeatureScreen.SliderData(this, 60 + featureScreen.getTextHeight()));
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>();
        String fullName = String.valueOf(featureName) + " " + this.getText();
        String command = ".setslider " + featureName.toLowerCase() + " " + this.getText().toLowerCase().replace(" ", "_") + " ";
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "more", "Increase " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "less", "Decrease " + fullName));
        return possibleKeybinds;
    }

    @Override
    public double getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.update();
    }

    @Override
    public abstract void update();

    public void increaseValue() {
        this.setValue(this.getValue() + this.getIncrement());
    }

    public void decreaseValue() {
        this.setValue(this.getValue() - this.getIncrement());
    }

    @Override
    public void save(JsonObject json) {
        json.addProperty(this.getText(), (Number)this.getValue());
    }

    @Override
    public void load(JsonObject json) {
        this.setValue(json.get(this.getText()).getAsDouble());
    }
}

