/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.utils;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import tk.wurst_client.WurstClient;
import tk.wurst_client.special.TargetSpf;

public class EntityUtils {
    public static boolean lookChanged;
    public static float yaw;
    public static float pitch;

    public static synchronized void faceEntityClient(EntityLivingBase entity) {
        float[] rotations = EntityUtils.getRotationsNeeded(entity);
        if (rotations != null) {
            Minecraft.getMinecraft().thePlayer.rotationYaw = EntityUtils.limitAngleChange(Minecraft.getMinecraft().thePlayer.prevRotationYaw, rotations[0], 55.0f);
            Minecraft.getMinecraft().thePlayer.rotationPitch = rotations[1];
        }
    }

    public static synchronized void faceEntityPacket(EntityLivingBase entity) {
        float[] rotations = EntityUtils.getRotationsNeeded(entity);
        if (rotations != null) {
            yaw = EntityUtils.limitAngleChange(Minecraft.getMinecraft().thePlayer.prevRotationYaw, rotations[0], 55.0f);
            pitch = rotations[1];
            lookChanged = true;
        }
    }

    public static float[] getRotationsNeeded(Entity entity) {
        double diffY;
        if (entity == null) {
            return null;
        }
        double diffX = entity.posX - Minecraft.getMinecraft().thePlayer.posX;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            diffY = entityLivingBase.posY + (double)entityLivingBase.getEyeHeight() * 0.9 - (Minecraft.getMinecraft().thePlayer.posY + (double)Minecraft.getMinecraft().thePlayer.getEyeHeight());
        } else {
            diffY = (entity.boundingBox.minY + entity.boundingBox.maxY) / 2.0 - (Minecraft.getMinecraft().thePlayer.posY + (double)Minecraft.getMinecraft().thePlayer.getEyeHeight());
        }
        double diffZ = entity.posZ - Minecraft.getMinecraft().thePlayer.posZ;
        double dist = MathHelper.sqrt_double(diffX * diffX + diffZ * diffZ);
        float yaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(diffY, dist) * 180.0 / Math.PI));
        return new float[]{Minecraft.getMinecraft().thePlayer.rotationYaw + MathHelper.wrapAngleTo180_float(yaw - Minecraft.getMinecraft().thePlayer.rotationYaw), Minecraft.getMinecraft().thePlayer.rotationPitch + MathHelper.wrapAngleTo180_float(pitch - Minecraft.getMinecraft().thePlayer.rotationPitch)};
    }

    private static final float limitAngleChange(float current, float intended, float maxChange) {
        float change = intended - current;
        if (change > maxChange) {
            change = maxChange;
        } else if (change < -maxChange) {
            change = -maxChange;
        }
        return current + change;
    }

    public static int getDistanceFromMouse(Entity entity) {
        float[] neededRotations = EntityUtils.getRotationsNeeded(entity);
        if (neededRotations != null) {
            float neededYaw = Minecraft.getMinecraft().thePlayer.rotationYaw - neededRotations[0];
            float neededPitch = Minecraft.getMinecraft().thePlayer.rotationPitch - neededRotations[1];
            float distanceFromMouse = MathHelper.sqrt_float(neededYaw * neededYaw + neededPitch * neededPitch);
            return (int)distanceFromMouse;
        }
        return -1;
    }

    public static boolean isCorrectEntity(Object o, boolean ignoreFriends) {
        if (!(o instanceof Entity)) {
            return false;
        }
        if (ignoreFriends && o instanceof EntityPlayer && WurstClient.INSTANCE.friends.contains(((EntityPlayer)o).getName())) {
            return false;
        }
        TargetSpf targetSpf = WurstClient.INSTANCE.special.targetSpf;
        if (((Entity)o).isInvisibleToPlayer(Minecraft.getMinecraft().thePlayer)) {
            return targetSpf.invisibleMobs.isChecked() && o instanceof EntityLiving || targetSpf.invisiblePlayers.isChecked() && o instanceof EntityPlayer;
        }
        if (o instanceof EntityPlayer) {
            return (((EntityPlayer)o).isPlayerSleeping() && targetSpf.sleepingPlayers.isChecked() || !((EntityPlayer)o).isPlayerSleeping() && targetSpf.players.isChecked()) && (!targetSpf.teams.isChecked() || EntityUtils.checkName(((EntityPlayer)o).getDisplayName().getFormattedText()));
        }
        if (o instanceof EntityAgeable || o instanceof EntityAmbientCreature || o instanceof EntityWaterMob) {
            return targetSpf.animals.isChecked() && (!targetSpf.teams.isChecked() || !((Entity)o).hasCustomName() || EntityUtils.checkName(((Entity)o).getCustomNameTag()));
        }
        if (o instanceof EntityMob || o instanceof EntitySlime || o instanceof EntityFlying) {
            return targetSpf.monsters.isChecked() && (!targetSpf.teams.isChecked() || !((Entity)o).hasCustomName() || EntityUtils.checkName(((Entity)o).getCustomNameTag()));
        }
        if (o instanceof EntityGolem) {
            return targetSpf.golems.isChecked() && (!targetSpf.teams.isChecked() || !((Entity)o).hasCustomName() || EntityUtils.checkName(((Entity)o).getCustomNameTag()));
        }
        return false;
    }

    private static boolean checkName(String name) {
        String[] colors = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        boolean[] teamColors = WurstClient.INSTANCE.special.targetSpf.teamColors.getSelected();
        boolean hasKnownColor = false;
        int i = 0;
        while (i < 16) {
            if (name.contains("\u00a7" + colors[i])) {
                hasKnownColor = true;
                if (teamColors[i]) {
                    return true;
                }
            }
            ++i;
        }
        return !hasKnownColor && teamColors[15];
    }

    public static EntityLivingBase getClosestEntity(boolean ignoreFriends, boolean useFOV) {
        EntityLivingBase closestEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, ignoreFriends) || EntityUtils.getDistanceFromMouse((Entity)o) > WurstClient.INSTANCE.mods.killauraMod.fov / 2) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !(en.getHealth() > 0.0f) || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || en.getName().equals(Minecraft.getMinecraft().thePlayer.getName()) || closestEntity != null && !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) < Minecraft.getMinecraft().thePlayer.getDistanceToEntity(closestEntity))) continue;
            closestEntity = en;
        }
        return closestEntity;
    }

    public static ArrayList<EntityLivingBase> getCloseEntities(boolean ignoreFriends, float range) {
        ArrayList<EntityLivingBase> closeEntities = new ArrayList<EntityLivingBase>();
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, ignoreFriends)) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !(en.getHealth() > 0.0f) || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || en.getName().equals(Minecraft.getMinecraft().thePlayer.getName()) || !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) <= range)) continue;
            closeEntities.add(en);
        }
        return closeEntities;
    }

    public static EntityLivingBase getClosestEntityRaw(boolean ignoreFriends) {
        EntityLivingBase closestEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, ignoreFriends)) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !(en.getHealth() > 0.0f) || closestEntity != null && !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) < Minecraft.getMinecraft().thePlayer.getDistanceToEntity(closestEntity))) continue;
            closestEntity = en;
        }
        return closestEntity;
    }

    public static EntityLivingBase getClosestEnemy(EntityLivingBase friend) {
        EntityLivingBase closestEnemy = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, true)) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || o == friend || en.isDead || en.getHealth() <= 0.0f || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || closestEnemy != null && !(Minecraft.getMinecraft().thePlayer.getDistanceToEntity(en) < Minecraft.getMinecraft().thePlayer.getDistanceToEntity(closestEnemy))) continue;
            closestEnemy = en;
        }
        return closestEnemy;
    }

    public static EntityLivingBase searchEntityByIdRaw(UUID ID) {
        EntityLivingBase newEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, false)) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || newEntity != null || !en.getUniqueID().equals(ID)) continue;
            newEntity = en;
        }
        return newEntity;
    }

    public static EntityLivingBase searchEntityByName(String name) {
        EntityLivingBase newEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, false)) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || !Minecraft.getMinecraft().thePlayer.canEntityBeSeen(en) || newEntity != null || !en.getName().equals(name)) continue;
            newEntity = en;
        }
        return newEntity;
    }

    public static EntityLivingBase searchEntityByNameRaw(String name) {
        EntityLivingBase newEntity = null;
        for (Object o : Minecraft.getMinecraft().theWorld.loadedEntityList) {
            if (!EntityUtils.isCorrectEntity(o, false)) continue;
            EntityLivingBase en = (EntityLivingBase)o;
            if (o instanceof EntityPlayerSP || en.isDead || newEntity != null || !en.getName().equals(name)) continue;
            newEntity = en;
        }
        return newEntity;
    }
}

