/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandDebug
extends CommandBase {
    private static final Logger logger = LogManager.getLogger();
    private long profileStartTime;
    private int profileStartTick;

    @Override
    public String getCommandName() {
        return "debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.debug.usage";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.debug.usage", new Object[0]);
        }
        if (args[0].equals("start")) {
            if (args.length != 1) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            CommandDebug.notifyOperators(sender, (ICommand)this, "commands.debug.start", new Object[0]);
            server.enableProfiling();
            this.profileStartTime = MinecraftServer.getCurrentTimeMillis();
            this.profileStartTick = server.getTickCounter();
        } else {
            if (!args[0].equals("stop")) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            if (args.length != 1) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            if (!server.theProfiler.profilingEnabled) {
                throw new CommandException("commands.debug.notStarted", new Object[0]);
            }
            long i = MinecraftServer.getCurrentTimeMillis();
            int j = server.getTickCounter();
            long k = i - this.profileStartTime;
            int l = j - this.profileStartTick;
            this.func_184894_a(k, l, server);
            server.theProfiler.profilingEnabled = false;
            CommandDebug.notifyOperators(sender, (ICommand)this, "commands.debug.stop", Float.valueOf((float)k / 1000.0f), l);
        }
    }

    private void func_184894_a(long p_184894_1_, int p_184894_3_, MinecraftServer p_184894_4_) {
        File file1 = new File(p_184894_4_.getFile("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        file1.getParentFile().mkdirs();
        try {
            FileWriter filewriter = new FileWriter(file1);
            filewriter.write(this.func_184893_b(p_184894_1_, p_184894_3_, p_184894_4_));
            filewriter.close();
        }
        catch (Throwable throwable) {
            logger.error("Could not save profiler results to " + file1, throwable);
        }
    }

    private String func_184893_b(long p_184893_1_, int p_184893_3_, MinecraftServer p_184893_4_) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Profiler Results ----\n");
        stringbuilder.append("// ");
        stringbuilder.append(CommandDebug.getWittyComment());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time span: ").append(p_184893_1_).append(" ms\n");
        stringbuilder.append("Tick span: ").append(p_184893_3_).append(" ticks\n");
        stringbuilder.append("// This is approximately ").append(String.format("%.2f", Float.valueOf((float)p_184893_3_ / ((float)p_184893_1_ / 1000.0f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringbuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.func_184895_a(0, "root", stringbuilder, p_184893_4_);
        stringbuilder.append("--- END PROFILE DUMP ---\n\n");
        return stringbuilder.toString();
    }

    private void func_184895_a(int p_184895_1_, String p_184895_2_, StringBuilder p_184895_3_, MinecraftServer p_184895_4_) {
        List<Profiler.Result> list = p_184895_4_.theProfiler.getProfilingData(p_184895_2_);
        if (list != null && list.size() >= 3) {
            int i = 1;
            while (i < list.size()) {
                Profiler.Result profiler$result = list.get(i);
                p_184895_3_.append(String.format("[%02d] ", p_184895_1_));
                int j = 0;
                while (j < p_184895_1_) {
                    p_184895_3_.append("|   ");
                    ++j;
                }
                p_184895_3_.append(profiler$result.field_76331_c).append(" - ").append(String.format("%.2f", profiler$result.field_76332_a)).append("%/").append(String.format("%.2f", profiler$result.field_76330_b)).append("%\n");
                if (!profiler$result.field_76331_c.equals("unspecified")) {
                    try {
                        this.func_184895_a(p_184895_1_ + 1, String.valueOf(p_184895_2_) + "." + profiler$result.field_76331_c, p_184895_3_, p_184895_4_);
                    }
                    catch (Exception exception) {
                        p_184895_3_.append("[[ EXCEPTION ").append(exception).append(" ]]");
                    }
                }
                ++i;
            }
        }
    }

    private static String getWittyComment() {
        String[] astring = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return astring[(int)(System.nanoTime() % (long)astring.length)];
        }
        catch (Throwable var2) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? CommandDebug.getListOfStringsMatchingLastWord(args, "start", "stop") : Collections.emptyList();
    }
}

