/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.boss.dragon.phase;

import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.boss.dragon.phase.PhaseSittingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class PhaseSittingScanning
extends PhaseSittingBase {
    private int field_188667_b;

    public PhaseSittingScanning(EntityDragon dragonIn) {
        super(dragonIn);
    }

    @Override
    public void func_188659_c() {
        ++this.field_188667_b;
        EntityPlayer entitylivingbase = this.dragon.worldObj.func_184142_a(this.dragon, 20.0, 10.0);
        if (entitylivingbase != null) {
            if (this.field_188667_b > 25) {
                this.dragon.getPhaseManager().func_188758_a(PhaseList.SITTING_ATTACKING);
            } else {
                Vec3d vec3d = new Vec3d(entitylivingbase.posX - this.dragon.posX, 0.0, entitylivingbase.posZ - this.dragon.posZ).normalize();
                Vec3d vec3d1 = new Vec3d(MathHelper.sin(this.dragon.rotationYaw * ((float)Math.PI / 180)), 0.0, -MathHelper.cos(this.dragon.rotationYaw * ((float)Math.PI / 180))).normalize();
                float f = (float)vec3d1.dotProduct(vec3d);
                float f1 = (float)(Math.acos(f) * 57.29577951308232) + 0.5f;
                if (f1 < 0.0f || f1 > 10.0f) {
                    float f2;
                    double d0 = entitylivingbase.posX - this.dragon.dragonPartHead.posX;
                    double d1 = entitylivingbase.posZ - this.dragon.dragonPartHead.posZ;
                    double d2 = MathHelper.clamp_double(MathHelper.wrapAngleTo180_double(180.0 - MathHelper.atan2(d0, d1) * 57.29577951308232 - (double)this.dragon.rotationYaw), -100.0, 100.0);
                    this.dragon.randomYawVelocity *= 0.8f;
                    float f3 = f2 = MathHelper.sqrt_double(d0 * d0 + d1 * d1) + 1.0f;
                    if (f2 > 40.0f) {
                        f2 = 40.0f;
                    }
                    this.dragon.randomYawVelocity = (float)((double)this.dragon.randomYawVelocity + d2 * (double)(0.7f / f2 / f3));
                    this.dragon.rotationYaw += this.dragon.randomYawVelocity;
                }
            }
        } else if (this.field_188667_b >= 100) {
            entitylivingbase = this.dragon.worldObj.func_184142_a(this.dragon, 150.0, 150.0);
            this.dragon.getPhaseManager().func_188758_a(PhaseList.TAKEOFF);
            if (entitylivingbase != null) {
                this.dragon.getPhaseManager().func_188758_a(PhaseList.CHARGING_PLAYER);
                this.dragon.getPhaseManager().func_188757_b(PhaseList.CHARGING_PLAYER).func_188668_a(new Vec3d(entitylivingbase.posX, entitylivingbase.posY, entitylivingbase.posZ));
            }
        }
    }

    @Override
    public void func_188660_d() {
        this.field_188667_b = 0;
    }

    public PhaseList<PhaseSittingScanning> func_188652_i() {
        return PhaseList.SITTING_SCANNING;
    }
}

