/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Multimap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemTool
extends Item {
    private Set<Block> effectiveBlocks;
    protected float efficiencyOnProperMaterial = 4.0f;
    protected float damageVsEntity;
    protected float field_185065_c;
    protected Item.ToolMaterial toolMaterial;

    protected ItemTool(float p_i46745_1_, float p_i46745_2_, Item.ToolMaterial p_i46745_3_, Set<Block> p_i46745_4_) {
        this.toolMaterial = p_i46745_3_;
        this.effectiveBlocks = p_i46745_4_;
        this.maxStackSize = 1;
        this.setMaxDamage(p_i46745_3_.getMaxUses());
        this.efficiencyOnProperMaterial = p_i46745_3_.getEfficiencyOnProperMaterial();
        this.damageVsEntity = p_i46745_1_ + p_i46745_3_.getDamageVsEntity();
        this.field_185065_c = p_i46745_2_;
        this.setCreativeTab(CreativeTabs.tabTools);
    }

    protected ItemTool(Item.ToolMaterial p_i46746_1_, Set<Block> p_i46746_2_) {
        this(0.0f, 0.0f, p_i46746_1_, p_i46746_2_);
    }

    @Override
    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        return this.effectiveBlocks.contains(state.getBlock()) ? this.efficiencyOnProperMaterial : 1.0f;
    }

    @Override
    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.damageItem(2, attacker);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if ((double)blockIn.getBlockHardness(worldIn, pos) != 0.0) {
            stack.damageItem(1, playerIn);
        }
        return true;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    @Override
    public int getItemEnchantability() {
        return this.toolMaterial.getEnchantability();
    }

    public String getToolMaterialName() {
        return this.toolMaterial.toString();
    }

    @Override
    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        return this.toolMaterial.getRepairItem() == repair.getItem() ? true : super.getIsRepairable(toRepair, repair);
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot p_111205_1_) {
        Multimap<String, AttributeModifier> multimap = super.getItemAttributeModifiers(p_111205_1_);
        if (p_111205_1_ == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getAttributeUnlocalizedName(), (Object)new AttributeModifier(itemModifierUUID, "Tool modifier", this.damageVsEntity, 0));
            multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", this.field_185065_c, 0));
        }
        return multimap;
    }
}

