/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;

public class FontUtils {
    public static Properties readFontProperties(kl locationFontTexture) {
        String fontFileName = locationFontTexture.a();
        Properties props = new Properties();
        String suffix = ".png";
        if (!fontFileName.endsWith(suffix)) {
            return props;
        }
        String fileName = fontFileName.substring(0, fontFileName.length() - suffix.length()) + ".properties";
        try {
            kl locProp = new kl(locationFontTexture.b(), fileName);
            InputStream in = Config.getResourceStream(Config.getResourceManager(), locProp);
            if (in == null) {
                return props;
            }
            Config.log("Loading " + fileName);
            props.load(in);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public static void readCustomCharWidths(Properties props, float[] charWidth) {
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String value;
            float width;
            String numStr;
            int num;
            String prefix;
            if (!string.startsWith(prefix = "width.") || (num = Config.parseInt(numStr = string.substring(prefix.length()), -1)) < 0 || num >= charWidth.length || !((width = Config.parseFloat(value = props.getProperty(string), -1.0f)) >= 0.0f)) continue;
            charWidth[num] = width;
        }
    }

    public static float readFloat(Properties props, String key, float defOffset) {
        String str = props.getProperty(key);
        if (str == null) {
            return defOffset;
        }
        float offset = Config.parseFloat(str, Float.MIN_VALUE);
        if (offset == Float.MIN_VALUE) {
            Config.warn("Invalid value for " + key + ": " + str);
            return defOffset;
        }
        return offset;
    }

    public static kl getHdFontLocation(kl fontLoc) {
        if (!Config.isCustomFonts()) {
            return fontLoc;
        }
        if (fontLoc == null) {
            return fontLoc;
        }
        String fontName = fontLoc.a();
        String texturesStr = "textures/";
        String mcpatcherStr = "mcpatcher/";
        if (!fontName.startsWith(texturesStr)) {
            return fontLoc;
        }
        fontName = fontName.substring(texturesStr.length());
        fontName = mcpatcherStr + fontName;
        kl fontLocHD = new kl(fontLoc.b(), fontName);
        if (Config.hasResource(Config.getResourceManager(), fontLocHD)) {
            return fontLocHD;
        }
        return fontLoc;
    }
}

