#version 120

uniform sampler2D DiffuseSampler;

varying vec2 texCoord;
varying vec2 oneTexel;

uniform vec2 InSize;

uniform vec2 BlurDir;
uniform float Radius;

vec4 toLinear (vec4 color){
    return pow(color,vec4(2.2));
}

float toLinear (float value){
    return pow(value,2.2);
}

vec4 toGamma (vec4 color){
    return pow(color,vec4(1.0/2.2));
}

float toGamma (float value){
    return pow(value,1.0/2.2);
}

void main() {

    vec4 blurred = vec4(0.0);
    float totalStrength = 0.0;

    for(float r = -Radius; r <= Radius; r += 1.0) {
        float strength = (Radius+1.0-abs(r))/Radius;
        totalStrength += strength;
        blurred += toLinear(texture2D(DiffuseSampler, texCoord + oneTexel * r * BlurDir)) * strength;
    }
    gl_FragColor = toGamma(vec4(blurred.rgb / totalStrength, 1.0));

}
