/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.command.commands.main;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.command.AClientCommand;
import de.paxii.clarinet.command.CommandCategory;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.chat.ChatColor;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;

public class CommandHelp
extends AClientCommand {
    @Override
    public String getCommand() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Command Help";
    }

    @Override
    public void runCommand(String[] args) {
        if (args.length == 0) {
            TreeMap<String, Module> sortedModules = new TreeMap<String, Module>(Wrapper.getModuleManager().getModuleList());
            Chat.printClientMessage("--------------------------------------------");
            Chat.printClientMessage("Module commands:");
            for (Map.Entry<String, Module> moduleEntry : sortedModules.entrySet()) {
                Module module = moduleEntry.getValue();
                if (!module.isCommand()) continue;
                Chat.printClientMessage(module.getName() + ": " + module.getDescription());
            }
            TreeMap<String, AClientCommand> sortedCommands = new TreeMap<String, AClientCommand>((SortedMap<String, AClientCommand>)Wrapper.getConsole().getCommandList());
            Chat.printClientMessage("--------------------------------------------");
            Chat.printClientMessage("Commands:");
            for (Map.Entry entry : sortedCommands.entrySet()) {
                AClientCommand command = (AClientCommand)entry.getValue();
                Chat.printClientMessage(command.getCommand() + ": " + command.getDescription());
            }
            Chat.printClientMessage("--------------------------------------------");
        } else {
            String searchString = args[0].toLowerCase();
            if (Wrapper.getConsole().getCommandList().containsKey(searchString)) {
                AClientCommand command = Wrapper.getConsole().getCommandList().get(searchString);
                Chat.printClientMessage("--------------------------------------------");
                Chat.printClientMessage(command.getCommand() + " Help:");
                Chat.printClientMessage("Description: " + command.getDescription());
                Chat.printClientMessage("Syntax: " + command.getUsage());
            } else if (Wrapper.getModuleManager().doesModuleExist(searchString)) {
                Module module = Wrapper.getModuleManager().getModuleIgnoreCase(searchString);
                Chat.printClientMessage("--------------------------------------------");
                Chat.printClientMessage(module.getName() + " Help:");
                Chat.printClientMessage("Description: " + module.getDescription());
                if (module.isCommand()) {
                    Chat.printClientMessage("Syntax: " + module.getSyntax());
                }
                TextComponentString textComponent = new TextComponentString(Chat.getPrefix() + "Documentation: ");
                TextComponentString textComponentString = new TextComponentString("Click here");
                Style chatStyle = new Style();
                chatStyle.setUnderlined(true);
                chatStyle.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, module.getHelpUrl()));
                textComponentString.setStyle(chatStyle);
                textComponent.appendSibling(textComponentString);
                Chat.printChatComponent(textComponent);
                if (module.isPlugin()) {
                    Chat.printClientMessage((Object)((Object)ChatColor.RED) + "Warning: This Module is a Plugin. Documentation URL might be incorrect!");
                }
            } else {
                Chat.printClientMessage(String.format("Could not find the command \"%s\"!", args[0]));
            }
        }
    }

    @Override
    public String getUsage() {
        return "help [command/module]";
    }

    @Override
    public CommandCategory getCategory() {
        return CommandCategory.MAIN;
    }
}

