/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.event;

import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.EventPriority;
import de.paxii.clarinet.event.MethodData;
import de.paxii.clarinet.event.events.Event;
import de.paxii.clarinet.event.events.game.KeyPressedEvent;
import de.paxii.clarinet.event.events.type.EventCancellable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventManager {
    private static final Map<Class<? extends Event>, List<MethodData>> REGISTRY_MAP = new HashMap<Class<? extends Event>, List<MethodData>>();
    private static Event lastCalledEvent;
    private static long lastCalledMS;

    public void register(Object object) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (EventManager.isMethodBad(method)) continue;
            this.register(object, method);
        }
    }

    public void register(Object object, Class<? extends Event> eventClass) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (EventManager.isMethodBad(method, eventClass)) continue;
            this.register(object, method);
        }
    }

    public void unregister(Object object) {
        for (List<MethodData> dataList : REGISTRY_MAP.values()) {
            for (MethodData data : dataList) {
                if (!data.getSource().equals(object)) continue;
                dataList.remove(data);
            }
        }
        EventManager.cleanMap(true);
    }

    public void unregister(Object object, Class<? extends Event> eventClass) {
        if (REGISTRY_MAP.containsKey(eventClass)) {
            for (MethodData data : REGISTRY_MAP.get(eventClass)) {
                if (!data.getSource().equals(object)) continue;
                REGISTRY_MAP.get(eventClass).remove(data);
            }
            EventManager.cleanMap(true);
        }
    }

    private void register(Object object, Method method) {
        Class<?> indexClass = method.getParameterTypes()[0];
        final MethodData methodData = new MethodData(object, method, method.getAnnotation(EventHandler.class).priority());
        methodData.getTarget().setAccessible(true);
        if (REGISTRY_MAP.containsKey(indexClass)) {
            if (!REGISTRY_MAP.get(indexClass).contains(methodData)) {
                REGISTRY_MAP.get(indexClass).add(methodData);
                this.sortListValue(indexClass);
            }
        } else {
            REGISTRY_MAP.put(indexClass, (List<MethodData>)new CopyOnWriteArrayList<MethodData>(){
                private static final long serialVersionUID = 0L;
                {
                    this.add(methodData);
                }
            });
        }
    }

    private void sortListValue(Class<? extends Event> indexClass) {
        CopyOnWriteArrayList<MethodData> sortedList = new CopyOnWriteArrayList<MethodData>();
        for (int priority : EventPriority.getValues()) {
            for (MethodData data : REGISTRY_MAP.get(indexClass)) {
                if (data.getPriority() != priority) continue;
                sortedList.add(data);
            }
        }
        REGISTRY_MAP.put(indexClass, sortedList);
    }

    public static void cleanMap(boolean onlyEmptyEntries) {
        Iterator<Map.Entry<Class<? extends Event>, List<MethodData>>> mapIterator = REGISTRY_MAP.entrySet().iterator();
        while (mapIterator.hasNext()) {
            if (onlyEmptyEntries && !mapIterator.next().getValue().isEmpty()) continue;
            mapIterator.remove();
        }
    }

    private static boolean isMethodBad(Method method) {
        return method.getParameterTypes().length != 1 || !method.isAnnotationPresent(EventHandler.class);
    }

    private static boolean isMethodBad(Method method, Class<? extends Event> eventClass) {
        return EventManager.isMethodBad(method) || !method.getParameterTypes()[0].equals(eventClass);
    }

    public static final Event call(Event event) {
        block8: {
            List<MethodData> dataList;
            if (event instanceof KeyPressedEvent) {
                if (lastCalledMS != 0L) {
                    if (lastCalledMS + 10L >= System.currentTimeMillis() && ((KeyPressedEvent)event).getKey() == ((KeyPressedEvent)lastCalledEvent).getKey()) {
                        return event;
                    }
                } else {
                    lastCalledEvent = event;
                    lastCalledMS = System.currentTimeMillis();
                }
            }
            if ((dataList = REGISTRY_MAP.get(event.getClass())) == null) break block8;
            if (event instanceof EventCancellable) {
                EventCancellable cancellable = (EventCancellable)event;
                for (MethodData data : dataList) {
                    EventManager.invoke(data, event);
                    if (!cancellable.isCancelled()) continue;
                    break;
                }
            } else {
                for (MethodData data : dataList) {
                    EventManager.invoke(data, event);
                }
            }
        }
        return event;
    }

    private static void invoke(MethodData data, Event argument) {
        try {
            data.getTarget().invoke(data.getSource(), argument);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

