/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.ingame.panel;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.gui.ingame.panel.element.PanelElement;
import java.util.ArrayList;

public class GuiPanel {
    private String panelName;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private int titleHeight = 12;
    private int scrollY;
    private int dragX;
    private int dragY;
    private boolean dragging;
    private boolean opened;
    private boolean pinned;
    private boolean visible = true;
    private boolean scrollable;
    ArrayList<PanelElement> panelElements;

    public GuiPanel(String panelName, int panelX, int panelY) {
        this(panelName, panelX, panelY, 100, 200);
    }

    public GuiPanel(String panelName, int panelX, int panelY, int panelWidth, int panelHeight) {
        this(panelName, panelX, panelY, panelWidth, panelHeight, true);
    }

    public GuiPanel(String panelName, int panelX, int panelY, int panelWidth, int panelHeight, boolean isOpened) {
        this(panelName, panelX, panelY, panelWidth, panelHeight, isOpened, true);
    }

    public GuiPanel(String panelName, int panelX, int panelY, int panelWidth, int panelHeight, boolean isOpened, boolean isVisible) {
        this.panelName = panelName;
        this.panelX = panelX;
        this.panelY = panelY;
        this.panelWidth = panelWidth;
        this.panelHeight = panelHeight;
        this.panelElements = new ArrayList();
        this.setOpened(isOpened);
        this.setVisible(isVisible);
        this.addElements();
    }

    public void addElements() {
    }

    public int calculateHeight() {
        int height = 20;
        for (PanelElement panelElement : this.getPanelElements()) {
            height += panelElement.getElementHeight() + panelElement.getElementYOffset();
        }
        return height;
    }

    public void drawPanel(int mouseX, int mouseY) {
        this.setPanelHeight(this.calculateHeight());
        if (this.isDragging()) {
            this.setPanelX(mouseX + this.dragX);
            this.setPanelY(mouseY + this.dragY);
        }
        Wrapper.getClickableGui().getCurrentTheme().drawPanel(this, mouseX, mouseY);
    }

    public void mouseClicked(int mouseX, int mouseY, int buttonClicked) {
        if (this.isMouseOverCollapseButton(mouseX, mouseY) && buttonClicked == 0) {
            this.setOpened(!this.isOpened());
            return;
        }
        if (this.isMouseOverTitle(mouseX, mouseY) && buttonClicked == 0) {
            this.setDragging(true);
            this.dragX = this.getPanelX() - mouseX;
            this.dragY = this.getPanelY() - mouseY;
        }
        if (this.isOpened() && this.isMouseOverPanel(mouseX, mouseY)) {
            for (PanelElement panelElement : this.getPanelElements()) {
                panelElement.mouseClicked(mouseX, mouseY, buttonClicked);
            }
        }
    }

    public boolean isMouseOverPanel(int mouseX, int mouseY) {
        boolean rightX;
        boolean bl = rightX = mouseX >= this.getPanelX() && mouseX <= this.getPanelX() + this.getPanelWidth();
        boolean rightY = mouseY >= this.getPanelY() && mouseY <= this.getPanelY() + (this.isOpened() ? this.getPanelHeight() : this.getTitleHeight());
        return rightX && rightY;
    }

    public boolean isMouseOverTitle(int mouseX, int mouseY) {
        boolean rightX = mouseX >= this.getPanelX() && mouseX <= this.getPanelX() + this.getPanelWidth();
        boolean rightY = mouseY >= this.getPanelY() && mouseY <= this.getPanelY() + this.getTitleHeight();
        return rightX && rightY;
    }

    public boolean isMouseOverCollapseButton(int mouseX, int mouseY) {
        return mouseX >= this.getPanelX() + this.getPanelWidth() - 11 && mouseX <= this.getPanelX() + this.getPanelWidth() - 2 && mouseY >= this.getPanelY() + 2 && mouseY <= this.getPanelY() + this.getTitleHeight() - 2;
    }

    public boolean isMouseOverAll(int mouseX, int mouseY) {
        if (this.isMouseOverPanel(mouseX, mouseY)) {
            for (GuiPanel guiPanel : Wrapper.getClickableGui().getGuiPanels()) {
                if (!guiPanel.isVisible() || !guiPanel.isMouseOverPanel(mouseX, mouseY) || Wrapper.getClickableGui().getGuiPanels().indexOf(guiPanel) <= Wrapper.getClickableGui().getGuiPanels().indexOf(this)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public int getPanelX() {
        return this.panelX;
    }

    public int getPanelY() {
        return this.panelY;
    }

    public int getPanelWidth() {
        return this.panelWidth;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setPanelX(int panelX) {
        this.panelX = panelX;
    }

    public void setPanelY(int panelY) {
        this.panelY = panelY;
    }

    public void setPanelWidth(int panelWidth) {
        this.panelWidth = panelWidth;
    }

    public void setPanelHeight(int panelHeight) {
        this.panelHeight = panelHeight;
    }

    public void setTitleHeight(int titleHeight) {
        this.titleHeight = titleHeight;
    }

    public void setScrollY(int scrollY) {
        this.scrollY = scrollY;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public ArrayList<PanelElement> getPanelElements() {
        return this.panelElements;
    }
}

