/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.ingame.panel.theme.themes;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.gui.ingame.panel.GuiPanel;
import de.paxii.clarinet.gui.ingame.panel.element.PanelElement;
import de.paxii.clarinet.gui.ingame.panel.element.elements.PanelButton;
import de.paxii.clarinet.gui.ingame.panel.theme.ClientTheme;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.module.render.ModuleXray;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.render.GuiMethods;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class DefaultClientTheme
extends ClientTheme {
    private ArrayList<DefaultThemeColorObject> colorObjects = new ArrayList();
    private DefaultThemeColorObject currentColor;

    public DefaultClientTheme() {
        this.colorObjects.add(new DefaultThemeColorObject("Blue", -1438682113, -1440274381, -863202407, -858599727, -868256769, -864707329, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Red", -1426128896, -1440274381, -863202407, -858599727, -855703552, -855674768, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Yellow", -1426066944, -1440274381, -863202407, -858599727, -855641600, -855639366, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Green", -1435042048, -1440274381, -863202407, -858599727, -864616704, -859832441, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Purple", -1431820903, -1440274381, -863202407, -858599727, -861395559, -861903206, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Ocker", -1431010470, -1440274381, -863202407, -858599727, -860585126, -860711298, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Orange", -1426089905, -1440274381, -863202407, -858599727, -855664561, -855657084, -1));
        this.colorObjects.add(new DefaultThemeColorObject("Turquoise", -1439369238, -1440274381, -863202407, -858599727, -868943894, -860032274, -1));
        this.currentColor = this.colorObjects.get(0);
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public void drawPanel(GuiPanel guiPanel, int mouseX, int mouseY) {
        if (guiPanel.isOpened()) {
            GuiMethods.drawRoundedRect(guiPanel.getPanelX(), guiPanel.getPanelY(), guiPanel.getPanelX() + guiPanel.getPanelWidth(), guiPanel.getPanelY() + guiPanel.getPanelHeight(), this.currentColor.getPanelBackground(), this.currentColor.getPanelBackground());
            GuiMethods.drawRoundedRect(guiPanel.getPanelX(), guiPanel.getPanelY(), guiPanel.getPanelX() + guiPanel.getPanelWidth(), guiPanel.getPanelY() + guiPanel.getTitleHeight(), this.currentColor.getPanelTitle(), this.currentColor.getPanelTitle());
            GuiMethods.drawRoundedRect(guiPanel.getPanelX() + guiPanel.getPanelWidth() - 11, guiPanel.getPanelY() + 2, guiPanel.getPanelX() + guiPanel.getPanelWidth() - 2, guiPanel.getPanelY() + guiPanel.getTitleHeight() - 2, guiPanel.isMouseOverCollapseButton(mouseX, mouseY) ? this.currentColor.getButtonDisabledBackgroundHovered() : this.currentColor.getButtonDisabledBackground(), guiPanel.isMouseOverCollapseButton(mouseX, mouseY) ? this.currentColor.getButtonDisabledBackgroundHovered() : this.currentColor.getButtonDisabledBackground());
            Wrapper.getFontRenderer().drawString(guiPanel.getPanelName(), guiPanel.getPanelX() + 4, guiPanel.getPanelY() + 2, this.currentColor.getTextColor());
            int index = 17;
            for (PanelElement panelElement : guiPanel.getPanelElements()) {
                if (panelElement instanceof PanelButton) {
                    panelElement.setElementHeight(12);
                    panelElement.setElementYOffset(0);
                }
                panelElement.drawElement(guiPanel.getPanelX() + 5, guiPanel.getPanelY() + index, mouseX, mouseY);
                index += panelElement.getElementHeight();
            }
        } else {
            GuiMethods.drawRoundedRect(guiPanel.getPanelX(), guiPanel.getPanelY(), guiPanel.getPanelX() + guiPanel.getPanelWidth(), guiPanel.getPanelY() + guiPanel.getTitleHeight(), this.currentColor.getPanelTitle(), this.currentColor.getPanelTitle());
            GuiMethods.drawRoundedRect(guiPanel.getPanelX() + guiPanel.getPanelWidth() - 11, guiPanel.getPanelY() + 2, guiPanel.getPanelX() + guiPanel.getPanelWidth() - 2, guiPanel.getPanelY() + guiPanel.getTitleHeight() - 2, guiPanel.isMouseOverCollapseButton(mouseX, mouseY) ? this.currentColor.getButtonDisabledBackgroundHovered() : this.currentColor.getButtonDisabledBackground(), guiPanel.isMouseOverCollapseButton(mouseX, mouseY) ? this.currentColor.getButtonDisabledBackgroundHovered() : this.currentColor.getButtonDisabledBackground());
            Wrapper.getFontRenderer().drawString(guiPanel.getPanelName(), guiPanel.getPanelX() + 4, guiPanel.getPanelY() + 2, this.currentColor.getTextColor());
        }
    }

    @Override
    public void drawButton(Module module, int buttonX, int buttonY, int buttonWidth, int buttonHeight, boolean buttonHovered) {
        int buttonColor = module.isEnabled() ? (buttonHovered ? this.currentColor.getButtonEnabledBackgroundHovered() : this.currentColor.getButtonEnabledBackground()) : (buttonHovered ? this.currentColor.getButtonDisabledBackgroundHovered() : this.currentColor.getButtonDisabledBackground());
        GuiMethods.drawRoundedRect(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight - 1, buttonColor, buttonColor);
        Wrapper.getFontRenderer().drawString(module.getName(), buttonX + 5, buttonY + 2, this.currentColor.getTextColor());
    }

    @Override
    public void drawBlockButton(IBlockState iBlockState, int buttonX, int buttonY, int buttonWidth, int buttonHeight, boolean buttonHovered) {
        int blockID = Block.getIdFromBlock(iBlockState.getBlock());
        boolean isEnabled = ModuleXray.getBlockList().contains(blockID);
        RenderHelper.enableGUIStandardItemLighting();
        Wrapper.getMinecraft().getRenderItem().renderItemAndEffectIntoGUI(new ItemStack(iBlockState.getBlock(), 1), buttonX + 2, buttonY + 2);
        RenderHelper.disableStandardItemLighting();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)255.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        Wrapper.getFontRenderer().drawSplitString(iBlockState.getBlock().getLocalizedName(), buttonX * 2 + 2, buttonY * 2 + 2, 38, -1);
        GL11.glPopMatrix();
        GuiMethods.drawRoundedRect(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, isEnabled ? -16711936 : -65536, 0);
    }

    @Override
    public void drawColorButton(String colorName, int buttonX, int buttonY, int buttonWidth, int buttonHeight, boolean buttonHovered) {
        int buttonColor = this.getCurrentColor().getColorName().equals(colorName) ? (buttonHovered ? this.currentColor.getButtonEnabledBackgroundHovered() : this.currentColor.getButtonEnabledBackground()) : (buttonHovered ? this.currentColor.getButtonDisabledBackgroundHovered() : this.currentColor.getButtonDisabledBackground());
        GuiMethods.drawRoundedRect(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight - 1, buttonColor, buttonColor);
        Wrapper.getFontRenderer().drawString(colorName, buttonX + 5, buttonY + 2, this.currentColor.getTextColor());
    }

    public DefaultThemeColorObject getColorObject(String colorName) {
        for (DefaultThemeColorObject colorObject : this.getColorObjects()) {
            if (!colorObject.getColorName().equalsIgnoreCase(colorName)) continue;
            return colorObject;
        }
        return null;
    }

    @Override
    public void drawSlider(ValueBase valueBase, int sliderX, int sliderY, int sliderWidth, int sliderHeight, float dragX, boolean shouldRound) {
        DecimalFormat format = new DecimalFormat(shouldRound ? "0" : "0.0");
        GuiMethods.drawHLine(sliderX, sliderX + sliderWidth, sliderY + 12, this.currentColor.getButtonDisabledBackground());
        GuiMethods.drawHLine(sliderX, (float)sliderX + dragX, sliderY + 12, this.currentColor.getButtonEnabledBackground());
        GuiMethods.drawFilledCircle(dragX + 3.0f > (float)sliderWidth ? sliderX + sliderWidth : sliderX + (int)dragX + 3, sliderY + 12, 3.0f, this.currentColor.buttonDisabledBackgroundHovered);
        Wrapper.getFontRenderer().drawString(valueBase.getName() + ": " + format.format(valueBase.getValue()), sliderX, sliderY, this.currentColor.getTextColor());
        super.drawSlider(valueBase, sliderX, sliderY, sliderWidth, sliderHeight, dragX, shouldRound);
    }

    public ArrayList<DefaultThemeColorObject> getColorObjects() {
        return this.colorObjects;
    }

    public DefaultThemeColorObject getCurrentColor() {
        return this.currentColor;
    }

    public void setCurrentColor(DefaultThemeColorObject currentColor) {
        this.currentColor = currentColor;
    }

    public class DefaultThemeColorObject {
        private String colorName;
        private int panelTitle = -1438682113;
        private int panelBackground = -1440274381;
        private int buttonDisabledBackground = -863202407;
        private int buttonDisabledBackgroundHovered = -858599727;
        private int buttonEnabledBackground = -868256769;
        private int buttonEnabledBackgroundHovered = -864707329;
        private int textColor = -1;

        public DefaultThemeColorObject(String colorName, int panelTitle, int panelBackground, int buttonDisabledBackground, int buttonDisabledBackgroundHovered, int buttonEnabledBackground, int buttonEnabledBackgroundHovered, int textColor) {
            this.colorName = colorName;
            this.panelTitle = panelTitle;
            this.panelBackground = panelBackground;
            this.buttonDisabledBackground = buttonDisabledBackground;
            this.buttonDisabledBackgroundHovered = buttonDisabledBackgroundHovered;
            this.buttonEnabledBackground = buttonEnabledBackground;
            this.buttonEnabledBackgroundHovered = buttonEnabledBackgroundHovered;
        }

        public String getColorName() {
            return this.colorName;
        }

        public int getPanelTitle() {
            return this.panelTitle;
        }

        public int getPanelBackground() {
            return this.panelBackground;
        }

        public int getButtonDisabledBackground() {
            return this.buttonDisabledBackground;
        }

        public int getButtonDisabledBackgroundHovered() {
            return this.buttonDisabledBackgroundHovered;
        }

        public int getButtonEnabledBackground() {
            return this.buttonEnabledBackground;
        }

        public int getButtonEnabledBackgroundHovered() {
            return this.buttonEnabledBackgroundHovered;
        }

        public int getTextColor() {
            return this.textColor;
        }
    }
}

