/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.gui.ingame.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.game.StartGameEvent;
import de.paxii.clarinet.event.events.game.StopGameEvent;
import de.paxii.clarinet.gui.ingame.panel.GuiPanel;
import de.paxii.clarinet.gui.ingame.panel.theme.themes.DefaultClientTheme;
import de.paxii.clarinet.gui.ingame.settings.PanelSettingsContainer;
import de.paxii.clarinet.util.settings.ClientSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class PanelSettingsHandler {
    public PanelSettingsHandler() {
        Wrapper.getEventManager().register(this);
    }

    @EventHandler
    public void onStartGame(StartGameEvent event) {
        new Thread(() -> {
            try {
                String line;
                BufferedReader br;
                Thread.sleep(6000L);
                Gson gson = new Gson();
                File settingsFile = new File((String)ClientSettings.getClientFolderPath().getValue(), "/panels.json");
                if (settingsFile.exists()) {
                    br = new BufferedReader(new FileReader(settingsFile));
                    String jsonString = "";
                    while ((line = br.readLine()) != null) {
                        jsonString = jsonString + line;
                    }
                    PanelSettingsContainer panelSettingsContainer = (PanelSettingsContainer)gson.fromJson(jsonString, PanelSettingsContainer.class);
                    if (panelSettingsContainer != null) {
                        panelSettingsContainer.getPanelSettings().forEach((panelName, panel) -> {
                            if (Wrapper.getClickableGui().doesPanelExist((String)panelName)) {
                                GuiPanel guiPanel = Wrapper.getClickableGui().getGuiPanel((String)panelName);
                                guiPanel.setPanelX(panel.getPosX());
                                guiPanel.setPanelY(panel.getPosY());
                                guiPanel.setOpened(panel.isOpened());
                                guiPanel.setPinned(panel.isPinned());
                                guiPanel.setVisible(panel.isVisible());
                            }
                        });
                    }
                    br.close();
                }
                try {
                    settingsFile = new File((String)ClientSettings.getClientFolderPath().getValue(), "/color.json");
                    if (settingsFile.exists()) {
                        br = new BufferedReader(new FileReader(settingsFile));
                        while ((line = br.readLine()) != null) {
                            if (line.length() <= 0) continue;
                            String colorName = (String)gson.fromJson(line, String.class);
                            ((DefaultClientTheme)Wrapper.getClickableGui().getTheme("Default")).setCurrentColor(((DefaultClientTheme)Wrapper.getClickableGui().getTheme("Default")).getColorObject(colorName));
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    @EventHandler
    public void onStopGame(StopGameEvent event) {
        block6: {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                File settingsFile = new File((String)ClientSettings.getClientFolderPath().getValue(), "/panels.json");
                if (settingsFile.exists() && !settingsFile.delete()) {
                    return;
                }
                if (!settingsFile.createNewFile()) break block6;
                FileWriter fileWriter = new FileWriter(settingsFile);
                PanelSettingsContainer panelSettingsContainer = new PanelSettingsContainer(Wrapper.getClickableGui().getGuiPanels());
                String jsonString = gson.toJson((Object)panelSettingsContainer);
                fileWriter.write(jsonString);
                fileWriter.close();
                try {
                    settingsFile = new File((String)ClientSettings.getClientFolderPath().getValue(), "/color.json");
                    if (settingsFile.createNewFile()) {
                        fileWriter = new FileWriter(settingsFile);
                        String colorName = gson.toJson((Object)((DefaultClientTheme)Wrapper.getClickableGui().getTheme("Default")).getCurrentColor().getColorName());
                        fileWriter.append(colorName);
                        fileWriter.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Wrapper.getEventManager().unregister(this);
    }
}

