/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.module;

import de.paxii.clarinet.Client;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.module.ModuleCategory;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.settings.ClientSetting;
import java.util.HashMap;

public class Module
implements Comparable<Module> {
    private String name;
    private ModuleCategory category;
    private int key;
    private String syntax;
    private String description;
    private String helpUrl;
    private boolean command;
    private boolean enabled;
    private boolean displayedInGui;
    private boolean plugin;
    private int buildVersion;
    private String version;
    private HashMap<String, ValueBase> moduleValues;
    private HashMap<String, ClientSetting> moduleSettings;

    public Module(String name, ModuleCategory category) {
        this.name = name;
        this.category = category;
        this.setKey(-1);
        this.setHelpUrl(Client.getClientURL() + "docs/modules/" + this.category.toString().toLowerCase() + "/" + this.getName().toLowerCase() + ".html");
        this.setBuildVersion(Client.getClientBuild());
        this.setVersion(Client.getClientVersion());
        this.moduleValues = new HashMap();
        this.moduleSettings = new HashMap();
        this.setDisplayedInGui(true);
    }

    public Module(String name, ModuleCategory category, int i) {
        this(name, category);
        this.setKey(i);
    }

    public final void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.isEnabled()) {
            this.onEnable();
        } else {
            this.onDisable();
        }
        this.onToggle();
    }

    public final void setKey(int key) {
        this.key = key;
        if (key != -1) {
            Wrapper.getModuleManager().addKey(this.name, key);
        } else {
            Wrapper.getModuleManager().removeKey(this.name);
        }
    }

    public final void toggle() {
        this.setEnabled(!this.isEnabled());
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public void onToggle() {
    }

    public void onStartup() {
    }

    public void onShutdown() {
    }

    public void onCommand(String[] args) {
    }

    public String toString() {
        return this.getName();
    }

    public <T extends ClientSetting> T getSetting(String settingName, Class<T> type) {
        return (T)((ClientSetting)type.cast(this.moduleSettings.get(settingName)));
    }

    public <T> T getValue(String settingName, Class<T> type) {
        return type.cast(this.moduleSettings.get(settingName).getValue());
    }

    public <T> T getValueOrDefault(String settingName, Class<T> type, T defaultValue) {
        if (this.moduleSettings.containsKey(settingName)) {
            return type.cast(this.moduleSettings.get(settingName).getValue());
        }
        return defaultValue;
    }

    @Override
    public int compareTo(Module o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String getName() {
        return this.name;
    }

    public ModuleCategory getCategory() {
        return this.category;
    }

    public void setCategory(ModuleCategory category) {
        this.category = category;
    }

    public int getKey() {
        return this.key;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public boolean isCommand() {
        return this.command;
    }

    public void setCommand(boolean command) {
        this.command = command;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisplayedInGui() {
        return this.displayedInGui;
    }

    public void setDisplayedInGui(boolean displayedInGui) {
        this.displayedInGui = displayedInGui;
    }

    public boolean isPlugin() {
        return this.plugin;
    }

    public void setPlugin(boolean plugin) {
        this.plugin = plugin;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    protected void setBuildVersion(int buildVersion) {
        this.buildVersion = buildVersion;
    }

    public String getVersion() {
        return this.version;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    public HashMap<String, ValueBase> getModuleValues() {
        return this.moduleValues;
    }

    public void setModuleValues(HashMap<String, ValueBase> moduleValues) {
        this.moduleValues = moduleValues;
    }

    public HashMap<String, ClientSetting> getModuleSettings() {
        return this.moduleSettings;
    }

    public void setModuleSettings(HashMap<String, ClientSetting> moduleSettings) {
        this.moduleSettings = moduleSettings;
    }
}

