/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.module;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.EventManager;
import de.paxii.clarinet.event.events.client.PostLoadModulesEvent;
import de.paxii.clarinet.event.events.game.KeyPressedEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.module.ModuleCategory;
import de.paxii.clarinet.module.external.ExternalModuleLoader;
import de.paxii.clarinet.util.module.store.ModuleStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ModuleManager {
    private final ConcurrentHashMap<String, Module> moduleList = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> keybindList = new ConcurrentHashMap();
    private ExternalModuleLoader externalModuleLoader = new ExternalModuleLoader();

    public ModuleManager() {
        Wrapper.getEventManager().register(this);
        new Thread(this::addModules).start();
    }

    public void reloadModules() {
        this.addModules();
    }

    private void addModules() {
        for (ModuleCategory m : ModuleCategory.values()) {
            String packageName = "de.paxii.clarinet.module." + m.toString().toLowerCase();
            System.out.println("Searching for Modules in " + packageName);
            Reflections reflections = new Reflections(packageName, new Scanner[0]);
            Set<Class<Module>> allClasses = reflections.getSubTypesOf(Module.class);
            for (Class<Module> c : allClasses) {
                try {
                    Module newModule = c.newInstance();
                    this.addModule(newModule);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        this.externalModuleLoader.loadModules(() -> EventManager.call(new PostLoadModulesEvent()));
    }

    public void addModule(Module module) {
        for (String blocked : ModuleStore.getModulesToDelete()) {
            if (!module.getName().equals(blocked)) continue;
            return;
        }
        if (!this.doesModuleExist(module.getName())) {
            System.out.println("Loading " + module.getName() + "...");
            this.moduleList.put(module.getName(), module);
        }
    }

    public void removeModule(Module module) {
        if (this.doesModuleExist(module.getName())) {
            System.out.println("Removing " + module.getName() + "...");
            this.moduleList.remove(module.getName());
        }
    }

    public boolean doesModuleExist(String moduleName) {
        for (Map.Entry<String, Module> command : this.moduleList.entrySet()) {
            if (!command.getKey().equalsIgnoreCase(moduleName)) continue;
            return true;
        }
        return false;
    }

    public Module getModule(String moduleName) {
        if (this.doesModuleExist(moduleName)) {
            return this.moduleList.get(moduleName);
        }
        return null;
    }

    public Module getModuleIgnoreCase(String moduleName) {
        for (Map.Entry<String, Module> command : this.moduleList.entrySet()) {
            if (!command.getKey().equalsIgnoreCase(moduleName)) continue;
            return command.getValue();
        }
        return null;
    }

    public ConcurrentHashMap<String, Module> getModulesByCategory(ModuleCategory moduleCategory) {
        ConcurrentHashMap<String, Module> modules = new ConcurrentHashMap<String, Module>();
        this.moduleList.forEach((k, m) -> {
            if (m.getCategory() == moduleCategory) {
                modules.put((String)k, (Module)m);
            }
        });
        return modules;
    }

    public boolean isModuleActive(String moduleName) {
        Module module = this.getModule(moduleName);
        return module != null && module.isEnabled();
    }

    @EventHandler
    private void handleKeyPress(KeyPressedEvent event) {
        for (Map.Entry<String, Integer> entry : this.keybindList.entrySet()) {
            Module module;
            String moduleName = entry.getKey();
            int moduleKey = entry.getValue();
            if (moduleKey != event.getKey() || (module = this.getModule(moduleName)) == null) continue;
            module.toggle();
        }
    }

    public void addKey(String moduleName, int key) {
        if (this.keybindList.containsKey(moduleName)) {
            this.removeKey(moduleName);
        }
        this.keybindList.put(moduleName, key);
    }

    public void removeKey(String moduleName) {
        this.keybindList.remove(moduleName);
    }

    public ConcurrentHashMap<String, Module> getModuleList() {
        return this.moduleList;
    }

    public ConcurrentHashMap<String, Integer> getKeybindList() {
        return this.keybindList;
    }

    public ExternalModuleLoader getExternalModuleLoader() {
        return this.externalModuleLoader;
    }
}

