/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.module.combat;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.game.IngameTickEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.module.ModuleCategory;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.module.killaura.TimeManager;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.settings.ClientSettings;
import de.paxii.clarinet.util.settings.type.ClientSettingBoolean;
import de.paxii.clarinet.util.settings.type.ClientSettingInteger;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.src.Reflector;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ModuleTriggerbot
extends Module {
    private RayTraceResult objectMouseOver;
    private TimeManager timeManager;

    public ModuleTriggerbot() {
        super("Triggerbot", ModuleCategory.COMBAT);
        this.setCommand(true);
        this.setDescription("Automatically hits entities when you hover over them while holding the trigger key (default is left alt)");
        this.setSyntax("triggerbot autospeed <true/false>");
        this.getModuleValues().put("clickSpeed", new ValueBase("Triggerbot Speed", 8.2f, 1.0f, 20.0f));
        this.getModuleValues().put("clickRange", new ValueBase("Triggerbot Range", 4.5f, 1.0f, 6.6f));
        this.getModuleValues().put("randomness", new ValueBase(String.format("%s Random", this.getName()), 50.0f, 1.0f, 250.0f, true));
        this.getModuleSettings().put("triggerKey", new ClientSettingInteger("triggerKey", 56));
        this.getModuleSettings().put("autoDelay", new ClientSettingBoolean("autoDelay", false));
        this.timeManager = new TimeManager();
        this.timeManager.setRandom(true);
    }

    @Override
    public void onEnable() {
        Wrapper.getEventManager().register(this);
    }

    @EventHandler
    public void onTick(IngameTickEvent event) {
        if (this.isKeyDown()) {
            Entity pointedEntity;
            this.getMouseOver(Wrapper.getMinecraft().getTimer().renderPartialTicks);
            this.timeManager.updateTimer((int)this.getModuleValues().get("randomness").getValue());
            if (this.objectMouseOver != null && this.objectMouseOver.entityHit != null && this.shouldAttack(pointedEntity = this.objectMouseOver.entityHit) && this.isDelayComplete()) {
                Wrapper.getMinecraft().playerController.attackEntity(Wrapper.getPlayer(), pointedEntity);
                Wrapper.getPlayer().swingArm(EnumHand.MAIN_HAND);
                this.timeManager.updateLast();
            }
        }
    }

    private boolean isDelayComplete() {
        if (this.getValueOrDefault("autoDelay", Boolean.class, false).booleanValue()) {
            return Wrapper.getPlayer().getCooledAttackStrength(0.0f) >= 1.0f;
        }
        return this.timeManager.sleep((long)(1000.0f / this.getModuleValues().get("clickSpeed").getValue()));
    }

    private boolean isKeyDown() {
        int triggerKey = this.getValueOrDefault("triggerKey", Integer.class, 56);
        return triggerKey >= 0 ? Keyboard.isKeyDown((int)triggerKey) : Mouse.isButtonDown((int)(triggerKey + 100));
    }

    private boolean shouldAttack(Entity entity) {
        return !entity.isDead && Wrapper.getPlayer().getDistanceToEntity(entity) <= this.getModuleValues().get("clickRange").getValue() && Wrapper.getPlayer().canEntityBeSeen(entity) && !Wrapper.getFriendManager().isFriend(entity.getName());
    }

    @Override
    public void onDisable() {
        Wrapper.getEventManager().unregister(this);
    }

    private void getMouseOver(float partialTicks) {
        Entity entity = Wrapper.getMinecraft().getRenderViewEntity();
        if (entity != null && Wrapper.getWorld() != null) {
            double d0 = this.getModuleValues().get("clickRange").getValue();
            this.objectMouseOver = entity.rayTrace(d0, partialTicks);
            double d1 = d0;
            Vec3d vec3d = entity.getPositionEyes(partialTicks);
            if (this.objectMouseOver != null) {
                d1 = this.objectMouseOver.hitVec.distanceTo(vec3d);
            }
            Vec3d vec3d1 = entity.getLook(partialTicks);
            Vec3d vec3d2 = vec3d.addVector(vec3d1.xCoord * d0, vec3d1.yCoord * d0, vec3d1.zCoord * d0);
            Entity pointedEntity = null;
            Vec3d vec3d3 = null;
            float f = 1.0f;
            List<Entity> list = Wrapper.getWorld().getEntitiesInAABBexcluding(entity, entity.getEntityBoundingBox().addCoord(vec3d1.xCoord * d0, vec3d1.yCoord * d0, vec3d1.zCoord * d0).expand(f, f, f), (Predicate<? super Entity>)Predicates.and(EntitySelectors.NOT_SPECTATING, p_apply_1_ -> p_apply_1_ != null && p_apply_1_.canBeCollidedWith()));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = list.get(j);
                AxisAlignedBB axisalignedbb = entity1.getEntityBoundingBox().expandXyz(entity1.getCollisionBorderSize());
                RayTraceResult raytraceresult = axisalignedbb.calculateIntercept(vec3d, vec3d2);
                if (axisalignedbb.isVecInside(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.hitVec;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.distanceTo(raytraceresult.hitVec)) < d2) && d2 != 0.0) continue;
                boolean flag1 = false;
                if (Reflector.ForgeEntity_canRiderInteract.exists()) {
                    flag1 = Reflector.callBoolean(entity1, Reflector.ForgeEntity_canRiderInteract, new Object[0]);
                }
                if (!flag1 && entity1.getLowestRidingEntity() == entity.getLowestRidingEntity()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult.hitVec;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = raytraceresult.hitVec;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < d1 || this.objectMouseOver == null)) {
                this.objectMouseOver = new RayTraceResult(pointedEntity, vec3d3);
            }
        }
    }

    @Override
    public void onCommand(String[] args) {
        if (args.length >= 2) {
            if (args[0].equalsIgnoreCase("autospeed")) {
                try {
                    boolean autoSpeed = Boolean.parseBoolean(args[1]);
                    this.getModuleSettings().put("autoDelay", new ClientSettingBoolean("autoDelay", autoSpeed));
                    Chat.printClientMessage("TriggerBot auto speed mode has been set to " + autoSpeed + ".");
                }
                catch (Exception e) {
                    Chat.printClientMessage("Invalid argument!");
                }
            } else {
                Chat.printClientMessage("Invalid subcommand! Use \"" + ClientSettings.getValue("client.prefix", String.class) + "help triggerbot\"");
            }
        } else {
            Chat.printClientMessage("Too few arguments!");
        }
    }
}

