/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.chat;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.util.chat.ChatColor;
import java.util.regex.Pattern;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class Chat {
    private static final String prefix = (Object)((Object)ChatColor.AQUA) + "[C] " + (Object)((Object)ChatColor.WHITE);
    private static final Pattern URL_PATTERN = Pattern.compile("^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");

    public static void printChatMessage(String chatMessage) {
        TextComponentString textComponent = new TextComponentString("");
        String[] messageParts = chatMessage.split(" ");
        int pathIndex = 0;
        for (String messagePart : messageParts) {
            String currentPath;
            String lastColor;
            TextComponentString append = new TextComponentString(messagePart);
            Style chatStyle = new Style();
            if (URL_PATTERN.matcher(ChatColor.stripColor(messagePart)).matches()) {
                chatStyle.setUnderlined(true);
                chatStyle.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, ChatColor.stripColor(messagePart)));
            }
            if ((lastColor = ChatColor.getLastColors(currentPath = chatMessage.substring(0, chatMessage.indexOf(messagePart, pathIndex)))).length() >= 2) {
                char formattingChar = lastColor.charAt(1);
                Chat.formatChatStyle(chatStyle, formattingChar);
            }
            append.setStyle(chatStyle);
            textComponent.appendSibling(append);
            textComponent.appendText(" ");
            pathIndex += messagePart.length() - 1;
        }
        Wrapper.getMinecraft().getIngameGUI().getChatGUI().printChatMessage(textComponent);
    }

    public static void printChatComponent(ITextComponent textComponent) {
        Wrapper.getMinecraft().getIngameGUI().getChatGUI().printChatMessage(textComponent);
    }

    public static void printClientMessage(String chatMessage) {
        Chat.printChatMessage(prefix + chatMessage);
    }

    public static void sendChatMessage(String chatMessage) {
        Wrapper.getSendQueue().addToSendQueue(new CPacketChatMessage("_PASS_" + chatMessage));
    }

    private static TextFormatting getTextFormattingByValue(char value) {
        for (TextFormatting textFormatting : TextFormatting.values()) {
            if (value != textFormatting.getFormattingCode()) continue;
            return textFormatting;
        }
        return null;
    }

    private static Style formatChatStyle(Style chatStyle, char formattingChar) {
        switch (formattingChar) {
            case 'k': {
                chatStyle.setObfuscated(true);
                break;
            }
            case 'm': {
                chatStyle.setStrikethrough(true);
                break;
            }
            case 'l': {
                chatStyle.setBold(true);
                break;
            }
            case 'n': {
                chatStyle.setUnderlined(true);
                break;
            }
            case 'o': {
                chatStyle.setItalic(true);
                break;
            }
            case 'r': {
                chatStyle.setObfuscated(false);
                chatStyle.setStrikethrough(false);
                chatStyle.setBold(false);
                chatStyle.setUnderlined(false);
                chatStyle.setItalic(false);
                chatStyle.setColor(TextFormatting.RESET);
                break;
            }
            default: {
                chatStyle.setColor(Chat.getTextFormattingByValue(formattingChar));
            }
        }
        return chatStyle;
    }

    public static String getPrefix() {
        return prefix;
    }
}

