/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.killaura;

import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.module.killaura.CameraObject;
import de.paxii.clarinet.util.module.killaura.EntityManager;
import de.paxii.clarinet.util.module.killaura.TimeManager;
import de.paxii.clarinet.util.module.settings.ValueBase;
import de.paxii.clarinet.util.settings.type.ClientSettingBoolean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class AuraManager {
    private Module module;
    private ValueBase valueRange;
    private ValueBase valueDelay;
    private ValueBase valueAngle;
    private boolean silent = true;
    private boolean mob = true;
    private boolean animal = false;
    private boolean player = true;
    private boolean legit = true;
    private boolean invisible = false;
    private boolean autoSpeed = false;
    private TimeManager timeManager;
    private ArrayList<Float> pitchMap;
    private ArrayList<Float> yawMap;
    private Map<Integer, Long> attackMap;
    private CameraObject cameraObject;
    private Random random;

    public AuraManager(final Module module) {
        float f;
        this.module = module;
        this.attackMap = new HashMap<Integer, Long>();
        this.cameraObject = new CameraObject();
        this.pitchMap = new ArrayList();
        this.yawMap = new ArrayList();
        this.random = new Random();
        this.timeManager = new TimeManager();
        this.valueRange = new ValueBase(module.getName() + " Range", 4.1f, 1.0f, 6.0f);
        this.valueDelay = new ValueBase(module.getName() + " Speed", 2.0f, 1.0f, 15.0f){

            @Override
            public void onUpdate(float oldValue, float newValue) {
                if (AuraManager.this.isAutoSpeed()) {
                    AuraManager.this.setAutoSpeed(false);
                    Chat.printClientMessage(String.format("Disabled auto speed for %s.", module.getName()));
                }
            }
        };
        this.valueAngle = new ValueBase(module.getName() + " Angle", 80.0f, 1.0f, 180.0f);
        this.module.getModuleValues().put("valueRange", this.valueRange);
        this.module.getModuleValues().put("valueDelay", this.valueDelay);
        this.module.getModuleValues().put("valueAngle", this.valueAngle);
        this.module.getModuleSettings().put("animal", new ClientSettingBoolean("animal", this.isAnimal()));
        this.module.getModuleSettings().put("mob", new ClientSettingBoolean("mob", this.isMob()));
        this.module.getModuleSettings().put("player", new ClientSettingBoolean("player", this.isPlayer()));
        this.module.getModuleSettings().put("silent", new ClientSettingBoolean("silent", this.isSilent()));
        this.module.getModuleSettings().put("legit", new ClientSettingBoolean("legit", this.isLegit()));
        this.module.getModuleSettings().put("invisible", new ClientSettingBoolean("invisible", this.isInvisible()));
        this.module.getModuleSettings().put("autoDelay", new ClientSettingBoolean("autoDelay", this.isAutoSpeed()));
        for (f = -10.0f; f <= 10.0f; f += 2.0f) {
            this.yawMap.add(Float.valueOf(f));
        }
        for (f = -10.0f; f <= 50.0f; f += 5.0f) {
            this.pitchMap.add(Float.valueOf(f));
        }
    }

    public void addToAttackMap(int entityId, long last) {
        this.attackMap.put(entityId, last);
    }

    private long getLast(Entity entity) {
        if (this.attackMap.get(entity.getEntityId()) == null) {
            return 0L;
        }
        return this.attackMap.get(entity.getEntityId());
    }

    public long getDelay() {
        return (long)(1000.0f / this.valueDelay.getValue());
    }

    public void setDelay(float delay) {
        this.valueDelay.setValue(delay);
    }

    public boolean isDelayComplete(TimeManager timeManager) {
        if (this.isAutoSpeed()) {
            return Wrapper.getPlayer().getCooledAttackStrength(0.0f) >= 1.0f;
        }
        return timeManager.sleep(this.getDelay());
    }

    public double getRange() {
        return this.valueRange.getValue();
    }

    public void setRange(float range) {
        this.valueRange.setValue(range);
    }

    public float getAngle() {
        return this.valueAngle.getValue();
    }

    public Map<Integer, Long> getAttackMap() {
        return this.attackMap;
    }

    public void setAttackMap(Map<Integer, Long> attackMap) {
        this.attackMap = attackMap;
    }

    public long convertToMilliseconds(double delay) {
        return 1000L / (long)delay;
    }

    public void saveCamera(EntityPlayer p) {
        this.cameraObject.saveCamera(p);
    }

    public void restoreCamera(EntityPlayer p) {
        this.cameraObject.restoreCamera(p);
    }

    public float getRandomPitchModifier() {
        int randomIndex = this.random.nextInt(this.pitchMap.size() - 1);
        return this.pitchMap.get(randomIndex).floatValue();
    }

    public float getRandomYawModifier() {
        int randomIndex = this.random.nextInt(this.yawMap.size() - 1);
        return this.yawMap.get(randomIndex).floatValue();
    }

    public void setAngles(EntityLivingBase entityLiving, EntityManager entityManager) {
        float yaw = entityManager.getAngles(entityLiving)[0];
        float pitch = entityManager.getAngles(entityLiving)[1];
        if (this.isLegit()) {
            this.timeManager.updateTimer();
            if (this.timeManager.sleep(200L)) {
                this.setPitch(pitch + (this.random.nextFloat() - 0.5f) * 50.0f);
                this.setYaw(yaw + (this.random.nextFloat() - 0.5f) * 10.0f);
                this.timeManager.updateLast();
            } else {
                this.setPitch(pitch);
                this.setYaw(yaw);
            }
        } else {
            this.setPitch(pitch);
            this.setYaw(yaw);
        }
    }

    private void setYaw(float yaw) {
        Wrapper.getPlayer().rotationYaw = yaw;
        Wrapper.getPlayer().rotationYawHead = yaw;
    }

    private void setPitch(float pitch) {
        Wrapper.getPlayer().rotationPitch = pitch;
    }

    public void onStartUp() {
        this.setAnimal(this.module.getValueOrDefault("animal", Boolean.class, true));
        this.setMob(this.module.getValueOrDefault("mob", Boolean.class, true));
        this.setPlayer(this.module.getValueOrDefault("player", Boolean.class, true));
        this.setSilent(this.module.getValueOrDefault("silent", Boolean.class, true));
        this.setLegit(this.module.getValueOrDefault("legit", Boolean.class, true));
        this.setInvisible(this.module.getValueOrDefault("invisible", Boolean.class, false));
        this.setAutoSpeed(this.module.getValueOrDefault("autoDelay", Boolean.class, false));
    }

    public void onShutdown() {
        this.module.getModuleSettings().put("animal", new ClientSettingBoolean("animal", this.isAnimal()));
        this.module.getModuleSettings().put("mob", new ClientSettingBoolean("mob", this.isMob()));
        this.module.getModuleSettings().put("player", new ClientSettingBoolean("player", this.isPlayer()));
        this.module.getModuleSettings().put("silent", new ClientSettingBoolean("silent", this.isSilent()));
        this.module.getModuleSettings().put("legit", new ClientSettingBoolean("legit", this.isLegit()));
        this.module.getModuleSettings().put("invisible", new ClientSettingBoolean("invisible", this.isInvisible()));
        this.module.getModuleSettings().put("autoDelay", new ClientSettingBoolean("autoDelay", this.isAutoSpeed()));
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isMob() {
        return this.mob;
    }

    public boolean isAnimal() {
        return this.animal;
    }

    public boolean isPlayer() {
        return this.player;
    }

    public boolean isLegit() {
        return this.legit;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean isAutoSpeed() {
        return this.autoSpeed;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setMob(boolean mob) {
        this.mob = mob;
    }

    public void setAnimal(boolean animal) {
        this.animal = animal;
    }

    public void setPlayer(boolean player) {
        this.player = player;
    }

    public void setLegit(boolean legit) {
        this.legit = legit;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void setAutoSpeed(boolean autoSpeed) {
        this.autoSpeed = autoSpeed;
    }
}

