/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.module.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.paxii.clarinet.Client;
import de.paxii.clarinet.Wrapper;
import de.paxii.clarinet.event.EventHandler;
import de.paxii.clarinet.event.events.client.PostLoadModulesEvent;
import de.paxii.clarinet.event.events.game.StopGameEvent;
import de.paxii.clarinet.event.events.player.PlayerSendChatMessageEvent;
import de.paxii.clarinet.module.Module;
import de.paxii.clarinet.util.chat.Chat;
import de.paxii.clarinet.util.module.store.ModuleEntry;
import de.paxii.clarinet.util.notifications.NotificationPriority;
import de.paxii.clarinet.util.settings.ClientSettings;
import de.paxii.clarinet.util.web.JsonFetcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.play.client.CPacketChatMessage;
import org.apache.commons.io.FileUtils;

public class ModuleStore {
    private static String moduleUrl = Client.getClientURL() + "modules/files/%s/%s.jar";
    private static TreeMap<String, ModuleEntry> moduleList = new TreeMap();
    private static ArrayList<String> modulesToDelete = new ArrayList();

    public ModuleStore() {
        Wrapper.getEventManager().register(this);
        this.removeModules();
    }

    public void removeModules() {
        File modulesToDelete = new File((String)ClientSettings.getClientFolderPath().getValue(), "modulesToDelete.json");
        if (modulesToDelete.exists()) {
            String jsonString = "";
            try {
                Scanner sc = new Scanner(modulesToDelete);
                Gson gson = new Gson();
                while (sc.hasNextLine()) {
                    jsonString = jsonString + sc.nextLine();
                }
                sc.close();
                ArrayList modulesToRemove = (ArrayList)gson.fromJson(jsonString, new TypeToken<ArrayList<String>>(){}.getType());
                if (modulesToRemove != null) {
                    modulesToRemove.forEach(moduleName -> {
                        File moduleFile = new File((String)ClientSettings.getClientFolderPath().getValue() + "/modules/", String.format("%s.jar", moduleName));
                        moduleFile.delete();
                        if (moduleName.contains("-")) {
                            String oldModuleName = moduleName.split("-")[0];
                            File oldModuleFile = new File((String)ClientSettings.getClientFolderPath().getValue() + "/modules/", String.format("%s.jar", oldModuleName));
                            if (oldModuleFile.exists()) {
                                oldModuleFile.delete();
                            }
                        }
                    });
                }
                modulesToDelete.delete();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void downloadModule(String moduleName) {
        try {
            if (ModuleStore.isModuleInstalled(moduleName)) {
                ModuleStore.removeModule(moduleName);
            }
            ModuleEntry moduleEntry = moduleList.get(moduleName);
            File moduleFile = new File((String)ClientSettings.getClientFolderPath().getValue() + "/modules/", String.format("%s.jar", moduleName + "-" + moduleEntry.getVersion()));
            URL downloadUrl = new URL(String.format(moduleUrl, moduleName, moduleName + "-" + moduleEntry.getVersion()));
            if (moduleFile.exists() && !moduleFile.delete()) {
                return;
            }
            new Thread(() -> {
                try {
                    FileUtils.copyURLToFile((URL)downloadUrl, (File)moduleFile);
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Chat.printClientMessage(String.format("Module %s has been downloaded. Reloading Client...", moduleName));
                        Wrapper.getConsole().onChatMessage(new PlayerSendChatMessageEvent(new CPacketChatMessage(ClientSettings.getValue("client.prefix", String.class) + "reload")));
                        throw throwable;
                    }
                    Chat.printClientMessage(String.format("Module %s has been downloaded. Reloading Client...", moduleName));
                    Wrapper.getConsole().onChatMessage(new PlayerSendChatMessageEvent(new CPacketChatMessage(ClientSettings.getValue("client.prefix", String.class) + "reload")));
                }
                Chat.printClientMessage(String.format("Module %s has been downloaded. Reloading Client...", moduleName));
                Wrapper.getConsole().onChatMessage(new PlayerSendChatMessageEvent(new CPacketChatMessage(ClientSettings.getValue("client.prefix", String.class) + "reload")));
            }).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeModule(String moduleName) {
        try {
            String removedVersion = moduleName;
            if (Wrapper.getModuleManager().doesModuleExist(moduleName)) {
                Module module = Wrapper.getModuleManager().getModule(moduleName);
                removedVersion = moduleName + "-" + module.getVersion();
                module.setEnabled(false);
                module.onShutdown();
                Wrapper.getModuleManager().removeModule(module);
                Wrapper.getClickableGui().loadPanels();
            }
            if (!modulesToDelete.contains(removedVersion)) {
                modulesToDelete.add(removedVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        modulesToDelete.forEach(System.out::println);
    }

    public static TreeMap<String, ModuleEntry> listModules() {
        return moduleList;
    }

    public static void fetchModules() {
        String listPath = Client.getClientURL() + "modules/modules.php";
        ModuleResponse moduleResponse = JsonFetcher.fetchData(listPath, ModuleResponse.class);
        if (moduleResponse != null) {
            moduleResponse.getModuleList().forEach(moduleEntry -> moduleList.put(moduleEntry.getModule(), (ModuleEntry)moduleEntry));
        } else if (moduleList.size() == 0) {
            ModuleEntry moduleEntry2 = new ModuleEntry();
            moduleEntry2.setModule("Error");
            moduleEntry2.setDescription("Could not get list of external Modules!");
            moduleList.put("Error", moduleEntry2);
        }
    }

    public static boolean isModuleInstalled(String moduleName) {
        return moduleList.containsKey(moduleName) && Wrapper.getModuleManager().getModuleList().containsKey(moduleName);
    }

    public static boolean isModuleUptoDate(String moduleName) {
        return ModuleStore.isModuleInstalled(moduleName) && ModuleStore.listModules().get(moduleName).getBuild() <= Wrapper.getModuleManager().getModule(moduleName).getBuildVersion();
    }

    @EventHandler
    public void onPostLoadModules(PostLoadModulesEvent event) {
        AtomicBoolean updateAvailable = new AtomicBoolean(false);
        moduleList.forEach((moduleName, moduleEntry) -> {
            if (ModuleStore.isModuleInstalled(moduleName) && !ModuleStore.isModuleUptoDate(moduleName)) {
                updateAvailable.set(true);
            }
        });
        if (updateAvailable.get()) {
            Wrapper.getClient().getNotificationManager().addNotification("There are Updates available for installed Plugins!", NotificationPriority.DANGER, 10000L);
        }
    }

    @EventHandler
    public void onShutdown(StopGameEvent event) {
        File modulesToDelete = new File((String)ClientSettings.getClientFolderPath().getValue(), "modulesToDelete.json");
        try {
            modulesToDelete.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ModuleStore.modulesToDelete.size() > 0) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonString = gson.toJson(ModuleStore.modulesToDelete);
            try {
                FileWriter fw = new FileWriter(modulesToDelete);
                fw.write(jsonString);
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<String> getModulesToDelete() {
        return modulesToDelete;
    }

    class ModuleResponse {
        private ArrayList<ModuleEntry> moduleList;

        public ModuleResponse(ArrayList<ModuleEntry> moduleList) {
            this.moduleList = moduleList;
        }

        public ArrayList<ModuleEntry> getModuleList() {
            return this.moduleList;
        }

        public void setModuleList(ArrayList<ModuleEntry> moduleList) {
            this.moduleList = moduleList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleResponse)) {
                return false;
            }
            ModuleResponse other = (ModuleResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ArrayList<ModuleEntry> this$moduleList = this.getModuleList();
            ArrayList<ModuleEntry> other$moduleList = other.getModuleList();
            return !(this$moduleList == null ? other$moduleList != null : !((Object)this$moduleList).equals(other$moduleList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ArrayList<ModuleEntry> $moduleList = this.getModuleList();
            result = result * 59 + ($moduleList == null ? 0 : ((Object)$moduleList).hashCode());
            return result;
        }

        public String toString() {
            return "ModuleStore.ModuleResponse(moduleList=" + this.getModuleList() + ")";
        }
    }
}

