/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.notifications;

import de.paxii.clarinet.util.notifications.NotificationPriority;

public class Notification {
    private String text;
    private NotificationPriority priority;
    private long time;
    private long initialTime;

    public Notification(String text) {
        this(text, NotificationPriority.NORMAL, 3000L);
    }

    public Notification(String text, long time) {
        this(text, NotificationPriority.NORMAL, time);
    }

    public Notification(String text, NotificationPriority notificationPriority) {
        this(text, notificationPriority, 3000L);
    }

    public Notification(String text, NotificationPriority notificationPriority, long time) {
        this.text = text;
        this.priority = notificationPriority;
        this.time = time;
        this.initialTime = System.currentTimeMillis();
    }

    public boolean shouldDisplay() {
        return System.currentTimeMillis() <= this.initialTime + this.time;
    }

    public String getText() {
        return this.text;
    }

    public NotificationPriority getPriority() {
        return this.priority;
    }

    public long getTime() {
        return this.time;
    }
}

