/*
 * Decompiled with CFR 0.152.
 */
package de.paxii.clarinet.util.update;

import de.paxii.clarinet.Client;
import de.paxii.clarinet.util.module.store.ModuleStore;
import de.paxii.clarinet.util.settings.ClientSettings;
import de.paxii.clarinet.util.threads.ThreadChain;
import de.paxii.clarinet.util.update.VersionList;
import de.paxii.clarinet.util.web.JsonFetcher;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JOptionPane;

public class UpdateChecker {
    private static boolean upToDate = true;

    public UpdateChecker() {
        this.checkForUpdates();
    }

    public void checkForUpdates() {
        ThreadChain threadChain = new ThreadChain();
        threadChain.chainThread(new Thread(() -> {
            try {
                VersionList versionList = JsonFetcher.fetchData(Client.getClientURL() + "versions.json", VersionList.class);
                versionList.getVersions().forEach(versionObject -> {
                    if (versionObject.getGameVersion().equals(Client.getGameVersion()) && versionObject.getClientBuild() > Client.getClientBuild()) {
                        upToDate = false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            threadChain.next();
        })).chainThread(new Thread(() -> {
            if (!ClientSettings.getValue("client.update", Boolean.class).booleanValue()) {
                return;
            }
            if (!UpdateChecker.isUpToDate()) {
                int answer = JOptionPane.showConfirmDialog(null, "There is an Update available, would you like to update?", "Matix Update", 0);
                if (answer == 0) {
                    Desktop desktop;
                    URL url = null;
                    try {
                        String line;
                        url = new URL(Client.getClientURL() + "download.json");
                        BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                        while ((line = br.readLine()) != null) {
                            if (line.length() <= 0 || !line.contains("string") || !line.contains("\"")) continue;
                            String downloadURL = line.split("\"")[3];
                            url = new URL(downloadURL);
                        }
                    }
                    catch (IOException br) {
                        // empty catch block
                    }
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                        if (url != null) {
                            try {
                                desktop.browse(url.toURI());
                            }
                            catch (IOException ye) {
                                JOptionPane.showMessageDialog(null, "Could not open your Browser!", "Error", 0);
                                ye.printStackTrace();
                            }
                            catch (URISyntaxException ye) {
                                JOptionPane.showMessageDialog(null, "Could not get download URL!", "Error", 0);
                                ye.printStackTrace();
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, "Could not get download URL!", "Error", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Could not open your Browser!", "Error", 0);
                    }
                }
            } else {
                System.out.println("Matix is up-to-date");
            }
            threadChain.next();
        })).kickOff();
        new Thread(ModuleStore::fetchModules).start();
    }

    public static boolean isUpToDate() {
        return upToDate;
    }
}

