/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.LayeredColorMaskTexture;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;

public class BannerTextures {
    public static final Cache BANNER_DESIGNS = new Cache("B", new ResourceLocation("textures/entity/banner_base.png"), "textures/entity/banner/");
    public static final Cache SHIELD_DESIGNS = new Cache("S", new ResourceLocation("textures/entity/shield_base.png"), "textures/entity/shield/");
    public static final ResourceLocation SHIELD_BASE_TEXTURE = new ResourceLocation("textures/entity/shield_base_nopattern.png");
    public static final ResourceLocation BANNER_BASE_TEXTURE = new ResourceLocation("textures/entity/banner/base.png");

    static class CacheEntry {
        public long lastUseMillis;
        public ResourceLocation textureLocation;

        private CacheEntry() {
        }
    }

    public static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();
        private final ResourceLocation cacheResourceLocation;
        private final String cacheResourceBase;
        private final String cacheId;

        public Cache(String p_i46998_1_, ResourceLocation p_i46998_2_, String p_i46998_3_) {
            this.cacheId = p_i46998_1_;
            this.cacheResourceLocation = p_i46998_2_;
            this.cacheResourceBase = p_i46998_3_;
        }

        @Nullable
        public ResourceLocation getResourceLocation(String p_187478_1_, List<TileEntityBanner.EnumBannerPattern> p_187478_2_, List<EnumDyeColor> p_187478_3_) {
            if (p_187478_1_.isEmpty()) {
                return null;
            }
            p_187478_1_ = this.cacheId + p_187478_1_;
            CacheEntry bannertextures$cacheentry = this.cacheMap.get(p_187478_1_);
            if (bannertextures$cacheentry == null) {
                if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                    return BANNER_BASE_TEXTURE;
                }
                ArrayList list = Lists.newArrayList();
                for (TileEntityBanner.EnumBannerPattern tileentitybanner$enumbannerpattern : p_187478_2_) {
                    list.add(this.cacheResourceBase + tileentitybanner$enumbannerpattern.getPatternName() + ".png");
                }
                bannertextures$cacheentry = new CacheEntry();
                bannertextures$cacheentry.textureLocation = new ResourceLocation(p_187478_1_);
                Minecraft.getMinecraft().getTextureManager().loadTexture(bannertextures$cacheentry.textureLocation, new LayeredColorMaskTexture(this.cacheResourceLocation, list, p_187478_3_));
                this.cacheMap.put(p_187478_1_, bannertextures$cacheentry);
            }
            bannertextures$cacheentry.lastUseMillis = System.currentTimeMillis();
            return bannertextures$cacheentry.textureLocation;
        }

        private boolean freeCacheSlot() {
            long i = System.currentTimeMillis();
            Iterator<String> iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                CacheEntry bannertextures$cacheentry = this.cacheMap.get(s);
                if (i - bannertextures$cacheentry.lastUseMillis <= 5000L) continue;
                Minecraft.getMinecraft().getTextureManager().deleteTexture(bannertextures$cacheentry.textureLocation);
                iterator.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }
}

