/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class EntitySelector {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^@([pare])(?:\\[([\\w=,!-]*)\\])?$");
    private static final Pattern INT_LIST_PATTERN = Pattern.compile("\\G([-!]?[\\w-]*)(?:$|,)");
    private static final Pattern KEY_VALUE_LIST_PATTERN = Pattern.compile("\\G(\\w+)=([-!]?[\\w-]*)(?:$|,)");
    private static final Set<String> WORLD_BINDING_ARGS = Sets.newHashSet((Object[])new String[]{"x", "y", "z", "dx", "dy", "dz", "rm", "r"});

    @Nullable
    public static EntityPlayerMP matchOnePlayer(ICommandSender sender, String token) {
        return EntitySelector.matchOneEntity(sender, token, EntityPlayerMP.class);
    }

    @Nullable
    public static <T extends Entity> T matchOneEntity(ICommandSender sender, String token, Class<? extends T> targetClass) {
        List<T> list = EntitySelector.matchEntities(sender, token, targetClass);
        return (T)(list.size() == 1 ? (Entity)list.get(0) : null);
    }

    @Nullable
    public static ITextComponent matchEntitiesToTextComponent(ICommandSender sender, String token) {
        List<Entity> list = EntitySelector.matchEntities(sender, token, Entity.class);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList list1 = Lists.newArrayList();
        for (Entity entity : list) {
            list1.add(entity.getDisplayName());
        }
        return CommandBase.join(list1);
    }

    public static <T extends Entity> List<T> matchEntities(ICommandSender sender, String token, Class<? extends T> targetClass) {
        Matcher matcher = TOKEN_PATTERN.matcher(token);
        if (matcher.matches() && sender.canCommandSenderUseCommand(1, "@")) {
            Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
            if (!EntitySelector.isEntityTypeValid(sender, map)) {
                return Collections.emptyList();
            }
            String s = matcher.group(1);
            BlockPos blockpos = EntitySelector.getBlockPosFromArguments(map, sender.getPosition());
            Vec3d vec3d = EntitySelector.getPosFromArguments(map, sender.getPositionVector());
            List<World> list = EntitySelector.getWorlds(sender, map);
            ArrayList list1 = Lists.newArrayList();
            for (World world : list) {
                if (world == null) continue;
                ArrayList list2 = Lists.newArrayList();
                list2.addAll(EntitySelector.getTypePredicates(map, s));
                list2.addAll(EntitySelector.getXpLevelPredicates(map));
                list2.addAll(EntitySelector.getGamemodePredicates(map));
                list2.addAll(EntitySelector.getTeamPredicates(map));
                list2.addAll(EntitySelector.getScorePredicates(sender, map));
                list2.addAll(EntitySelector.getNamePredicates(map));
                list2.addAll(EntitySelector.getTagPredicates(map));
                list2.addAll(EntitySelector.getRadiusPredicates(map, vec3d));
                list2.addAll(EntitySelector.getRotationsPredicates(map));
                list1.addAll(EntitySelector.filterResults(map, targetClass, list2, s, world, blockpos));
            }
            return EntitySelector.getEntitiesFromPredicates(list1, map, sender, targetClass, s, vec3d);
        }
        return Collections.emptyList();
    }

    private static List<World> getWorlds(ICommandSender sender, Map<String, String> argumentMap) {
        ArrayList list = Lists.newArrayList();
        if (EntitySelector.hasArgument(argumentMap)) {
            list.add(sender.getEntityWorld());
        } else {
            Collections.addAll(list, sender.getServer().worldServers);
        }
        return list;
    }

    private static <T extends Entity> boolean isEntityTypeValid(ICommandSender commandSender, Map<String, String> params) {
        String s = EntitySelector.getArgument(params, "type");
        String string = s = s != null && s.startsWith("!") ? s.substring(1) : s;
        if (s != null && !EntityList.isStringValidEntityName(s)) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.generic.entity.invalidType", s);
            textcomponenttranslation.getStyle().setColor(TextFormatting.RED);
            commandSender.addChatMessage(textcomponenttranslation);
            return false;
        }
        return true;
    }

    private static List<Predicate<Entity>> getTypePredicates(Map<String, String> params, String type) {
        boolean flag2;
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "type");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        boolean flag1 = !type.equals("e");
        boolean bl2 = flag2 = type.equals("r") && s != null;
        if (!(s != null && type.equals("e") || flag2)) {
            if (flag1) {
                list.add(new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity p_apply_1_) {
                        return p_apply_1_ instanceof EntityPlayer;
                    }
                });
            }
        } else {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return EntityList.isStringEntityName(p_apply_1_, s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getXpLevelPredicates(Map<String, String> params) {
        ArrayList list = Lists.newArrayList();
        final int i = EntitySelector.parseIntWithDefault(params, "lm", -1);
        final int j = EntitySelector.parseIntWithDefault(params, "l", -1);
        if (i > -1 || j > -1) {
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                        return false;
                    }
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                    return !(i > -1 && entityplayermp.experienceLevel < i || j > -1 && entityplayermp.experienceLevel > j);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getGamemodePredicates(Map<String, String> params) {
        GameType gametype;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "m");
        if (s == null) {
            return list;
        }
        final boolean flag = s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        try {
            int i = Integer.parseInt(s);
            gametype = GameType.parseGameTypeWithDefault(i, GameType.NOT_SET);
        }
        catch (Throwable var6) {
            gametype = GameType.parseGameTypeWithDefault(s, GameType.NOT_SET);
        }
        final GameType type = gametype;
        list.add(new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                if (!(p_apply_1_ instanceof EntityPlayerMP)) {
                    return false;
                }
                EntityPlayerMP entityplayermp = (EntityPlayerMP)p_apply_1_;
                GameType gametype1 = entityplayermp.interactionManager.getGameType();
                return flag ? gametype1 != type : gametype1 == type;
            }
        });
        return list;
    }

    private static List<Predicate<Entity>> getTeamPredicates(Map<String, String> params) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "team");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (!(p_apply_1_ instanceof EntityLivingBase)) {
                        return false;
                    }
                    EntityLivingBase entitylivingbase = (EntityLivingBase)p_apply_1_;
                    Team team = entitylivingbase.getTeam();
                    String s1 = team == null ? "" : team.getRegisteredName();
                    return s1.equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getScorePredicates(final ICommandSender sender, Map<String, String> params) {
        final Map<String, Integer> map = EntitySelector.getScoreMap(params);
        return map.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                Scoreboard scoreboard = sender.getServer().worldServerForDimension(0).getScoreboard();
                for (Map.Entry entry : map.entrySet()) {
                    String s1;
                    ScoreObjective scoreobjective;
                    String s = (String)entry.getKey();
                    boolean flag = false;
                    if (s.endsWith("_min") && s.length() > 4) {
                        flag = true;
                        s = s.substring(0, s.length() - 4);
                    }
                    if ((scoreobjective = scoreboard.getObjective(s)) == null) {
                        return false;
                    }
                    String string = s1 = p_apply_1_ instanceof EntityPlayerMP ? p_apply_1_.getName() : p_apply_1_.func_189512_bd();
                    if (!scoreboard.entityHasObjective(s1, scoreobjective)) {
                        return false;
                    }
                    Score score = scoreboard.getOrCreateScore(s1, scoreobjective);
                    int i = score.getScorePoints();
                    if (i < (Integer)entry.getValue() && flag) {
                        return false;
                    }
                    if (i <= (Integer)entry.getValue() || flag) continue;
                    return false;
                }
                return true;
            }
        }});
    }

    private static List<Predicate<Entity>> getNamePredicates(Map<String, String> params) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "name");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.getName().equals(s_f) != flag;
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getTagPredicates(Map<String, String> params) {
        boolean flag;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "tag");
        boolean bl = flag = s != null && s.startsWith("!");
        if (flag) {
            s = s.substring(1);
        }
        if (s != null) {
            final String s_f = s;
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ == null ? false : ("".equals(s_f) ? p_apply_1_.getTags().isEmpty() != flag : p_apply_1_.getTags().contains(s_f) != flag);
                }
            });
        }
        return list;
    }

    private static List<Predicate<Entity>> getRadiusPredicates(Map<String, String> params, final Vec3d pos) {
        boolean flag1;
        double d0 = EntitySelector.parseIntWithDefault(params, "rm", -1);
        double d1 = EntitySelector.parseIntWithDefault(params, "r", -1);
        final boolean flag = d0 < -0.5;
        boolean bl = flag1 = d1 < -0.5;
        if (flag && flag1) {
            return Collections.emptyList();
        }
        double d2 = Math.max(d0, 1.0E-4);
        final double d3 = d2 * d2;
        double d4 = Math.max(d1, 1.0E-4);
        final double d5 = d4 * d4;
        return Lists.newArrayList((Object[])new Predicate[]{new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                double d6 = pos.squareDistanceTo(p_apply_1_.posX, p_apply_1_.posY, p_apply_1_.posZ);
                return (flag || d6 >= d3) && (flag1 || d6 <= d5);
            }
        }});
    }

    private static List<Predicate<Entity>> getRotationsPredicates(Map<String, String> params) {
        ArrayList list = Lists.newArrayList();
        if (params.containsKey("rym") || params.containsKey("ry")) {
            final int i = MathHelper.clampAngle(EntitySelector.parseIntWithDefault(params, "rym", 0));
            final int j = MathHelper.clampAngle(EntitySelector.parseIntWithDefault(params, "ry", 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.clampAngle(MathHelper.floor_float(p_apply_1_.rotationYaw));
                    return i > j ? i1 >= i || i1 <= j : i1 >= i && i1 <= j;
                }
            });
        }
        if (params.containsKey("rxm") || params.containsKey("rx")) {
            final int k = MathHelper.clampAngle(EntitySelector.parseIntWithDefault(params, "rxm", 0));
            final int l = MathHelper.clampAngle(EntitySelector.parseIntWithDefault(params, "rx", 359));
            list.add(new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    if (p_apply_1_ == null) {
                        return false;
                    }
                    int i1 = MathHelper.clampAngle(MathHelper.floor_float(p_apply_1_.rotationPitch));
                    return k > l ? i1 >= k || i1 <= l : i1 >= k && i1 <= l;
                }
            });
        }
        return list;
    }

    private static <T extends Entity> List<T> filterResults(Map<String, String> params, Class<? extends T> entityClass, List<Predicate<Entity>> inputList, String type, World worldIn, BlockPos position) {
        boolean flag2;
        ArrayList list = Lists.newArrayList();
        String s = EntitySelector.getArgument(params, "type");
        s = s != null && s.startsWith("!") ? s.substring(1) : s;
        boolean flag = !type.equals("e");
        boolean flag1 = type.equals("r") && s != null;
        int i = EntitySelector.parseIntWithDefault(params, "dx", 0);
        int j = EntitySelector.parseIntWithDefault(params, "dy", 0);
        int k = EntitySelector.parseIntWithDefault(params, "dz", 0);
        int l = EntitySelector.parseIntWithDefault(params, "r", -1);
        Predicate predicate = Predicates.and(inputList);
        Predicate predicate1 = Predicates.and(EntitySelectors.IS_ALIVE, (Predicate)predicate);
        int i1 = worldIn.playerEntities.size();
        int j1 = worldIn.loadedEntityList.size();
        boolean bl = flag2 = i1 < j1 / 16;
        if (!(params.containsKey("dx") || params.containsKey("dy") || params.containsKey("dz"))) {
            if (l >= 0) {
                AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(position.getX() - l, position.getY() - l, position.getZ() - l, position.getX() + l + 1, position.getY() + l + 1, position.getZ() + l + 1);
                if (flag && flag2 && !flag1) {
                    list.addAll(worldIn.getPlayers(entityClass, predicate1));
                } else {
                    list.addAll(worldIn.getEntitiesWithinAABB(entityClass, axisalignedbb1, predicate1));
                }
            } else if (type.equals("a")) {
                list.addAll(worldIn.getPlayers(entityClass, predicate));
            } else if (!(type.equals("p") || type.equals("r") && !flag1)) {
                list.addAll(worldIn.getEntities(entityClass, predicate1));
            } else {
                list.addAll(worldIn.getPlayers(entityClass, predicate1));
            }
        } else {
            final AxisAlignedBB axisalignedbb = EntitySelector.getAABB(position, i, j, k);
            if (flag && flag2 && !flag1) {
                Predicate<Entity> predicate2 = new Predicate<Entity>(){

                    public boolean apply(@Nullable Entity p_apply_1_) {
                        return p_apply_1_ != null && axisalignedbb.intersectsWith(p_apply_1_.getEntityBoundingBox());
                    }
                };
                list.addAll(worldIn.getPlayers(entityClass, Predicates.and((Predicate)predicate1, (Predicate)predicate2)));
            } else {
                list.addAll(worldIn.getEntitiesWithinAABB(entityClass, axisalignedbb, predicate1));
            }
        }
        return list;
    }

    private static <T extends Entity> List<T> getEntitiesFromPredicates(List<T> matchingEntities, Map<String, String> params, ICommandSender sender, Class<? extends T> targetClass, String type, final Vec3d pos) {
        Entity entity;
        int i = EntitySelector.parseIntWithDefault(params, "c", !type.equals("a") && !type.equals("e") ? 1 : 0);
        if (!(type.equals("p") || type.equals("a") || type.equals("e"))) {
            if (type.equals("r")) {
                Collections.shuffle(matchingEntities);
            }
        } else {
            Collections.sort(matchingEntities, new Comparator<Entity>(){

                @Override
                public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                    return ComparisonChain.start().compare(p_compare_1_.getDistanceSq(pos.xCoord, pos.yCoord, pos.zCoord), p_compare_2_.getDistanceSq(pos.xCoord, pos.yCoord, pos.zCoord)).result();
                }
            });
        }
        if ((entity = sender.getCommandSenderEntity()) != null && targetClass.isAssignableFrom(entity.getClass()) && i == 1 && matchingEntities.contains(entity) && !"r".equals(type)) {
            matchingEntities = Lists.newArrayList((Object[])new Entity[]{entity});
        }
        if (i != 0) {
            if (i < 0) {
                Collections.reverse(matchingEntities);
            }
            matchingEntities = matchingEntities.subList(0, Math.min(Math.abs(i), matchingEntities.size()));
        }
        return matchingEntities;
    }

    private static AxisAlignedBB getAABB(BlockPos pos, int x, int y, int z) {
        boolean flag = x < 0;
        boolean flag1 = y < 0;
        boolean flag2 = z < 0;
        int i = pos.getX() + (flag ? x : 0);
        int j = pos.getY() + (flag1 ? y : 0);
        int k = pos.getZ() + (flag2 ? z : 0);
        int l = pos.getX() + (flag ? 0 : x) + 1;
        int i1 = pos.getY() + (flag1 ? 0 : y) + 1;
        int j1 = pos.getZ() + (flag2 ? 0 : z) + 1;
        return new AxisAlignedBB(i, j, k, l, i1, j1);
    }

    private static BlockPos getBlockPosFromArguments(Map<String, String> params, BlockPos pos) {
        return new BlockPos(EntitySelector.parseIntWithDefault(params, "x", pos.getX()), EntitySelector.parseIntWithDefault(params, "y", pos.getY()), EntitySelector.parseIntWithDefault(params, "z", pos.getZ()));
    }

    private static Vec3d getPosFromArguments(Map<String, String> params, Vec3d pos) {
        return new Vec3d(EntitySelector.getCoordinate(params, "x", pos.xCoord, true), EntitySelector.getCoordinate(params, "y", pos.yCoord, false), EntitySelector.getCoordinate(params, "z", pos.zCoord, true));
    }

    private static double getCoordinate(Map<String, String> params, String key, double defaultD, boolean offset) {
        return params.containsKey(key) ? (double)MathHelper.parseIntWithDefault(params.get(key), MathHelper.floor_double(defaultD)) + (offset ? 0.5 : 0.0) : defaultD;
    }

    private static boolean hasArgument(Map<String, String> params) {
        for (String s : WORLD_BINDING_ARGS) {
            if (!params.containsKey(s)) continue;
            return true;
        }
        return false;
    }

    private static int parseIntWithDefault(Map<String, String> params, String key, int defaultI) {
        return params.containsKey(key) ? MathHelper.parseIntWithDefault(params.get(key), defaultI) : defaultI;
    }

    @Nullable
    private static String getArgument(Map<String, String> params, String key) {
        return params.get(key);
    }

    public static Map<String, Integer> getScoreMap(Map<String, String> params) {
        HashMap map = Maps.newHashMap();
        for (String s : params.keySet()) {
            if (!s.startsWith("score_") || s.length() <= "score_".length()) continue;
            map.put(s.substring("score_".length()), MathHelper.parseIntWithDefault(params.get(s), 1));
        }
        return map;
    }

    public static boolean matchesMultiplePlayers(String selectorStr) {
        Matcher matcher = TOKEN_PATTERN.matcher(selectorStr);
        if (!matcher.matches()) {
            return false;
        }
        Map<String, String> map = EntitySelector.getArgumentMap(matcher.group(2));
        String s = matcher.group(1);
        int i = !"a".equals(s) && !"e".equals(s) ? 1 : 0;
        return EntitySelector.parseIntWithDefault(map, "c", i) != 1;
    }

    public static boolean hasArguments(String selectorStr) {
        return TOKEN_PATTERN.matcher(selectorStr).matches();
    }

    private static Map<String, String> getArgumentMap(@Nullable String argumentString) {
        HashMap map = Maps.newHashMap();
        if (argumentString == null) {
            return map;
        }
        int i = 0;
        int j = -1;
        Matcher matcher = INT_LIST_PATTERN.matcher(argumentString);
        while (matcher.find()) {
            String s = null;
            switch (i++) {
                case 0: {
                    s = "x";
                    break;
                }
                case 1: {
                    s = "y";
                    break;
                }
                case 2: {
                    s = "z";
                    break;
                }
                case 3: {
                    s = "r";
                }
            }
            if (s != null && !matcher.group(1).isEmpty()) {
                map.put(s, matcher.group(1));
            }
            j = matcher.end();
        }
        if (j < argumentString.length()) {
            Matcher matcher1 = KEY_VALUE_LIST_PATTERN.matcher(j == -1 ? argumentString : argumentString.substring(j));
            while (matcher1.find()) {
                map.put(matcher1.group(1), matcher1.group(2));
            }
        }
        return map;
    }
}

