/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityPolarBear
extends EntityAnimal {
    private static final DataParameter<Boolean> field_189798_bx = EntityDataManager.createKey(EntityPolarBear.class, DataSerializers.BOOLEAN);
    private float field_189799_by;
    private float field_189800_bz;
    private int field_189797_bB;

    public EntityPolarBear(World p_i47154_1_) {
        super(p_i47154_1_);
        this.setSize(1.3f, 1.4f);
    }

    @Override
    public EntityAgeable createChild(EntityAgeable ageable) {
        return new EntityPolarBear(this.worldObj);
    }

    @Override
    public boolean isBreedingItem(ItemStack stack) {
        return false;
    }

    @Override
    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new AIMeleeAttack());
        this.tasks.addTask(1, new AIPanic());
        this.tasks.addTask(4, new EntityAIFollowParent(this, 1.25));
        this.tasks.addTask(5, new EntityAIWander(this, 1.0));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new AIHurtByTarget());
        this.targetTasks.addTask(2, new AIAttackPlayer());
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.25);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(6.0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isChild() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.field_190029_eu;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.field_190028_et;
    }

    @Override
    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.playSound(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void func_189796_de() {
        if (this.field_189797_bB <= 0) {
            this.playSound(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.field_189797_bB = 40;
        }
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        return LootTableList.field_189969_E;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(field_189798_bx, false);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote) {
            this.field_189799_by = this.field_189800_bz;
            this.field_189800_bz = this.func_189793_df() ? MathHelper.clamp_float(this.field_189800_bz + 1.0f, 0.0f, 6.0f) : MathHelper.clamp_float(this.field_189800_bz - 1.0f, 0.0f, 6.0f);
        }
        if (this.field_189797_bB > 0) {
            --this.field_189797_bB;
        }
    }

    @Override
    public boolean attackEntityAsMob(Entity entityIn) {
        boolean flag = entityIn.attackEntityFrom(DamageSource.causeMobDamage(this), (int)this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getAttributeValue());
        if (flag) {
            this.applyEnchantments(this, entityIn);
        }
        return flag;
    }

    public boolean func_189793_df() {
        return this.dataManager.get(field_189798_bx);
    }

    public void func_189794_p(boolean p_189794_1_) {
        this.dataManager.set(field_189798_bx, p_189794_1_);
    }

    public float func_189795_r(float p_189795_1_) {
        return (this.field_189799_by + (this.field_189800_bz - this.field_189799_by) * p_189795_1_) / 6.0f;
    }

    @Override
    protected float func_189749_co() {
        return 0.98f;
    }

    @Override
    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (livingdata instanceof GroupData) {
            if (((GroupData)livingdata).field_190101_a) {
                this.setGrowingAge(-24000);
            }
        } else {
            GroupData entitypolarbear$groupdata = new GroupData();
            entitypolarbear$groupdata.field_190101_a = true;
            livingdata = entitypolarbear$groupdata;
        }
        return livingdata;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean field_190101_a;

        private GroupData() {
        }
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super(EntityPolarBear.this, 2.0);
        }

        @Override
        public boolean shouldExecute() {
            return !EntityPolarBear.this.isChild() && !EntityPolarBear.this.isBurning() ? false : super.shouldExecute();
        }
    }

    class AIMeleeAttack
    extends EntityAIAttackMelee {
        public AIMeleeAttack() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void func_190102_a(EntityLivingBase p_190102_1_, double p_190102_2_) {
            double d0 = this.getAttackReachSqr(p_190102_1_);
            if (p_190102_2_ <= d0 && this.attackTick <= 0) {
                this.attackTick = 20;
                this.attacker.attackEntityAsMob(p_190102_1_);
                EntityPolarBear.this.func_189794_p(false);
            } else if (p_190102_2_ <= d0 * 2.0) {
                if (this.attackTick <= 0) {
                    EntityPolarBear.this.func_189794_p(false);
                    this.attackTick = 20;
                }
                if (this.attackTick <= 10) {
                    EntityPolarBear.this.func_189794_p(true);
                    EntityPolarBear.this.func_189796_de();
                }
            } else {
                this.attackTick = 20;
                EntityPolarBear.this.func_189794_p(false);
            }
        }

        @Override
        public void resetTask() {
            EntityPolarBear.this.func_189794_p(false);
            super.resetTask();
        }

        @Override
        protected double getAttackReachSqr(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.width;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityPolarBear.this, false, new Class[0]);
        }

        @Override
        public void startExecuting() {
            super.startExecuting();
            if (EntityPolarBear.this.isChild()) {
                this.func_190105_f();
                this.resetTask();
            }
        }

        @Override
        protected void setEntityAttackTarget(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof EntityPolarBear && !((EntityPolarBear)creatureIn).isChild()) {
                super.setEntityAttackTarget(creatureIn, entityLivingBaseIn);
            }
        }
    }

    class AIAttackPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackPlayer() {
            super(EntityPolarBear.this, EntityPlayer.class, 20, true, true, null);
        }

        @Override
        public boolean shouldExecute() {
            if (EntityPolarBear.this.isChild()) {
                return false;
            }
            if (super.shouldExecute()) {
                for (EntityPolarBear entitypolarbear : EntityPolarBear.this.worldObj.getEntitiesWithinAABB(EntityPolarBear.class, EntityPolarBear.this.getEntityBoundingBox().expand(8.0, 4.0, 8.0))) {
                    if (!entitypolarbear.isChild()) continue;
                    return true;
                }
            }
            EntityPolarBear.this.setAttackTarget(null);
            return false;
        }

        @Override
        protected double getTargetDistance() {
            return super.getTargetDistance() * 0.5;
        }
    }
}

