/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySheep
extends EntityAnimal {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.createKey(EntitySheep.class, DataSerializers.BYTE);
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

        @Override
        public boolean canInteractWith(EntityPlayer playerIn) {
            return false;
        }
    }, 2, 1);
    private static final Map<EnumDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(EnumDyeColor.class);
    private int sheepTimer;
    private EntityAIEatGrass entityAIEatGrass;

    public static float[] getDyeRgb(EnumDyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    public EntitySheep(World worldIn) {
        super(worldIn);
        this.setSize(0.9f, 1.3f);
        this.inventoryCrafting.setInventorySlotContents(0, new ItemStack(Items.DYE));
        this.inventoryCrafting.setInventorySlotContents(1, new ItemStack(Items.DYE));
    }

    @Override
    protected void initEntityAI() {
        this.entityAIEatGrass = new EntityAIEatGrass(this);
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 1.25));
        this.tasks.addTask(2, new EntityAIMate(this, 1.0));
        this.tasks.addTask(3, new EntityAITempt((EntityCreature)this, 1.1, Items.WHEAT, false));
        this.tasks.addTask(4, new EntityAIFollowParent(this, 1.1));
        this.tasks.addTask(5, this.entityAIEatGrass);
        this.tasks.addTask(6, new EntityAIWander(this, 1.0));
        this.tasks.addTask(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
    }

    @Override
    protected void updateAITasks() {
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.updateAITasks();
    }

    @Override
    public void onLivingUpdate() {
        if (this.worldObj.isRemote) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.onLivingUpdate();
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(8.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.23f);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(DYE_COLOR, (byte)0);
    }

    @Override
    @Nullable
    protected ResourceLocation getLootTable() {
        if (this.getSheared()) {
            return LootTableList.ENTITIES_SHEEP;
        }
        switch (this.getFleeceColor()) {
            default: {
                return LootTableList.ENTITIES_SHEEP_WHITE;
            }
            case ORANGE: {
                return LootTableList.ENTITIES_SHEEP_ORANGE;
            }
            case MAGENTA: {
                return LootTableList.ENTITIES_SHEEP_MAGENTA;
            }
            case LIGHT_BLUE: {
                return LootTableList.ENTITIES_SHEEP_LIGHT_BLUE;
            }
            case YELLOW: {
                return LootTableList.ENTITIES_SHEEP_YELLOW;
            }
            case LIME: {
                return LootTableList.ENTITIES_SHEEP_LIME;
            }
            case PINK: {
                return LootTableList.ENTITIES_SHEEP_PINK;
            }
            case GRAY: {
                return LootTableList.ENTITIES_SHEEP_GRAY;
            }
            case SILVER: {
                return LootTableList.ENTITIES_SHEEP_SILVER;
            }
            case CYAN: {
                return LootTableList.ENTITIES_SHEEP_CYAN;
            }
            case PURPLE: {
                return LootTableList.ENTITIES_SHEEP_PURPLE;
            }
            case BLUE: {
                return LootTableList.ENTITIES_SHEEP_BLUE;
            }
            case BROWN: {
                return LootTableList.ENTITIES_SHEEP_BROWN;
            }
            case GREEN: {
                return LootTableList.ENTITIES_SHEEP_GREEN;
            }
            case RED: {
                return LootTableList.ENTITIES_SHEEP_RED;
            }
            case BLACK: 
        }
        return LootTableList.ENTITIES_SHEEP_BLACK;
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public float getHeadRotationPointY(float p_70894_1_) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f));
    }

    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.sin(f * 28.7f);
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.rotationPitch * ((float)Math.PI / 180);
    }

    @Override
    public boolean processInteract(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.getItem() == Items.SHEARS && !this.getSheared() && !this.isChild()) {
            if (!this.worldObj.isRemote) {
                this.setSheared(true);
                int i = 1 + this.rand.nextInt(3);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.entityDropItem(new ItemStack(Item.getItemFromBlock(Blocks.WOOL), 1, this.getFleeceColor().getMetadata()), 1.0f);
                    entityitem.motionY += (double)(this.rand.nextFloat() * 0.05f);
                    entityitem.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                    entityitem.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                }
            }
            stack.damageItem(1, player);
            this.playSound(SoundEvents.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
        }
        return super.processInteract(player, hand, stack);
    }

    public static void func_189802_b(DataFixer p_189802_0_) {
        EntityLiving.func_189752_a(p_189802_0_, "Sheep");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setBoolean("Sheared", this.getSheared());
        compound.setByte("Color", (byte)this.getFleeceColor().getMetadata());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.setSheared(compound.getBoolean("Sheared"));
        this.setFleeceColor(EnumDyeColor.byMetadata(compound.getByte("Color")));
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_SHEEP_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_SHEEP_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_SHEEP_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.playSound(SoundEvents.ENTITY_SHEEP_STEP, 0.15f, 1.0f);
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.byMetadata(this.dataManager.get(DYE_COLOR) & 0xF);
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = this.dataManager.get(DYE_COLOR);
        this.dataManager.set(DYE_COLOR, (byte)(b0 & 0xF0 | color.getMetadata() & 0xF));
    }

    public boolean getSheared() {
        return (this.dataManager.get(DYE_COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = this.dataManager.get(DYE_COLOR);
        if (sheared) {
            this.dataManager.set(DYE_COLOR, (byte)(b0 | 0x10));
        } else {
            this.dataManager.set(DYE_COLOR, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumDyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        return i < 5 ? EnumDyeColor.BLACK : (i < 10 ? EnumDyeColor.GRAY : (i < 15 ? EnumDyeColor.SILVER : (i < 18 ? EnumDyeColor.BROWN : (random.nextInt(500) == 0 ? EnumDyeColor.PINK : EnumDyeColor.WHITE))));
    }

    @Override
    public EntitySheep createChild(EntityAgeable ageable) {
        EntitySheep entitysheep = (EntitySheep)ageable;
        EntitySheep entitysheep1 = new EntitySheep(this.worldObj);
        entitysheep1.setFleeceColor(this.getDyeColorMixFromParents(this, entitysheep));
        return entitysheep1;
    }

    @Override
    public void eatGrassBonus() {
        this.setSheared(false);
        if (this.isChild()) {
            this.addGrowth(60);
        }
    }

    @Override
    @Nullable
    public IEntityLivingData onInitialSpawn(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.onInitialSpawn(difficulty, livingdata);
        this.setFleeceColor(EntitySheep.getRandomSheepColor(this.worldObj.rand));
        return livingdata;
    }

    private EnumDyeColor getDyeColorMixFromParents(EntityAnimal father, EntityAnimal mother) {
        int i = ((EntitySheep)father).getFleeceColor().getDyeDamage();
        int j = ((EntitySheep)mother).getFleeceColor().getDyeDamage();
        this.inventoryCrafting.getStackInSlot(0).setItemDamage(i);
        this.inventoryCrafting.getStackInSlot(1).setItemDamage(j);
        ItemStack itemstack = CraftingManager.getInstance().findMatchingRecipe(this.inventoryCrafting, ((EntitySheep)father).worldObj);
        int k = itemstack != null && itemstack.getItem() == Items.DYE ? itemstack.getMetadata() : (this.worldObj.rand.nextBoolean() ? i : j);
        return EnumDyeColor.byDyeDamage(k);
    }

    @Override
    public float getEyeHeight() {
        return 0.95f * this.height;
    }

    static {
        DYE_TO_RGB.put(EnumDyeColor.WHITE, new float[]{1.0f, 1.0f, 1.0f});
        DYE_TO_RGB.put(EnumDyeColor.ORANGE, new float[]{0.85f, 0.5f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.MAGENTA, new float[]{0.7f, 0.3f, 0.85f});
        DYE_TO_RGB.put(EnumDyeColor.LIGHT_BLUE, new float[]{0.4f, 0.6f, 0.85f});
        DYE_TO_RGB.put(EnumDyeColor.YELLOW, new float[]{0.9f, 0.9f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.LIME, new float[]{0.5f, 0.8f, 0.1f});
        DYE_TO_RGB.put(EnumDyeColor.PINK, new float[]{0.95f, 0.5f, 0.65f});
        DYE_TO_RGB.put(EnumDyeColor.GRAY, new float[]{0.3f, 0.3f, 0.3f});
        DYE_TO_RGB.put(EnumDyeColor.SILVER, new float[]{0.6f, 0.6f, 0.6f});
        DYE_TO_RGB.put(EnumDyeColor.CYAN, new float[]{0.3f, 0.5f, 0.6f});
        DYE_TO_RGB.put(EnumDyeColor.PURPLE, new float[]{0.5f, 0.25f, 0.7f});
        DYE_TO_RGB.put(EnumDyeColor.BLUE, new float[]{0.2f, 0.3f, 0.7f});
        DYE_TO_RGB.put(EnumDyeColor.BROWN, new float[]{0.4f, 0.3f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.GREEN, new float[]{0.4f, 0.5f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.RED, new float[]{0.6f, 0.2f, 0.2f});
        DYE_TO_RGB.put(EnumDyeColor.BLACK, new float[]{0.1f, 0.1f, 0.1f});
    }
}

