/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.base.Optional;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityPotion
extends EntityThrowable {
    private static final DataParameter<Optional<ItemStack>> ITEM = EntityDataManager.createKey(EntityItem.class, DataSerializers.OPTIONAL_ITEM_STACK);
    private static final Logger LOGGER = LogManager.getLogger();

    public EntityPotion(World worldIn) {
        super(worldIn);
    }

    public EntityPotion(World worldIn, EntityLivingBase throwerIn, ItemStack potionDamageIn) {
        super(worldIn, throwerIn);
        this.setItem(potionDamageIn);
    }

    public EntityPotion(World worldIn, double x, double y, double z, @Nullable ItemStack potionDamageIn) {
        super(worldIn, x, y, z);
        if (potionDamageIn != null) {
            this.setItem(potionDamageIn);
        }
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(ITEM, Optional.absent());
    }

    public ItemStack getPotion() {
        ItemStack itemstack = (ItemStack)this.getDataManager().get(ITEM).orNull();
        if (itemstack == null || itemstack.getItem() != Items.SPLASH_POTION && itemstack.getItem() != Items.LINGERING_POTION) {
            if (this.worldObj != null) {
                LOGGER.error("ThrownPotion entity {} has no item?!", new Object[]{this.getEntityId()});
            }
            return new ItemStack(Items.SPLASH_POTION);
        }
        return itemstack;
    }

    public void setItem(@Nullable ItemStack stack) {
        this.getDataManager().set(ITEM, Optional.fromNullable((Object)stack));
        this.getDataManager().setDirty(ITEM);
    }

    @Override
    protected float getGravityVelocity() {
        return 0.05f;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (!this.worldObj.isRemote) {
            ItemStack itemstack = this.getPotion();
            PotionType potiontype = PotionUtils.getPotionFromItem(itemstack);
            List<PotionEffect> list = PotionUtils.getEffectsFromStack(itemstack);
            if (result.typeOfHit == RayTraceResult.Type.BLOCK && potiontype == PotionTypes.WATER && list.isEmpty()) {
                BlockPos blockpos = result.getBlockPos().offset(result.sideHit);
                this.extinguishFires(blockpos);
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    this.extinguishFires(blockpos.offset(enumfacing));
                }
                this.worldObj.playEvent(2002, new BlockPos(this), PotionType.getID(potiontype));
                this.setDead();
            } else {
                if (!list.isEmpty()) {
                    if (this.isLingering()) {
                        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.worldObj, this.posX, this.posY, this.posZ);
                        entityareaeffectcloud.setOwner(this.getThrower());
                        entityareaeffectcloud.setRadius(3.0f);
                        entityareaeffectcloud.setRadiusOnUse(-0.5f);
                        entityareaeffectcloud.setWaitTime(10);
                        entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
                        entityareaeffectcloud.setPotion(potiontype);
                        for (PotionEffect potioneffect : PotionUtils.getFullEffectsFromItem(itemstack)) {
                            entityareaeffectcloud.addEffect(new PotionEffect(potioneffect.getPotion(), potioneffect.getDuration(), potioneffect.getAmplifier()));
                        }
                        this.worldObj.spawnEntityInWorld(entityareaeffectcloud);
                    } else {
                        AxisAlignedBB axisalignedbb = this.getEntityBoundingBox().expand(4.0, 2.0, 4.0);
                        List<EntityLivingBase> list1 = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
                        if (!list1.isEmpty()) {
                            for (EntityLivingBase entitylivingbase : list1) {
                                double d0;
                                if (!entitylivingbase.canBeHitWithPotion() || !((d0 = this.getDistanceSqToEntity(entitylivingbase)) < 16.0)) continue;
                                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                                if (entitylivingbase == result.entityHit) {
                                    d1 = 1.0;
                                }
                                for (PotionEffect potioneffect1 : list) {
                                    Potion potion = potioneffect1.getPotion();
                                    if (potion.isInstant()) {
                                        potion.affectEntity(this, this.getThrower(), entitylivingbase, potioneffect1.getAmplifier(), d1);
                                        continue;
                                    }
                                    int i = (int)(d1 * (double)potioneffect1.getDuration() + 0.5);
                                    if (i <= 20) continue;
                                    entitylivingbase.addPotionEffect(new PotionEffect(potion, i, potioneffect1.getAmplifier()));
                                }
                            }
                        }
                    }
                }
                this.worldObj.playEvent(2002, new BlockPos(this), PotionType.getID(potiontype));
                this.setDead();
            }
        }
    }

    private boolean isLingering() {
        return this.getPotion().getItem() == Items.LINGERING_POTION;
    }

    private void extinguishFires(BlockPos pos) {
        if (this.worldObj.getBlockState(pos).getBlock() == Blocks.FIRE) {
            this.worldObj.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
        }
    }

    public static void func_189665_a(DataFixer p_189665_0_) {
        EntityThrowable.func_189661_a(p_189665_0_, "ThrownPotion");
        p_189665_0_.registerWalker(FixTypes.ENTITY, new ItemStackData("ThrownPotion", new String[]{"Potion"}));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        ItemStack itemstack = ItemStack.loadItemStackFromNBT(compound.getCompoundTag("Potion"));
        if (itemstack == null) {
            this.setDead();
        } else {
            this.setItem(itemstack);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        ItemStack itemstack = this.getPotion();
        if (itemstack != null) {
            compound.setTag("Potion", itemstack.writeToNBT(new NBTTagCompound()));
        }
    }
}

