/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemBoat
extends Item {
    private final EntityBoat.Type type;

    public ItemBoat(EntityBoat.Type typeIn) {
        this.type = typeIn;
        this.maxStackSize = 1;
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
        this.setUnlocalizedName("boat." + typeIn.getName());
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        float f = 1.0f;
        float f1 = playerIn.prevRotationPitch + (playerIn.rotationPitch - playerIn.prevRotationPitch) * 1.0f;
        float f2 = playerIn.prevRotationYaw + (playerIn.rotationYaw - playerIn.prevRotationYaw) * 1.0f;
        double d0 = playerIn.prevPosX + (playerIn.posX - playerIn.prevPosX) * 1.0;
        double d1 = playerIn.prevPosY + (playerIn.posY - playerIn.prevPosY) * 1.0 + (double)playerIn.getEyeHeight();
        double d2 = playerIn.prevPosZ + (playerIn.posZ - playerIn.prevPosZ) * 1.0;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.cos(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = MathHelper.sin(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
        float f5 = -MathHelper.cos(-f1 * ((float)Math.PI / 180));
        float f6 = MathHelper.sin(-f1 * ((float)Math.PI / 180));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        Vec3d vec3d1 = vec3d.addVector((double)f7 * 5.0, (double)f6 * 5.0, (double)f8 * 5.0);
        RayTraceResult raytraceresult = worldIn.rayTraceBlocks(vec3d, vec3d1, true);
        if (raytraceresult == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
        }
        Vec3d vec3d2 = playerIn.getLook(1.0f);
        boolean flag = false;
        List<Entity> list = worldIn.getEntitiesWithinAABBExcludingEntity(playerIn, playerIn.getEntityBoundingBox().addCoord(vec3d2.xCoord * 5.0, vec3d2.yCoord * 5.0, vec3d2.zCoord * 5.0).expandXyz(1.0));
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisalignedbb;
            Entity entity = list.get(i);
            if (!entity.canBeCollidedWith() || !(axisalignedbb = entity.getEntityBoundingBox().expandXyz(entity.getCollisionBorderSize())).isVecInside(vec3d)) continue;
            flag = true;
        }
        if (flag) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
        }
        if (raytraceresult.typeOfHit != RayTraceResult.Type.BLOCK) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
        }
        Block block = worldIn.getBlockState(raytraceresult.getBlockPos()).getBlock();
        boolean flag1 = block == Blocks.WATER || block == Blocks.FLOWING_WATER;
        EntityBoat entityboat = new EntityBoat(worldIn, raytraceresult.hitVec.xCoord, flag1 ? raytraceresult.hitVec.yCoord - 0.12 : raytraceresult.hitVec.yCoord, raytraceresult.hitVec.zCoord);
        entityboat.setBoatType(this.type);
        entityboat.rotationYaw = playerIn.rotationYaw;
        if (!worldIn.getCollisionBoxes(entityboat, entityboat.getEntityBoundingBox().expandXyz(-0.1)).isEmpty()) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
        }
        if (!worldIn.isRemote) {
            worldIn.spawnEntityInWorld(entityboat);
        }
        if (!playerIn.capabilities.isCreativeMode) {
            --itemStackIn.stackSize;
        }
        playerIn.addStat(StatList.getObjectUseStats(this));
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemStackIn);
    }
}

