/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class PotionHelper {
    private static final List<MixPredicate<PotionType>> POTION_TYPE_CONVERSIONS = Lists.newArrayList();
    private static final List<MixPredicate<Item>> POTION_ITEM_CONVERSIONS = Lists.newArrayList();
    private static final List<ItemPredicateInstance> POTION_ITEMS = Lists.newArrayList();
    private static final Predicate<ItemStack> IS_POTION_ITEM = new Predicate<ItemStack>(){

        public boolean apply(@Nullable ItemStack p_apply_1_) {
            for (ItemPredicateInstance potionhelper$itempredicateinstance : POTION_ITEMS) {
                if (!potionhelper$itempredicateinstance.apply(p_apply_1_)) continue;
                return true;
            }
            return false;
        }
    };

    public static boolean isReagent(ItemStack stack) {
        return PotionHelper.isItemConversionReagent(stack) || PotionHelper.isTypeConversionReagent(stack);
    }

    protected static boolean isItemConversionReagent(ItemStack stack) {
        int j = POTION_ITEM_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            if (!PotionHelper.POTION_ITEM_CONVERSIONS.get((int)i).reagent.apply((Object)stack)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTypeConversionReagent(ItemStack stack) {
        int j = POTION_TYPE_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            if (!PotionHelper.POTION_TYPE_CONVERSIONS.get((int)i).reagent.apply((Object)stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConversions(ItemStack input, ItemStack reagent) {
        return !IS_POTION_ITEM.apply((Object)input) ? false : PotionHelper.hasItemConversions(input, reagent) || PotionHelper.hasTypeConversions(input, reagent);
    }

    protected static boolean hasItemConversions(ItemStack p_185206_0_, ItemStack p_185206_1_) {
        Item item = p_185206_0_.getItem();
        int j = POTION_ITEM_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            MixPredicate<Item> mixpredicate = POTION_ITEM_CONVERSIONS.get(i);
            if (mixpredicate.input != item || !mixpredicate.reagent.apply((Object)p_185206_1_)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasTypeConversions(ItemStack p_185209_0_, ItemStack p_185209_1_) {
        PotionType potiontype = PotionUtils.getPotionFromItem(p_185209_0_);
        int j = POTION_TYPE_CONVERSIONS.size();
        for (int i = 0; i < j; ++i) {
            MixPredicate<PotionType> mixpredicate = POTION_TYPE_CONVERSIONS.get(i);
            if (mixpredicate.input != potiontype || !mixpredicate.reagent.apply((Object)p_185209_1_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemStack doReaction(ItemStack reagent, @Nullable ItemStack potionIn) {
        if (potionIn != null) {
            int i;
            PotionType potiontype = PotionUtils.getPotionFromItem(potionIn);
            Item item = potionIn.getItem();
            int j = POTION_ITEM_CONVERSIONS.size();
            for (i = 0; i < j; ++i) {
                MixPredicate<Item> mixpredicate = POTION_ITEM_CONVERSIONS.get(i);
                if (mixpredicate.input != item || !mixpredicate.reagent.apply((Object)reagent)) continue;
                return PotionUtils.addPotionToItemStack(new ItemStack((Item)mixpredicate.output), potiontype);
            }
            int k = POTION_TYPE_CONVERSIONS.size();
            for (i = 0; i < k; ++i) {
                MixPredicate<PotionType> mixpredicate1 = POTION_TYPE_CONVERSIONS.get(i);
                if (mixpredicate1.input != potiontype || !mixpredicate1.reagent.apply((Object)reagent)) continue;
                return PotionUtils.addPotionToItemStack(new ItemStack(item), (PotionType)mixpredicate1.output);
            }
        }
        return potionIn;
    }

    public static void init() {
        ItemPredicateInstance predicate = new ItemPredicateInstance(Items.NETHER_WART);
        ItemPredicateInstance predicate1 = new ItemPredicateInstance(Items.GOLDEN_CARROT);
        ItemPredicateInstance predicate2 = new ItemPredicateInstance(Items.REDSTONE);
        ItemPredicateInstance predicate3 = new ItemPredicateInstance(Items.FERMENTED_SPIDER_EYE);
        ItemPredicateInstance predicate4 = new ItemPredicateInstance(Items.RABBIT_FOOT);
        ItemPredicateInstance predicate5 = new ItemPredicateInstance(Items.GLOWSTONE_DUST);
        ItemPredicateInstance predicate6 = new ItemPredicateInstance(Items.MAGMA_CREAM);
        ItemPredicateInstance predicate7 = new ItemPredicateInstance(Items.SUGAR);
        ItemPredicateInstance predicate8 = new ItemPredicateInstance(Items.FISH, ItemFishFood.FishType.PUFFERFISH.getMetadata());
        ItemPredicateInstance predicate9 = new ItemPredicateInstance(Items.SPECKLED_MELON);
        ItemPredicateInstance predicate10 = new ItemPredicateInstance(Items.SPIDER_EYE);
        ItemPredicateInstance predicate11 = new ItemPredicateInstance(Items.GHAST_TEAR);
        ItemPredicateInstance predicate12 = new ItemPredicateInstance(Items.BLAZE_POWDER);
        PotionHelper.registerPotionItem(new ItemPredicateInstance(Items.POTIONITEM));
        PotionHelper.registerPotionItem(new ItemPredicateInstance(Items.SPLASH_POTION));
        PotionHelper.registerPotionItem(new ItemPredicateInstance(Items.LINGERING_POTION));
        PotionHelper.registerPotionItemConversion(Items.POTIONITEM, new ItemPredicateInstance(Items.GUNPOWDER), Items.SPLASH_POTION);
        PotionHelper.registerPotionItemConversion(Items.SPLASH_POTION, new ItemPredicateInstance(Items.DRAGON_BREATH), Items.LINGERING_POTION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate9, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate11, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate4, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate12, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate10, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate7, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate6, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate5, PotionTypes.THICK);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate2, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate, PotionTypes.AWKWARD);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate1, PotionTypes.NIGHT_VISION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.NIGHT_VISION, predicate2, PotionTypes.LONG_NIGHT_VISION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.NIGHT_VISION, predicate3, PotionTypes.INVISIBILITY);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_NIGHT_VISION, predicate3, PotionTypes.LONG_INVISIBILITY);
        PotionHelper.registerPotionTypeConversion(PotionTypes.INVISIBILITY, predicate2, PotionTypes.LONG_INVISIBILITY);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate6, PotionTypes.FIRE_RESISTANCE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.FIRE_RESISTANCE, predicate2, PotionTypes.LONG_FIRE_RESISTANCE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate4, PotionTypes.LEAPING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LEAPING, predicate2, PotionTypes.LONG_LEAPING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LEAPING, predicate5, PotionTypes.STRONG_LEAPING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LEAPING, predicate3, PotionTypes.SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_LEAPING, predicate3, PotionTypes.LONG_SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SLOWNESS, predicate2, PotionTypes.LONG_SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SWIFTNESS, predicate3, PotionTypes.SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_SWIFTNESS, predicate3, PotionTypes.LONG_SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate7, PotionTypes.SWIFTNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SWIFTNESS, predicate2, PotionTypes.LONG_SWIFTNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SWIFTNESS, predicate5, PotionTypes.STRONG_SWIFTNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate8, PotionTypes.WATER_BREATHING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER_BREATHING, predicate2, PotionTypes.LONG_WATER_BREATHING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate9, PotionTypes.HEALING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.HEALING, predicate5, PotionTypes.STRONG_HEALING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.HEALING, predicate3, PotionTypes.HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRONG_HEALING, predicate3, PotionTypes.STRONG_HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.HARMING, predicate5, PotionTypes.STRONG_HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.POISON, predicate3, PotionTypes.HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_POISON, predicate3, PotionTypes.HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRONG_POISON, predicate3, PotionTypes.STRONG_HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate10, PotionTypes.POISON);
        PotionHelper.registerPotionTypeConversion(PotionTypes.POISON, predicate2, PotionTypes.LONG_POISON);
        PotionHelper.registerPotionTypeConversion(PotionTypes.POISON, predicate5, PotionTypes.STRONG_POISON);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate11, PotionTypes.REGENERATION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.REGENERATION, predicate2, PotionTypes.LONG_REGENERATION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.REGENERATION, predicate5, PotionTypes.STRONG_REGENERATION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, predicate12, PotionTypes.STRENGTH);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRENGTH, predicate2, PotionTypes.LONG_STRENGTH);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRENGTH, predicate5, PotionTypes.STRONG_STRENGTH);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, predicate3, PotionTypes.WEAKNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WEAKNESS, predicate2, PotionTypes.LONG_WEAKNESS);
    }

    private static void registerPotionItemConversion(ItemPotion p_185201_0_, ItemPredicateInstance p_185201_1_, ItemPotion p_185201_2_) {
        POTION_ITEM_CONVERSIONS.add(new MixPredicate<ItemPotion>(p_185201_0_, p_185201_1_, p_185201_2_));
    }

    private static void registerPotionItem(ItemPredicateInstance p_185202_0_) {
        POTION_ITEMS.add(p_185202_0_);
    }

    private static void registerPotionTypeConversion(PotionType input, Predicate<ItemStack> reagentPredicate, PotionType output) {
        POTION_TYPE_CONVERSIONS.add(new MixPredicate<PotionType>(input, reagentPredicate, output));
    }

    static class MixPredicate<T> {
        final T input;
        final Predicate<ItemStack> reagent;
        final T output;

        public MixPredicate(T inputIn, Predicate<ItemStack> reagentIn, T outputIn) {
            this.input = inputIn;
            this.reagent = reagentIn;
            this.output = outputIn;
        }
    }

    static class ItemPredicateInstance
    implements Predicate<ItemStack> {
        private final Item item;
        private final int meta;

        public ItemPredicateInstance(Item itemIn) {
            this(itemIn, -1);
        }

        public ItemPredicateInstance(Item itemIn, int metaIn) {
            this.item = itemIn;
            this.meta = metaIn;
        }

        public boolean apply(@Nullable ItemStack p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.getItem() == this.item && (this.meta == -1 || this.meta == p_apply_1_.getMetadata());
        }
    }
}

