/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScoreboardSaveData
extends WorldSavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private Scoreboard theScoreboard;
    private NBTTagCompound delayedInitNbt;

    public ScoreboardSaveData() {
        this("scoreboard");
    }

    public ScoreboardSaveData(String name) {
        super(name);
    }

    public void setScoreboard(Scoreboard scoreboardIn) {
        this.theScoreboard = scoreboardIn;
        if (this.delayedInitNbt != null) {
            this.readFromNBT(this.delayedInitNbt);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (this.theScoreboard == null) {
            this.delayedInitNbt = nbt;
        } else {
            this.readObjectives(nbt.getTagList("Objectives", 10));
            this.readScores(nbt.getTagList("PlayerScores", 10));
            if (nbt.hasKey("DisplaySlots", 10)) {
                this.readDisplayConfig(nbt.getCompoundTag("DisplaySlots"));
            }
            if (nbt.hasKey("Teams", 9)) {
                this.readTeams(nbt.getTagList("Teams", 10));
            }
        }
    }

    protected void readTeams(NBTTagList tagList) {
        for (int i = 0; i < tagList.tagCount(); ++i) {
            Team.CollisionRule team$collisionrule;
            Team.EnumVisible team$enumvisible1;
            Team.EnumVisible team$enumvisible;
            NBTTagCompound nbttagcompound = tagList.getCompoundTagAt(i);
            String s = nbttagcompound.getString("Name");
            if (s.length() > 16) {
                s = s.substring(0, 16);
            }
            ScorePlayerTeam scoreplayerteam = this.theScoreboard.createTeam(s);
            String s1 = nbttagcompound.getString("DisplayName");
            if (s1.length() > 32) {
                s1 = s1.substring(0, 32);
            }
            scoreplayerteam.setTeamName(s1);
            if (nbttagcompound.hasKey("TeamColor", 8)) {
                scoreplayerteam.setChatFormat(TextFormatting.getValueByName(nbttagcompound.getString("TeamColor")));
            }
            scoreplayerteam.setNamePrefix(nbttagcompound.getString("Prefix"));
            scoreplayerteam.setNameSuffix(nbttagcompound.getString("Suffix"));
            if (nbttagcompound.hasKey("AllowFriendlyFire", 99)) {
                scoreplayerteam.setAllowFriendlyFire(nbttagcompound.getBoolean("AllowFriendlyFire"));
            }
            if (nbttagcompound.hasKey("SeeFriendlyInvisibles", 99)) {
                scoreplayerteam.setSeeFriendlyInvisiblesEnabled(nbttagcompound.getBoolean("SeeFriendlyInvisibles"));
            }
            if (nbttagcompound.hasKey("NameTagVisibility", 8) && (team$enumvisible = Team.EnumVisible.getByName(nbttagcompound.getString("NameTagVisibility"))) != null) {
                scoreplayerteam.setNameTagVisibility(team$enumvisible);
            }
            if (nbttagcompound.hasKey("DeathMessageVisibility", 8) && (team$enumvisible1 = Team.EnumVisible.getByName(nbttagcompound.getString("DeathMessageVisibility"))) != null) {
                scoreplayerteam.setDeathMessageVisibility(team$enumvisible1);
            }
            if (nbttagcompound.hasKey("CollisionRule", 8) && (team$collisionrule = Team.CollisionRule.getByName(nbttagcompound.getString("CollisionRule"))) != null) {
                scoreplayerteam.setCollisionRule(team$collisionrule);
            }
            this.loadTeamPlayers(scoreplayerteam, nbttagcompound.getTagList("Players", 8));
        }
    }

    protected void loadTeamPlayers(ScorePlayerTeam playerTeam, NBTTagList tagList) {
        for (int i = 0; i < tagList.tagCount(); ++i) {
            this.theScoreboard.addPlayerToTeam(tagList.getStringTagAt(i), playerTeam.getRegisteredName());
        }
    }

    protected void readDisplayConfig(NBTTagCompound compound) {
        for (int i = 0; i < 19; ++i) {
            if (!compound.hasKey("slot_" + i, 8)) continue;
            String s = compound.getString("slot_" + i);
            ScoreObjective scoreobjective = this.theScoreboard.getObjective(s);
            this.theScoreboard.setObjectiveInDisplaySlot(i, scoreobjective);
        }
    }

    protected void readObjectives(NBTTagList nbt) {
        for (int i = 0; i < nbt.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = nbt.getCompoundTagAt(i);
            IScoreCriteria iscorecriteria = IScoreCriteria.INSTANCES.get(nbttagcompound.getString("CriteriaName"));
            if (iscorecriteria == null) continue;
            String s = nbttagcompound.getString("Name");
            if (s.length() > 16) {
                s = s.substring(0, 16);
            }
            ScoreObjective scoreobjective = this.theScoreboard.addScoreObjective(s, iscorecriteria);
            scoreobjective.setDisplayName(nbttagcompound.getString("DisplayName"));
            scoreobjective.setRenderType(IScoreCriteria.EnumRenderType.getByName(nbttagcompound.getString("RenderType")));
        }
    }

    protected void readScores(NBTTagList nbt) {
        for (int i = 0; i < nbt.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = nbt.getCompoundTagAt(i);
            ScoreObjective scoreobjective = this.theScoreboard.getObjective(nbttagcompound.getString("Objective"));
            String s = nbttagcompound.getString("Name");
            if (s.length() > 40) {
                s = s.substring(0, 40);
            }
            Score score = this.theScoreboard.getOrCreateScore(s, scoreobjective);
            score.setScorePoints(nbttagcompound.getInteger("Score"));
            if (!nbttagcompound.hasKey("Locked")) continue;
            score.setLocked(nbttagcompound.getBoolean("Locked"));
        }
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound p_189551_1_) {
        if (this.theScoreboard == null) {
            LOGGER.warn("Tried to save scoreboard without having a scoreboard...");
            return p_189551_1_;
        }
        p_189551_1_.setTag("Objectives", this.objectivesToNbt());
        p_189551_1_.setTag("PlayerScores", this.scoresToNbt());
        p_189551_1_.setTag("Teams", this.teamsToNbt());
        this.fillInDisplaySlots(p_189551_1_);
        return p_189551_1_;
    }

    protected NBTTagList teamsToNbt() {
        NBTTagList nbttaglist = new NBTTagList();
        for (ScorePlayerTeam scoreplayerteam : this.theScoreboard.getTeams()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setString("Name", scoreplayerteam.getRegisteredName());
            nbttagcompound.setString("DisplayName", scoreplayerteam.getTeamName());
            if (scoreplayerteam.getChatFormat().getColorIndex() >= 0) {
                nbttagcompound.setString("TeamColor", scoreplayerteam.getChatFormat().getFriendlyName());
            }
            nbttagcompound.setString("Prefix", scoreplayerteam.getColorPrefix());
            nbttagcompound.setString("Suffix", scoreplayerteam.getColorSuffix());
            nbttagcompound.setBoolean("AllowFriendlyFire", scoreplayerteam.getAllowFriendlyFire());
            nbttagcompound.setBoolean("SeeFriendlyInvisibles", scoreplayerteam.getSeeFriendlyInvisiblesEnabled());
            nbttagcompound.setString("NameTagVisibility", scoreplayerteam.getNameTagVisibility().internalName);
            nbttagcompound.setString("DeathMessageVisibility", scoreplayerteam.getDeathMessageVisibility().internalName);
            nbttagcompound.setString("CollisionRule", scoreplayerteam.getCollisionRule().name);
            NBTTagList nbttaglist1 = new NBTTagList();
            for (String s : scoreplayerteam.getMembershipCollection()) {
                nbttaglist1.appendTag(new NBTTagString(s));
            }
            nbttagcompound.setTag("Players", nbttaglist1);
            nbttaglist.appendTag(nbttagcompound);
        }
        return nbttaglist;
    }

    protected void fillInDisplaySlots(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        boolean flag = false;
        for (int i = 0; i < 19; ++i) {
            ScoreObjective scoreobjective = this.theScoreboard.getObjectiveInDisplaySlot(i);
            if (scoreobjective == null) continue;
            nbttagcompound.setString("slot_" + i, scoreobjective.getName());
            flag = true;
        }
        if (flag) {
            compound.setTag("DisplaySlots", nbttagcompound);
        }
    }

    protected NBTTagList objectivesToNbt() {
        NBTTagList nbttaglist = new NBTTagList();
        for (ScoreObjective scoreobjective : this.theScoreboard.getScoreObjectives()) {
            if (scoreobjective.getCriteria() == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setString("Name", scoreobjective.getName());
            nbttagcompound.setString("CriteriaName", scoreobjective.getCriteria().getName());
            nbttagcompound.setString("DisplayName", scoreobjective.getDisplayName());
            nbttagcompound.setString("RenderType", scoreobjective.getRenderType().getRenderType());
            nbttaglist.appendTag(nbttagcompound);
        }
        return nbttaglist;
    }

    protected NBTTagList scoresToNbt() {
        NBTTagList nbttaglist = new NBTTagList();
        for (Score score : this.theScoreboard.getScores()) {
            if (score.getObjective() == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setString("Name", score.getPlayerName());
            nbttagcompound.setString("Objective", score.getObjective().getName());
            nbttagcompound.setInteger("Score", score.getScorePoints());
            nbttagcompound.setBoolean("Locked", score.isLocked());
            nbttaglist.appendTag(nbttagcompound);
        }
        return nbttaglist;
    }
}

