/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure.template;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class TemplateManager {
    private final Map<String, Template> templates = Maps.newHashMap();
    private final String baseFolder;

    public TemplateManager(String basefolderIn) {
        this.baseFolder = basefolderIn;
    }

    public Template getTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        Template template = this.func_189942_b(server, id);
        if (template == null) {
            template = new Template();
            this.templates.put(id.getResourcePath(), template);
        }
        return template;
    }

    @Nullable
    public Template func_189942_b(@Nullable MinecraftServer p_189942_1_, ResourceLocation p_189942_2_) {
        String s = p_189942_2_.getResourcePath();
        if (this.templates.containsKey(s)) {
            return this.templates.get(s);
        }
        if (p_189942_1_ != null) {
            this.readTemplate(p_189942_1_, p_189942_2_);
        } else {
            this.readTemplateFromJar(p_189942_2_);
        }
        return this.templates.containsKey(s) ? this.templates.get(s) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readTemplate(MinecraftServer server, ResourceLocation id) {
        boolean bl;
        String s = id.getResourcePath();
        File file1 = new File(this.baseFolder, s + ".nbt");
        if (!file1.exists()) {
            return this.readTemplateFromJar(id);
        }
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file1);
            this.readTemplateFromStream(s, inputstream);
            bl = true;
        }
        catch (Throwable var11) {
            boolean flag;
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return flag;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readTemplateFromJar(ResourceLocation id) {
        boolean bl;
        String s = id.getResourceDomain();
        String s1 = id.getResourcePath();
        InputStream inputstream = null;
        try {
            inputstream = MinecraftServer.class.getResourceAsStream("/assets/" + s + "/structures/" + s1 + ".nbt");
            this.readTemplateFromStream(s1, inputstream);
            bl = true;
        }
        catch (Throwable var10) {
            try {
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return bl;
    }

    private void readTemplateFromStream(String id, InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(stream);
        Template template = new Template();
        template.read(nbttagcompound);
        this.templates.put(id, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        boolean bl;
        String s = id.getResourcePath();
        if (server == null || !this.templates.containsKey(s)) return false;
        File file1 = new File(this.baseFolder);
        if (!file1.exists() ? !file1.mkdirs() : !file1.isDirectory()) {
            return false;
        }
        File file2 = new File(file1, s + ".nbt");
        Template template = this.templates.get(s);
        FileOutputStream outputstream = null;
        try {
            NBTTagCompound nbttagcompound = template.func_189552_a(new NBTTagCompound());
            outputstream = new FileOutputStream(file2);
            CompressedStreamTools.writeCompressed(nbttagcompound, outputstream);
            bl = true;
        }
        catch (Throwable var13) {
            try {
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(outputstream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outputstream);
        return bl;
    }

    public void func_189941_a(ResourceLocation p_189941_1_) {
        this.templates.remove(p_189941_1_.getResourcePath());
    }
}

