/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievement;

import java.io.IOException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.input.Mouse;

public class GuiAchievements
extends GuiScreen
implements IProgressMeter {
    private static final int X_MIN = AchievementList.minDisplayColumn * 24 - 112;
    private static final int Y_MIN = AchievementList.minDisplayRow * 24 - 112;
    private static final int X_MAX = AchievementList.maxDisplayColumn * 24 - 77;
    private static final int Y_MAX = AchievementList.maxDisplayRow * 24 - 77;
    private static final ResourceLocation ACHIEVEMENT_BACKGROUND = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    protected GuiScreen parentScreen;
    protected int imageWidth = 256;
    protected int imageHeight = 202;
    protected int xLastScroll;
    protected int yLastScroll;
    protected float zoom = 1.0f;
    protected double xScrollO;
    protected double yScrollO;
    protected double xScrollP;
    protected double yScrollP;
    protected double xScrollTarget;
    protected double yScrollTarget;
    private int scrolling;
    private final StatisticsManager statFileWriter;
    private boolean loadingAchievements = true;

    public GuiAchievements(GuiScreen parentScreenIn, StatisticsManager statFileWriterIn) {
        this.parentScreen = parentScreenIn;
        this.statFileWriter = statFileWriterIn;
        int i = 141;
        int j = 141;
        this.xScrollO = this.xScrollTarget = (double)(AchievementList.OPEN_INVENTORY.displayColumn * 24 - 70 - 12);
        this.xScrollP = this.xScrollTarget;
        this.yScrollO = this.yScrollTarget = (double)(AchievementList.OPEN_INVENTORY.displayRow * 24 - 70);
        this.yScrollP = this.yScrollTarget;
    }

    @Override
    public void initGui() {
        this.mc.getConnection().sendPacket(new CPacketClientStatus(CPacketClientStatus.State.REQUEST_STATS));
        this.buttonList.clear();
        this.buttonList.add(new GuiOptionButton(1, width / 2 + 24, this.height / 2 + 74, 80, 20, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!this.loadingAchievements && button.id == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        } else {
            super.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        if (this.loadingAchievements) {
            this.drawDefaultBackground();
            this.drawCenteredString(this.fontRendererObj, I18n.format("multiplayer.downloadingStats", new Object[0]), width / 2, this.height / 2, 0xFFFFFF);
            this.drawCenteredString(this.fontRendererObj, LOADING_STRINGS[(int)(Minecraft.getSystemTime() / 150L % (long)LOADING_STRINGS.length)], width / 2, this.height / 2 + this.fontRendererObj.FONT_HEIGHT * 2, 0xFFFFFF);
        } else {
            if (Mouse.isButtonDown((int)0)) {
                int i = (width - this.imageWidth) / 2;
                int j = (this.height - this.imageHeight) / 2;
                int k = i + 8;
                int l = j + 17;
                if ((this.scrolling == 0 || this.scrolling == 1) && mouseX >= k && mouseX < k + 224 && mouseY >= l && mouseY < l + 155) {
                    if (this.scrolling == 0) {
                        this.scrolling = 1;
                    } else {
                        this.xScrollP -= (double)((float)(mouseX - this.xLastScroll) * this.zoom);
                        this.yScrollP -= (double)((float)(mouseY - this.yLastScroll) * this.zoom);
                        this.xScrollO = this.xScrollP;
                        this.yScrollO = this.yScrollP;
                        this.xScrollTarget = this.xScrollP;
                        this.yScrollTarget = this.yScrollP;
                    }
                    this.xLastScroll = mouseX;
                    this.yLastScroll = mouseY;
                }
            } else {
                this.scrolling = 0;
            }
            int i1 = Mouse.getDWheel();
            float f2 = this.zoom;
            if (i1 < 0) {
                this.zoom += 0.25f;
            } else if (i1 > 0) {
                this.zoom -= 0.25f;
            }
            this.zoom = MathHelper.clamp_float(this.zoom, 1.0f, 2.0f);
            if (this.zoom != f2) {
                float f3 = f2 * (float)this.imageWidth;
                float f4 = f2 * (float)this.imageHeight;
                float f = this.zoom * (float)this.imageWidth;
                float f1 = this.zoom * (float)this.imageHeight;
                this.xScrollP -= (double)((f - f3) * 0.5f);
                this.yScrollP -= (double)((f1 - f4) * 0.5f);
                this.xScrollO = this.xScrollP;
                this.yScrollO = this.yScrollP;
                this.xScrollTarget = this.xScrollP;
                this.yScrollTarget = this.yScrollP;
            }
            if (this.xScrollTarget < (double)X_MIN) {
                this.xScrollTarget = X_MIN;
            }
            if (this.yScrollTarget < (double)Y_MIN) {
                this.yScrollTarget = Y_MIN;
            }
            if (this.xScrollTarget >= (double)X_MAX) {
                this.xScrollTarget = X_MAX - 1;
            }
            if (this.yScrollTarget >= (double)Y_MAX) {
                this.yScrollTarget = Y_MAX - 1;
            }
            this.drawDefaultBackground();
            this.drawAchievementScreen(mouseX, mouseY, partialTicks);
            GlStateManager.disableLighting();
            GlStateManager.disableDepth();
            this.drawTitle();
            GlStateManager.enableLighting();
            GlStateManager.enableDepth();
        }
    }

    @Override
    public void doneLoading() {
        if (this.loadingAchievements) {
            this.loadingAchievements = false;
        }
    }

    @Override
    public void updateScreen() {
        if (!this.loadingAchievements) {
            this.xScrollO = this.xScrollP;
            this.yScrollO = this.yScrollP;
            double d0 = this.xScrollTarget - this.xScrollP;
            double d1 = this.yScrollTarget - this.yScrollP;
            if (d0 * d0 + d1 * d1 < 4.0) {
                this.xScrollP += d0;
                this.yScrollP += d1;
            } else {
                this.xScrollP += d0 * 0.85;
                this.yScrollP += d1 * 0.85;
            }
        }
    }

    protected void drawTitle() {
        int i = (width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.fontRendererObj.drawString(I18n.format("gui.achievements", new Object[0]), i + 15, j + 5, 0x404040);
    }

    protected void drawAchievementScreen(int p_146552_1_, int p_146552_2_, float p_146552_3_) {
        int i = MathHelper.floor_double(this.xScrollO + (this.xScrollP - this.xScrollO) * (double)p_146552_3_);
        int j = MathHelper.floor_double(this.yScrollO + (this.yScrollP - this.yScrollO) * (double)p_146552_3_);
        if (i < X_MIN) {
            i = X_MIN;
        }
        if (j < Y_MIN) {
            j = Y_MIN;
        }
        if (i >= X_MAX) {
            i = X_MAX - 1;
        }
        if (j >= Y_MAX) {
            j = Y_MAX - 1;
        }
        int k = (width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        int i1 = k + 16;
        int j1 = l + 17;
        this.zLevel = 0.0f;
        GlStateManager.depthFunc(518);
        GlStateManager.pushMatrix();
        GlStateManager.translate(i1, j1, -200.0f);
        GlStateManager.scale(1.0f / this.zoom, 1.0f / this.zoom, 0.0f);
        GlStateManager.enableTexture2D();
        GlStateManager.disableLighting();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableColorMaterial();
        int k1 = i + 288 >> 4;
        int l1 = j + 288 >> 4;
        int i2 = (i + 288) % 16;
        int j2 = (j + 288) % 16;
        int k2 = 4;
        int l2 = 8;
        int i3 = 10;
        int j3 = 22;
        int k3 = 37;
        Random random = new Random();
        float f = 16.0f / this.zoom;
        float f1 = 16.0f / this.zoom;
        int l3 = 0;
        while ((float)l3 * f - (float)j2 < 155.0f) {
            float f2 = 0.6f - (float)(l1 + l3) / 25.0f * 0.3f;
            GlStateManager.color(f2, f2, f2, 1.0f);
            int i4 = 0;
            while ((float)i4 * f1 - (float)i2 < 224.0f) {
                random.setSeed(this.mc.getSession().getPlayerID().hashCode() + k1 + i4 + (l1 + l3) * 16);
                int j4 = random.nextInt(1 + l1 + l3) + (l1 + l3) / 2;
                TextureAtlasSprite textureatlassprite = this.getTexture(Blocks.SAND);
                if (j4 <= 37 && l1 + l3 != 35) {
                    if (j4 == 22) {
                        textureatlassprite = random.nextInt(2) == 0 ? this.getTexture(Blocks.DIAMOND_ORE) : this.getTexture(Blocks.REDSTONE_ORE);
                    } else if (j4 == 10) {
                        textureatlassprite = this.getTexture(Blocks.IRON_ORE);
                    } else if (j4 == 8) {
                        textureatlassprite = this.getTexture(Blocks.COAL_ORE);
                    } else if (j4 > 4) {
                        textureatlassprite = this.getTexture(Blocks.STONE);
                    } else if (j4 > 0) {
                        textureatlassprite = this.getTexture(Blocks.DIRT);
                    }
                } else {
                    Block block = Blocks.BEDROCK;
                    textureatlassprite = this.getTexture(block);
                }
                this.mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                this.drawTexturedModalRect(i4 * 16 - i2, l3 * 16 - j2, textureatlassprite, 16, 16);
                ++i4;
            }
            ++l3;
        }
        GlStateManager.enableDepth();
        GlStateManager.depthFunc(515);
        this.mc.getTextureManager().bindTexture(ACHIEVEMENT_BACKGROUND);
        int j5 = 0;
        while (j5 < AchievementList.ACHIEVEMENTS.size()) {
            Achievement achievement1 = AchievementList.ACHIEVEMENTS.get(j5);
            if (achievement1.parentAchievement != null) {
                int k5 = achievement1.displayColumn * 24 - i + 11;
                int l5 = achievement1.displayRow * 24 - j + 11;
                int j6 = achievement1.parentAchievement.displayColumn * 24 - i + 11;
                int k6 = achievement1.parentAchievement.displayRow * 24 - j + 11;
                boolean flag = this.statFileWriter.hasAchievementUnlocked(achievement1);
                boolean flag1 = this.statFileWriter.canUnlockAchievement(achievement1);
                int k4 = this.statFileWriter.countRequirementsUntilAvailable(achievement1);
                if (k4 <= 4) {
                    int l4 = -16777216;
                    if (flag) {
                        l4 = -6250336;
                    } else if (flag1) {
                        l4 = -16711936;
                    }
                    this.drawHorizontalLine(k5, j6, l5, l4);
                    this.drawVerticalLine(j6, l5, k6, l4);
                    if (k5 > j6) {
                        this.drawTexturedModalRect(k5 - 11 - 7, l5 - 5, 114, 234, 7, 11);
                    } else if (k5 < j6) {
                        this.drawTexturedModalRect(k5 + 11, l5 - 5, 107, 234, 7, 11);
                    } else if (l5 > k6) {
                        this.drawTexturedModalRect(k5 - 5, l5 - 11 - 7, 96, 234, 11, 7);
                    } else if (l5 < k6) {
                        this.drawTexturedModalRect(k5 - 5, l5 + 11, 96, 241, 11, 7);
                    }
                }
            }
            ++j5;
        }
        Achievement achievement = null;
        float f3 = (float)(p_146552_1_ - i1) * this.zoom;
        float f4 = (float)(p_146552_2_ - j1) * this.zoom;
        RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.disableLighting();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableColorMaterial();
        int i6 = 0;
        while (i6 < AchievementList.ACHIEVEMENTS.size()) {
            block50: {
                int j7;
                int l6;
                Achievement achievement2;
                block52: {
                    int l7;
                    block55: {
                        block54: {
                            block53: {
                                block51: {
                                    achievement2 = AchievementList.ACHIEVEMENTS.get(i6);
                                    l6 = achievement2.displayColumn * 24 - i;
                                    j7 = achievement2.displayRow * 24 - j;
                                    if (l6 < -24 || j7 < -24 || !((float)l6 <= 224.0f * this.zoom) || !((float)j7 <= 155.0f * this.zoom)) break block50;
                                    l7 = this.statFileWriter.countRequirementsUntilAvailable(achievement2);
                                    if (!this.statFileWriter.hasAchievementUnlocked(achievement2)) break block51;
                                    float f5 = 0.75f;
                                    GlStateManager.color(0.75f, 0.75f, 0.75f, 1.0f);
                                    break block52;
                                }
                                if (!this.statFileWriter.canUnlockAchievement(achievement2)) break block53;
                                float f6 = 1.0f;
                                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                                break block52;
                            }
                            if (l7 >= 3) break block54;
                            float f7 = 0.3f;
                            GlStateManager.color(0.3f, 0.3f, 0.3f, 1.0f);
                            break block52;
                        }
                        if (l7 != 3) break block55;
                        float f8 = 0.2f;
                        GlStateManager.color(0.2f, 0.2f, 0.2f, 1.0f);
                        break block52;
                    }
                    if (l7 != 4) break block50;
                    float f9 = 0.1f;
                    GlStateManager.color(0.1f, 0.1f, 0.1f, 1.0f);
                }
                this.mc.getTextureManager().bindTexture(ACHIEVEMENT_BACKGROUND);
                if (achievement2.getSpecial()) {
                    this.drawTexturedModalRect(l6 - 2, j7 - 2, 26, 202, 26, 26);
                } else {
                    this.drawTexturedModalRect(l6 - 2, j7 - 2, 0, 202, 26, 26);
                }
                if (!this.statFileWriter.canUnlockAchievement(achievement2)) {
                    float f10 = 0.1f;
                    GlStateManager.color(0.1f, 0.1f, 0.1f, 1.0f);
                    this.itemRender.isNotRenderingEffectsInGUI(false);
                }
                GlStateManager.enableLighting();
                GlStateManager.enableCull();
                this.itemRender.renderItemAndEffectIntoGUI(achievement2.theItemStack, l6 + 3, j7 + 3);
                GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.disableLighting();
                if (!this.statFileWriter.canUnlockAchievement(achievement2)) {
                    this.itemRender.isNotRenderingEffectsInGUI(true);
                }
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                if (f3 >= (float)l6 && f3 <= (float)(l6 + 22) && f4 >= (float)j7 && f4 <= (float)(j7 + 22)) {
                    achievement = achievement2;
                }
            }
            ++i6;
        }
        GlStateManager.disableDepth();
        GlStateManager.enableBlend();
        GlStateManager.popMatrix();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(ACHIEVEMENT_BACKGROUND);
        this.drawTexturedModalRect(k, l, 0, 0, this.imageWidth, this.imageHeight);
        this.zLevel = 0.0f;
        GlStateManager.depthFunc(515);
        GlStateManager.disableDepth();
        GlStateManager.enableTexture2D();
        super.drawScreen(p_146552_1_, p_146552_2_, p_146552_3_);
        if (achievement != null) {
            String s = achievement.getStatName().getUnformattedText();
            String s1 = achievement.getDescription();
            int i7 = p_146552_1_ + 12;
            int k7 = p_146552_2_ - 4;
            int i8 = this.statFileWriter.countRequirementsUntilAvailable(achievement);
            if (this.statFileWriter.canUnlockAchievement(achievement)) {
                int j8 = Math.max(this.fontRendererObj.getStringWidth(s), 120);
                int i9 = this.fontRendererObj.splitStringWidth(s1, j8);
                if (this.statFileWriter.hasAchievementUnlocked(achievement)) {
                    i9 += 12;
                }
                this.drawGradientRect(i7 - 3, k7 - 3, i7 + j8 + 3, k7 + i9 + 3 + 12, -1073741824, -1073741824);
                this.fontRendererObj.drawSplitString(s1, i7, k7 + 12, j8, -6250336);
                if (this.statFileWriter.hasAchievementUnlocked(achievement)) {
                    this.fontRendererObj.drawStringWithShadow(I18n.format("achievement.taken", new Object[0]), i7, k7 + i9 + 4, -7302913);
                }
            } else if (i8 == 3) {
                s = I18n.format("achievement.unknown", new Object[0]);
                int k8 = Math.max(this.fontRendererObj.getStringWidth(s), 120);
                String s2 = new TextComponentTranslation("achievement.requires", achievement.parentAchievement.getStatName()).getUnformattedText();
                int i5 = this.fontRendererObj.splitStringWidth(s2, k8);
                this.drawGradientRect(i7 - 3, k7 - 3, i7 + k8 + 3, k7 + i5 + 12 + 3, -1073741824, -1073741824);
                this.fontRendererObj.drawSplitString(s2, i7, k7 + 12, k8, -9416624);
            } else if (i8 < 3) {
                int l8 = Math.max(this.fontRendererObj.getStringWidth(s), 120);
                String s3 = new TextComponentTranslation("achievement.requires", achievement.parentAchievement.getStatName()).getUnformattedText();
                int j9 = this.fontRendererObj.splitStringWidth(s3, l8);
                this.drawGradientRect(i7 - 3, k7 - 3, i7 + l8 + 3, k7 + j9 + 12 + 3, -1073741824, -1073741824);
                this.fontRendererObj.drawSplitString(s3, i7, k7 + 12, l8, -9416624);
            } else {
                s = null;
            }
            if (s != null) {
                this.fontRendererObj.drawStringWithShadow(s, i7, k7, this.statFileWriter.canUnlockAchievement(achievement) ? (achievement.getSpecial() ? -128 : -1) : (achievement.getSpecial() ? -8355776 : -8355712));
            }
        }
        GlStateManager.enableDepth();
        GlStateManager.enableLighting();
        RenderHelper.disableStandardItemLighting();
    }

    private TextureAtlasSprite getTexture(Block blockIn) {
        return Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(blockIn.getDefaultState());
    }

    @Override
    public boolean doesGuiPauseGame() {
        return !this.loadingAchievements;
    }
}

