/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.BitSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import optfine.BetterGrass;
import optfine.BetterSnow;
import optfine.Config;
import optfine.ConnectedTextures;
import optfine.CustomColors;
import optfine.NaturalTextures;
import optfine.Reflector;
import optfine.RenderEnv;
import optfine.SmartLeaves;
import shadersmod.client.SVertexBuilder;

public class BlockModelRenderer {
    private final BlockColors blockColors;
    private static float aoLightValueOpaque = 0.2f;

    public static void updateAoLightValue() {
        aoLightValueOpaque = 1.0f - Config.getAmbientOcclusionLevel() * 0.8f;
    }

    public BlockModelRenderer(BlockColors blockColorsIn) {
        this.blockColors = blockColorsIn;
        if (Reflector.ForgeModContainer_forgeLightPipelineEnabled.exists()) {
            Reflector.setFieldValue(Reflector.ForgeModContainer_forgeLightPipelineEnabled, false);
        }
    }

    public boolean renderModel(IBlockAccess blockAccessIn, IBakedModel modelIn, IBlockState blockStateIn, BlockPos blockPosIn, VertexBuffer buffer, boolean checkSides) {
        boolean flag;
        try {
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity(blockStateIn, blockPosIn, blockAccessIn, buffer);
            }
            flag = this.renderModel(blockAccessIn, modelIn, blockStateIn, blockPosIn, buffer, checkSides, MathHelper.getPositionRandom(blockPosIn));
        }
        finally {
            if (Config.isShaders()) {
                SVertexBuilder.popEntity(buffer);
            }
        }
        return flag;
    }

    public boolean renderModel(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, VertexBuffer buffer, boolean checkSides, long rand) {
        boolean flag = Minecraft.isAmbientOcclusionEnabled() && stateIn.getLightValue() == 0 && modelIn.isAmbientOcclusion();
        try {
            if (Config.isTreesSmart() && stateIn.getBlock() instanceof BlockLeaves) {
                modelIn = SmartLeaves.getLeavesModel(modelIn);
            }
            if (!Config.isAlternateBlocks()) {
                rand = 0L;
            }
            return flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, buffer, checkSides, rand) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, buffer, checkSides, rand);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block model being tesselated");
            CrashReportCategory.addBlockInfo(crashreportcategory, posIn, stateIn);
            crashreportcategory.addCrashSection("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean renderModelSmooth(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, VertexBuffer buffer, boolean checkSides, long rand) {
        boolean flag = false;
        RenderEnv renderenv = null;
        boolean flag1 = Config.isTreesSmart() && stateIn.getBlock() instanceof BlockLeaves;
        EnumFacing[] enumFacingArray = EnumFacing.VALUES;
        int n = EnumFacing.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            List list = modelIn.getQuads(stateIn, enumfacing, rand);
            if (!(flag1 && worldIn.getBlockState(posIn.offset(enumfacing)) == stateIn || list.isEmpty() || checkSides && !stateIn.shouldSideBeRendered(worldIn, posIn, enumfacing))) {
                if (renderenv == null) {
                    renderenv = RenderEnv.getInstance(worldIn, stateIn, posIn);
                }
                if (!renderenv.isBreakingAnimation(list) && Config.isBetterGrass()) {
                    list = BetterGrass.getFaceQuads(worldIn, stateIn, posIn, enumfacing, list);
                }
                this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list, renderenv);
                flag = true;
            }
            ++n2;
        }
        List<BakedQuad> list1 = modelIn.getQuads(stateIn, null, rand);
        if (!list1.isEmpty()) {
            if (renderenv == null) {
                renderenv = RenderEnv.getInstance(worldIn, stateIn, posIn);
            }
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list1, renderenv);
            flag = true;
        }
        if (renderenv != null && Config.isBetterSnow() && !renderenv.isBreakingAnimation() && BetterSnow.shouldRender(worldIn, stateIn, posIn)) {
            IBakedModel ibakedmodel = BetterSnow.getModelSnowLayer();
            IBlockState iblockstate = BetterSnow.getStateSnowLayer();
            this.renderModelSmooth(worldIn, ibakedmodel, iblockstate, posIn, buffer, true, rand);
        }
        return flag;
    }

    public boolean renderModelFlat(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, VertexBuffer buffer, boolean checkSides, long rand) {
        boolean flag = false;
        RenderEnv renderenv = null;
        boolean flag1 = Config.isTreesSmart() && stateIn.getBlock() instanceof BlockLeaves;
        EnumFacing[] enumFacingArray = EnumFacing.VALUES;
        int n = EnumFacing.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            List list = modelIn.getQuads(stateIn, enumfacing, rand);
            if (!(flag1 && worldIn.getBlockState(posIn.offset(enumfacing)) == stateIn || list.isEmpty() || checkSides && !stateIn.shouldSideBeRendered(worldIn, posIn, enumfacing))) {
                if (renderenv == null) {
                    renderenv = RenderEnv.getInstance(worldIn, stateIn, posIn);
                }
                if (!renderenv.isBreakingAnimation(list) && Config.isBetterGrass()) {
                    list = BetterGrass.getFaceQuads(worldIn, stateIn, posIn, enumfacing, list);
                }
                int i = stateIn.getPackedLightmapCoords(worldIn, posIn.offset(enumfacing));
                this.renderQuadsFlat(worldIn, stateIn, posIn, i, false, buffer, list, renderenv);
                flag = true;
            }
            ++n2;
        }
        List<BakedQuad> list1 = modelIn.getQuads(stateIn, null, rand);
        if (!list1.isEmpty()) {
            if (renderenv == null) {
                renderenv = RenderEnv.getInstance(worldIn, stateIn, posIn);
            }
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, list1, renderenv);
            flag = true;
        }
        if (renderenv != null && Config.isBetterSnow() && !renderenv.isBreakingAnimation() && BetterSnow.shouldRender(worldIn, stateIn, posIn)) {
            IBakedModel ibakedmodel = BetterSnow.getModelSnowLayer();
            IBlockState iblockstate = BetterSnow.getStateSnowLayer();
            this.renderModelFlat(worldIn, ibakedmodel, iblockstate, posIn, buffer, true, rand);
        }
        return flag;
    }

    private void renderQuadsSmooth(IBlockAccess p_renderQuadsSmooth_1_, IBlockState p_renderQuadsSmooth_2_, BlockPos p_renderQuadsSmooth_3_, VertexBuffer p_renderQuadsSmooth_4_, List<BakedQuad> p_renderQuadsSmooth_5_, RenderEnv p_renderQuadsSmooth_6_) {
        float[] afloat = p_renderQuadsSmooth_6_.getQuadBounds();
        BitSet bitset = p_renderQuadsSmooth_6_.getBoundsFlags();
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = p_renderQuadsSmooth_6_.getAoFace();
        double d0 = p_renderQuadsSmooth_3_.getX();
        double d1 = p_renderQuadsSmooth_3_.getY();
        double d2 = p_renderQuadsSmooth_3_.getZ();
        Block block = p_renderQuadsSmooth_2_.getBlock();
        Block.EnumOffsetType block$enumoffsettype = block.getOffsetType();
        if (block$enumoffsettype != Block.EnumOffsetType.NONE) {
            long i = MathHelper.getPositionRandom(p_renderQuadsSmooth_3_);
            d0 += ((double)((float)(i >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d2 += ((double)((float)(i >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (block$enumoffsettype == Block.EnumOffsetType.XYZ) {
                d1 += ((double)((float)(i >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        int l = 0;
        int j = p_renderQuadsSmooth_5_.size();
        while (l < j) {
            BakedQuad bakedquad = p_renderQuadsSmooth_5_.get(l);
            if (!p_renderQuadsSmooth_6_.isBreakingAnimation(bakedquad)) {
                BakedQuad bakedquad1 = bakedquad;
                if (Config.isConnectedTextures()) {
                    bakedquad = ConnectedTextures.getConnectedTexture(p_renderQuadsSmooth_1_, p_renderQuadsSmooth_2_, p_renderQuadsSmooth_3_, bakedquad, p_renderQuadsSmooth_6_);
                }
                if (bakedquad == bakedquad1 && Config.isNaturalTextures()) {
                    bakedquad = NaturalTextures.getNaturalTexture(p_renderQuadsSmooth_3_, bakedquad);
                }
            }
            this.fillQuadBounds(p_renderQuadsSmooth_2_, bakedquad.getVertexData(), bakedquad.getFace(), afloat, bitset);
            blockmodelrenderer$ambientocclusionface.updateVertexBrightness(p_renderQuadsSmooth_1_, p_renderQuadsSmooth_2_, p_renderQuadsSmooth_3_, bakedquad.getFace(), afloat, bitset);
            if (p_renderQuadsSmooth_4_.isMultiTexture()) {
                p_renderQuadsSmooth_4_.addVertexData(bakedquad.getVertexDataSingle());
                p_renderQuadsSmooth_4_.putSprite(bakedquad.getSprite());
            } else {
                p_renderQuadsSmooth_4_.addVertexData(bakedquad.getVertexData());
            }
            p_renderQuadsSmooth_4_.putBrightness4(blockmodelrenderer$ambientocclusionface.vertexBrightness[0], blockmodelrenderer$ambientocclusionface.vertexBrightness[1], blockmodelrenderer$ambientocclusionface.vertexBrightness[2], blockmodelrenderer$ambientocclusionface.vertexBrightness[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float f3 = FaceBakery.getFaceBrightness(bakedquad.getFace());
                float[] afloat1 = blockmodelrenderer$ambientocclusionface.vertexColorMultiplier;
                afloat1[0] = afloat1[0] * f3;
                afloat1 = blockmodelrenderer$ambientocclusionface.vertexColorMultiplier;
                afloat1[1] = afloat1[1] * f3;
                afloat1 = blockmodelrenderer$ambientocclusionface.vertexColorMultiplier;
                afloat1[2] = afloat1[2] * f3;
                afloat1 = blockmodelrenderer$ambientocclusionface.vertexColorMultiplier;
                afloat1[3] = afloat1[3] * f3;
            }
            int i1 = CustomColors.getColorMultiplier(bakedquad, p_renderQuadsSmooth_2_, p_renderQuadsSmooth_1_, p_renderQuadsSmooth_3_, p_renderQuadsSmooth_6_);
            if (!bakedquad.hasTintIndex() && i1 == -1) {
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[0], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[0], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[0], 4);
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[1], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[1], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[1], 3);
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[2], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[2], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[2], 2);
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[3], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[3], blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[3], 1);
            } else {
                int k = i1 != -1 ? i1 : this.blockColors.colorMultiplier(p_renderQuadsSmooth_2_, p_renderQuadsSmooth_1_, p_renderQuadsSmooth_3_, bakedquad.getTintIndex());
                if (EntityRenderer.anaglyphEnable) {
                    k = TextureUtil.anaglyphColor(k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[0] * f, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[0] * f1, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[0] * f2, 4);
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[1] * f, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[1] * f1, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[1] * f2, 3);
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[2] * f, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[2] * f1, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[2] * f2, 2);
                p_renderQuadsSmooth_4_.putColorMultiplier(blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[3] * f, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[3] * f1, blockmodelrenderer$ambientocclusionface.vertexColorMultiplier[3] * f2, 1);
            }
            p_renderQuadsSmooth_4_.putPosition(d0, d1, d2);
            ++l;
        }
    }

    private void fillQuadBounds(IBlockState state, int[] p_187494_2_, EnumFacing p_187494_3_, float[] p_187494_4_, BitSet p_187494_5_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int i = p_187494_2_.length / 4;
        int j = 0;
        while (j < 4) {
            float f6 = Float.intBitsToFloat(p_187494_2_[j * i]);
            float f7 = Float.intBitsToFloat(p_187494_2_[j * i + 1]);
            float f8 = Float.intBitsToFloat(p_187494_2_[j * i + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
            ++j;
        }
        if (p_187494_4_ != null) {
            p_187494_4_[EnumFacing.WEST.getIndex()] = f;
            p_187494_4_[EnumFacing.EAST.getIndex()] = f3;
            p_187494_4_[EnumFacing.DOWN.getIndex()] = f1;
            p_187494_4_[EnumFacing.UP.getIndex()] = f4;
            p_187494_4_[EnumFacing.NORTH.getIndex()] = f2;
            p_187494_4_[EnumFacing.SOUTH.getIndex()] = f5;
            int k = EnumFacing.VALUES.length;
            p_187494_4_[EnumFacing.WEST.getIndex() + k] = 1.0f - f;
            p_187494_4_[EnumFacing.EAST.getIndex() + k] = 1.0f - f3;
            p_187494_4_[EnumFacing.DOWN.getIndex() + k] = 1.0f - f1;
            p_187494_4_[EnumFacing.UP.getIndex() + k] = 1.0f - f4;
            p_187494_4_[EnumFacing.NORTH.getIndex() + k] = 1.0f - f2;
            p_187494_4_[EnumFacing.SOUTH.getIndex() + k] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_187494_3_) {
            case DOWN: {
                p_187494_5_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f1 < 1.0E-4f || state.isFullCube()) && f1 == f4);
                break;
            }
            case UP: {
                p_187494_5_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f4 > 0.9999f || state.isFullCube()) && f1 == f4);
                break;
            }
            case NORTH: {
                p_187494_5_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_187494_5_.set(0, (f2 < 1.0E-4f || state.isFullCube()) && f2 == f5);
                break;
            }
            case SOUTH: {
                p_187494_5_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_187494_5_.set(0, (f5 > 0.9999f || state.isFullCube()) && f2 == f5);
                break;
            }
            case WEST: {
                p_187494_5_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f < 1.0E-4f || state.isFullCube()) && f == f3);
                break;
            }
            case EAST: {
                p_187494_5_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_187494_5_.set(0, (f3 > 0.9999f || state.isFullCube()) && f == f3);
            }
        }
    }

    private void renderQuadsFlat(IBlockAccess p_renderQuadsFlat_1_, IBlockState p_renderQuadsFlat_2_, BlockPos p_renderQuadsFlat_3_, int p_renderQuadsFlat_4_, boolean p_renderQuadsFlat_5_, VertexBuffer p_renderQuadsFlat_6_, List<BakedQuad> p_renderQuadsFlat_7_, RenderEnv p_renderQuadsFlat_8_) {
        BitSet bitset = p_renderQuadsFlat_8_.getBoundsFlags();
        double d0 = p_renderQuadsFlat_3_.getX();
        double d1 = p_renderQuadsFlat_3_.getY();
        double d2 = p_renderQuadsFlat_3_.getZ();
        Block block = p_renderQuadsFlat_2_.getBlock();
        Block.EnumOffsetType block$enumoffsettype = block.getOffsetType();
        if (block$enumoffsettype != Block.EnumOffsetType.NONE) {
            int i = p_renderQuadsFlat_3_.getX();
            int j = p_renderQuadsFlat_3_.getZ();
            long k = (long)(i * 3129871) ^ (long)j * 116129781L;
            k = k * k * 42317861L + k * 11L;
            d0 += ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d2 += ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (block$enumoffsettype == Block.EnumOffsetType.XYZ) {
                d1 += ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        int i1 = 0;
        int j1 = p_renderQuadsFlat_7_.size();
        while (i1 < j1) {
            BakedQuad bakedquad1 = p_renderQuadsFlat_7_.get(i1);
            if (!p_renderQuadsFlat_8_.isBreakingAnimation(bakedquad1)) {
                BakedQuad bakedquad = bakedquad1;
                if (Config.isConnectedTextures()) {
                    bakedquad1 = ConnectedTextures.getConnectedTexture(p_renderQuadsFlat_1_, p_renderQuadsFlat_2_, p_renderQuadsFlat_3_, bakedquad1, p_renderQuadsFlat_8_);
                }
                if (bakedquad1 == bakedquad && Config.isNaturalTextures()) {
                    bakedquad1 = NaturalTextures.getNaturalTexture(p_renderQuadsFlat_3_, bakedquad1);
                }
            }
            if (p_renderQuadsFlat_5_) {
                this.fillQuadBounds(p_renderQuadsFlat_2_, bakedquad1.getVertexData(), bakedquad1.getFace(), null, bitset);
                int n = p_renderQuadsFlat_4_ = bitset.get(0) ? p_renderQuadsFlat_2_.getPackedLightmapCoords(p_renderQuadsFlat_1_, p_renderQuadsFlat_3_.offset(bakedquad1.getFace())) : p_renderQuadsFlat_2_.getPackedLightmapCoords(p_renderQuadsFlat_1_, p_renderQuadsFlat_3_);
            }
            if (p_renderQuadsFlat_6_.isMultiTexture()) {
                p_renderQuadsFlat_6_.addVertexData(bakedquad1.getVertexDataSingle());
                p_renderQuadsFlat_6_.putSprite(bakedquad1.getSprite());
            } else {
                p_renderQuadsFlat_6_.addVertexData(bakedquad1.getVertexData());
            }
            p_renderQuadsFlat_6_.putBrightness4(p_renderQuadsFlat_4_, p_renderQuadsFlat_4_, p_renderQuadsFlat_4_, p_renderQuadsFlat_4_);
            int k1 = CustomColors.getColorMultiplier(bakedquad1, p_renderQuadsFlat_2_, p_renderQuadsFlat_1_, p_renderQuadsFlat_3_, p_renderQuadsFlat_8_);
            if (!bakedquad1.hasTintIndex() && k1 == -1) {
                if (bakedquad1.shouldApplyDiffuseLighting()) {
                    float f4 = FaceBakery.getFaceBrightness(bakedquad1.getFace());
                    p_renderQuadsFlat_6_.putColorMultiplier(f4, f4, f4, 4);
                    p_renderQuadsFlat_6_.putColorMultiplier(f4, f4, f4, 3);
                    p_renderQuadsFlat_6_.putColorMultiplier(f4, f4, f4, 2);
                    p_renderQuadsFlat_6_.putColorMultiplier(f4, f4, f4, 1);
                }
            } else {
                int l = k1 != -1 ? k1 : this.blockColors.colorMultiplier(p_renderQuadsFlat_2_, p_renderQuadsFlat_1_, p_renderQuadsFlat_3_, bakedquad1.getTintIndex());
                if (EntityRenderer.anaglyphEnable) {
                    l = TextureUtil.anaglyphColor(l);
                }
                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(l & 0xFF) / 255.0f;
                if (bakedquad1.shouldApplyDiffuseLighting()) {
                    float f3 = FaceBakery.getFaceBrightness(bakedquad1.getFace());
                    f *= f3;
                    f1 *= f3;
                    f2 *= f3;
                }
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 4);
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 3);
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 2);
                p_renderQuadsFlat_6_.putColorMultiplier(f, f1, f2, 1);
            }
            p_renderQuadsFlat_6_.putPosition(d0, d1, d2);
            ++i1;
        }
    }

    public void renderModelBrightnessColor(IBakedModel bakedModel, float p_178262_2_, float red, float green, float blue) {
        this.renderModelBrightnessColor(null, bakedModel, p_178262_2_, red, green, blue);
    }

    public void renderModelBrightnessColor(IBlockState state, IBakedModel p_187495_2_, float p_187495_3_, float p_187495_4_, float p_187495_5_, float p_187495_6_) {
        EnumFacing[] enumFacingArray = EnumFacing.VALUES;
        int n = EnumFacing.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            EnumFacing enumfacing = enumFacingArray[n2];
            this.renderModelBrightnessColorQuads(p_187495_3_, p_187495_4_, p_187495_5_, p_187495_6_, p_187495_2_.getQuads(state, enumfacing, 0L));
            ++n2;
        }
        this.renderModelBrightnessColorQuads(p_187495_3_, p_187495_4_, p_187495_5_, p_187495_6_, p_187495_2_.getQuads(state, null, 0L));
    }

    public void renderModelBrightness(IBakedModel model, IBlockState state, float brightness, boolean p_178266_4_) {
        Block block = state.getBlock();
        GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        int i = this.blockColors.colorMultiplier(state, null, null, 0);
        if (EntityRenderer.anaglyphEnable) {
            i = TextureUtil.anaglyphColor(i);
        }
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!p_178266_4_) {
            GlStateManager.color(brightness, brightness, brightness, 1.0f);
        }
        this.renderModelBrightnessColor(state, model, brightness, f, f1, f2);
    }

    private void renderModelBrightnessColorQuads(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexbuffer = tessellator.getBuffer();
        int i = 0;
        int j = listQuads.size();
        while (i < j) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.begin(7, DefaultVertexFormats.ITEM);
            vertexbuffer.addVertexData(bakedquad.getVertexData());
            if (bakedquad.hasTintIndex()) {
                vertexbuffer.putColorRGB_F4(red * brightness, green * brightness, blue * brightness);
            } else {
                vertexbuffer.putColorRGB_F4(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.getFace().getDirectionVec();
            vertexbuffer.putNormal(vec3i.getX(), vec3i.getY(), vec3i.getZ());
            tessellator.draw();
            ++i;
        }
    }

    public static float fixAoLightValue(float p_fixAoLightValue_0_) {
        return p_fixAoLightValue_0_ == 0.2f ? aoLightValueOpaque : p_fixAoLightValue_0_;
    }

    public static class AmbientOcclusionFace {
        private final float[] vertexColorMultiplier = new float[4];
        private final int[] vertexBrightness = new int[4];

        public AmbientOcclusionFace() {
        }

        public AmbientOcclusionFace(BlockModelRenderer p_i46235_1_) {
        }

        public void updateVertexBrightness(IBlockAccess worldIn, IBlockState state, BlockPos centerPos, EnumFacing direction, float[] faceShape, BitSet shapeState) {
            int l1;
            float f28;
            int k1;
            float f27;
            int j1;
            float f26;
            int i1;
            float f4;
            BlockPos blockpos = shapeState.get(0) ? centerPos.offset(direction) : centerPos;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
            EnumNeighborInfo blockmodelrenderer$enumneighborinfo = EnumNeighborInfo.getNeighbourInfo(direction);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[0]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[1]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos3 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[2]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos4 = BlockPos.PooledMutableBlockPos.retain(blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[3]);
            int i = state.getPackedLightmapCoords(worldIn, blockpos$pooledmutableblockpos1);
            int j = state.getPackedLightmapCoords(worldIn, blockpos$pooledmutableblockpos2);
            int k = state.getPackedLightmapCoords(worldIn, blockpos$pooledmutableblockpos3);
            int l = state.getPackedLightmapCoords(worldIn, blockpos$pooledmutableblockpos4);
            float f = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos$pooledmutableblockpos1).getAmbientOcclusionLightValue());
            float f1 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos$pooledmutableblockpos2).getAmbientOcclusionLightValue());
            float f2 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos$pooledmutableblockpos3).getAmbientOcclusionLightValue());
            float f3 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos$pooledmutableblockpos4).getAmbientOcclusionLightValue());
            boolean flag = worldIn.getBlockState(blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos1).func_189536_c(direction)).isTranslucent();
            boolean flag1 = worldIn.getBlockState(blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos2).func_189536_c(direction)).isTranslucent();
            boolean flag2 = worldIn.getBlockState(blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos3).func_189536_c(direction)).isTranslucent();
            boolean flag3 = worldIn.getBlockState(blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos4).func_189536_c(direction)).isTranslucent();
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos1 = blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos1).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[2]);
                f4 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos1).getAmbientOcclusionLightValue());
                i1 = state.getPackedLightmapCoords(worldIn, blockpos1);
            }
            if (!flag3 && !flag) {
                f26 = f;
                j1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos2 = blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos1).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[3]);
                f26 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos2).getAmbientOcclusionLightValue());
                j1 = state.getPackedLightmapCoords(worldIn, blockpos2);
            }
            if (!flag2 && !flag1) {
                f27 = f1;
                k1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos3 = blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos2).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[2]);
                f27 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos3).getAmbientOcclusionLightValue());
                k1 = state.getPackedLightmapCoords(worldIn, blockpos3);
            }
            if (!flag3 && !flag1) {
                f28 = f1;
                l1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos4 = blockpos$pooledmutableblockpos.func_189533_g(blockpos$pooledmutableblockpos2).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[3]);
                f28 = BlockModelRenderer.fixAoLightValue(worldIn.getBlockState(blockpos4).getAmbientOcclusionLightValue());
                l1 = state.getPackedLightmapCoords(worldIn, blockpos4);
            }
            int i3 = state.getPackedLightmapCoords(worldIn, centerPos);
            if (shapeState.get(0) || !worldIn.getBlockState(centerPos.offset(direction)).isOpaqueCube()) {
                i3 = state.getPackedLightmapCoords(worldIn, centerPos.offset(direction));
            }
            float f5 = shapeState.get(0) ? worldIn.getBlockState(blockpos).getAmbientOcclusionLightValue() : worldIn.getBlockState(centerPos).getAmbientOcclusionLightValue();
            f5 = BlockModelRenderer.fixAoLightValue(f5);
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.getVertexTranslations(direction);
            blockpos$pooledmutableblockpos.release();
            blockpos$pooledmutableblockpos1.release();
            blockpos$pooledmutableblockpos2.release();
            blockpos$pooledmutableblockpos3.release();
            blockpos$pooledmutableblockpos4.release();
            if (shapeState.get(1) && blockmodelrenderer$enumneighborinfo.doNonCubicWeight) {
                float f29 = (f3 + f + f26 + f5) * 0.25f;
                float f30 = (f2 + f + f4 + f5) * 0.25f;
                float f31 = (f2 + f1 + f27 + f5) * 0.25f;
                float f32 = (f3 + f1 + f28 + f5) * 0.25f;
                float f10 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[1].shape];
                float f11 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[3].shape];
                float f12 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[5].shape];
                float f13 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[7].shape];
                float f14 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[1].shape];
                float f15 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[3].shape];
                float f16 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[5].shape];
                float f17 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[7].shape];
                float f18 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[1].shape];
                float f19 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[3].shape];
                float f20 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[5].shape];
                float f21 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[7].shape];
                float f22 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[1].shape];
                float f23 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[3].shape];
                float f24 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[5].shape];
                float f25 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[7].shape];
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = f29 * f10 + f30 * f11 + f31 * f12 + f32 * f13;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = f29 * f14 + f30 * f15 + f31 * f16 + f32 * f17;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = f29 * f18 + f30 * f19 + f31 * f20 + f32 * f21;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = f29 * f22 + f30 * f23 + f31 * f24 + f32 * f25;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = this.getVertexBrightness(i2, j2, k2, l2, f10, f11, f12, f13);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = this.getVertexBrightness(i2, j2, k2, l2, f14, f15, f16, f17);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = this.getVertexBrightness(i2, j2, k2, l2, f18, f19, f20, f21);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = this.getVertexBrightness(i2, j2, k2, l2, f22, f23, f24, f25);
            } else {
                float f6 = (f3 + f + f26 + f5) * 0.25f;
                float f7 = (f2 + f + f4 + f5) * 0.25f;
                float f8 = (f2 + f1 + f27 + f5) * 0.25f;
                float f9 = (f3 + f1 + f28 + f5) * 0.25f;
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = f6;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = f7;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = f8;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = f9;
            }
        }

        private int getAoBrightness(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int getVertexBrightness(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }

    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final EnumFacing[] corners;
        private final float shadeWeight;
        private final boolean doNonCubicWeight;
        private final Orientation[] vert0Weights;
        private final Orientation[] vert1Weights;
        private final Orientation[] vert2Weights;
        private final Orientation[] vert3Weights;
        private static final EnumNeighborInfo[] VALUES;

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[EnumFacing.DOWN.getIndex()] = DOWN;
            EnumNeighborInfo.VALUES[EnumFacing.UP.getIndex()] = UP;
            EnumNeighborInfo.VALUES[EnumFacing.NORTH.getIndex()] = NORTH;
            EnumNeighborInfo.VALUES[EnumFacing.SOUTH.getIndex()] = SOUTH;
            EnumNeighborInfo.VALUES[EnumFacing.WEST.getIndex()] = WEST;
            EnumNeighborInfo.VALUES[EnumFacing.EAST.getIndex()] = EAST;
        }

        private EnumNeighborInfo(EnumFacing[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.corners = p_i46236_3_;
            this.shadeWeight = p_i46236_4_;
            this.doNonCubicWeight = p_i46236_5_;
            this.vert0Weights = p_i46236_6_;
            this.vert1Weights = p_i46236_7_;
            this.vert2Weights = p_i46236_8_;
            this.vert3Weights = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(EnumFacing p_178273_0_) {
            return VALUES[p_178273_0_.getIndex()];
        }
    }

    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        private final int shape;

        private Orientation(EnumFacing p_i46233_3_, boolean p_i46233_4_) {
            this.shape = p_i46233_3_.getIndex() + (p_i46233_4_ ? EnumFacing.values().length : 0);
        }
    }

    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int vert0;
        private final int vert1;
        private final int vert2;
        private final int vert3;
        private static final VertexTranslations[] VALUES;

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[EnumFacing.DOWN.getIndex()] = DOWN;
            VertexTranslations.VALUES[EnumFacing.UP.getIndex()] = UP;
            VertexTranslations.VALUES[EnumFacing.NORTH.getIndex()] = NORTH;
            VertexTranslations.VALUES[EnumFacing.SOUTH.getIndex()] = SOUTH;
            VertexTranslations.VALUES[EnumFacing.WEST.getIndex()] = WEST;
            VertexTranslations.VALUES[EnumFacing.EAST.getIndex()] = EAST;
        }

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.vert0 = p_i46234_3_;
            this.vert1 = p_i46234_4_;
            this.vert2 = p_i46234_5_;
            this.vert3 = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(EnumFacing p_178184_0_) {
            return VALUES[p_178184_0_.getIndex()];
        }
    }
}

