/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BakedQuadRetextured
extends BakedQuad {
    private final TextureAtlasSprite texture;
    private final TextureAtlasSprite spriteOld;

    public BakedQuadRetextured(BakedQuad quad, TextureAtlasSprite textureIn) {
        super(Arrays.copyOf(quad.getVertexData(), quad.getVertexData().length), quad.tintIndex, FaceBakery.getFacingFromVertexData(quad.getVertexData()), textureIn);
        this.texture = textureIn;
        this.format = quad.format;
        this.applyDiffuseLighting = quad.applyDiffuseLighting;
        this.spriteOld = quad.getSprite();
        this.remapQuad();
        this.fixVertexData();
    }

    private void remapQuad() {
        int i = 0;
        while (i < 4) {
            int j = this.format.getIntegerSize() * i;
            int k = this.format.getUvOffsetById(0) / 4;
            this.vertexData[j + k] = Float.floatToRawIntBits(this.texture.getInterpolatedU(this.spriteOld.getUnInterpolatedU(Float.intBitsToFloat(this.vertexData[j + k]))));
            this.vertexData[j + k + 1] = Float.floatToRawIntBits(this.texture.getInterpolatedV(this.spriteOld.getUnInterpolatedV(Float.intBitsToFloat(this.vertexData[j + k + 1]))));
            ++i;
        }
    }
}

