/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class TileEntityEndGatewayRenderer
extends TileEntitySpecialRenderer<TileEntityEndGateway> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final ResourceLocation END_GATEWAY_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.createDirectFloatBuffer(16);
    private static final FloatBuffer PROJECTION = GLAllocation.createDirectFloatBuffer(16);
    FloatBuffer buffer = GLAllocation.createDirectFloatBuffer(16);

    @Override
    public void renderTileEntityAt(TileEntityEndGateway te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.disableFog();
        if (te.isSpawning() || te.isCoolingDown()) {
            GlStateManager.alphaFunc(516, 0.1f);
            this.bindTexture(END_GATEWAY_BEAM_TEXTURE);
            float f = te.isSpawning() ? te.getSpawnPercent() : te.getCooldownPercent();
            double d0 = te.isSpawning() ? 256.0 - y : 25.0;
            f = MathHelper.sin(f * (float)Math.PI);
            int j = MathHelper.floor_double((double)f * d0);
            float[] afloat = EntitySheep.getDyeRgb(te.isSpawning() ? EnumDyeColor.MAGENTA : EnumDyeColor.YELLOW);
            TileEntityBeaconRenderer.renderBeamSegment(x, y, z, partialTicks, f, te.getWorld().getTotalWorldTime(), 0, j, afloat, 0.15, 0.175);
            TileEntityBeaconRenderer.renderBeamSegment(x, y, z, partialTicks, f, te.getWorld().getTotalWorldTime(), 0, -j, afloat, 0.15, 0.175);
        }
        GlStateManager.disableLighting();
        RANDOM.setSeed(31100L);
        GlStateManager.getFloat(2982, MODELVIEW);
        GlStateManager.getFloat(2983, PROJECTION);
        double d1 = x * x + y * y + z * z;
        int i = d1 > 36864.0 ? 2 : (d1 > 25600.0 ? 4 : (d1 > 16384.0 ? 6 : (d1 > 9216.0 ? 8 : (d1 > 4096.0 ? 10 : (d1 > 1024.0 ? 12 : (d1 > 576.0 ? 14 : (d1 > 256.0 ? 15 : 16)))))));
        int k = 0;
        while (k < i) {
            GlStateManager.pushMatrix();
            float f5 = 2.0f / (float)(18 - k);
            if (k == 0) {
                this.bindTexture(END_SKY_TEXTURE);
                f5 = 0.15f;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (k >= 1) {
                this.bindTexture(END_PORTAL_TEXTURE);
            }
            if (k == 1) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
            }
            GlStateManager.texGen(GlStateManager.TexGen.S, 9216);
            GlStateManager.texGen(GlStateManager.TexGen.T, 9216);
            GlStateManager.texGen(GlStateManager.TexGen.R, 9216);
            GlStateManager.texGen(GlStateManager.TexGen.S, 9474, this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGen(GlStateManager.TexGen.T, 9474, this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.texGen(GlStateManager.TexGen.R, 9474, this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.enableTexGenCoord(GlStateManager.TexGen.S);
            GlStateManager.enableTexGenCoord(GlStateManager.TexGen.T);
            GlStateManager.enableTexGenCoord(GlStateManager.TexGen.R);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translate(0.5f, 0.5f, 0.0f);
            GlStateManager.scale(0.5f, 0.5f, 1.0f);
            float f1 = k + 1;
            GlStateManager.translate(17.0f / f1, (2.0f + f1 / 1.5f) * ((float)Minecraft.getSystemTime() % 800000.0f / 800000.0f), 0.0f);
            GlStateManager.rotate((f1 * f1 * 4321.0f + f1 * 9.0f) * 2.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.scale(4.5f - f1 / 4.0f, 4.5f - f1 / 4.0f, 1.0f);
            GlStateManager.multMatrix(PROJECTION);
            GlStateManager.multMatrix(MODELVIEW);
            Tessellator tessellator = Tessellator.getInstance();
            VertexBuffer vertexbuffer = tessellator.getBuffer();
            vertexbuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
            float f2 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f5;
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f5;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f5;
            if (te.shouldRenderFace(EnumFacing.SOUTH)) {
                vertexbuffer.pos(x, y, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y + 1.0, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y + 1.0, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
            }
            if (te.shouldRenderFace(EnumFacing.NORTH)) {
                vertexbuffer.pos(x, y + 1.0, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y + 1.0, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y, z).color(f2, f3, f4, 1.0f).endVertex();
            }
            if (te.shouldRenderFace(EnumFacing.EAST)) {
                vertexbuffer.pos(x + 1.0, y + 1.0, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y + 1.0, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y, z).color(f2, f3, f4, 1.0f).endVertex();
            }
            if (te.shouldRenderFace(EnumFacing.WEST)) {
                vertexbuffer.pos(x, y, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y + 1.0, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y + 1.0, z).color(f2, f3, f4, 1.0f).endVertex();
            }
            if (te.shouldRenderFace(EnumFacing.DOWN)) {
                vertexbuffer.pos(x, y, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
            }
            if (te.shouldRenderFace(EnumFacing.UP)) {
                vertexbuffer.pos(x, y + 1.0, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y + 1.0, z + 1.0).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x + 1.0, y + 1.0, z).color(f2, f3, f4, 1.0f).endVertex();
                vertexbuffer.pos(x, y + 1.0, z).color(f2, f3, f4, 1.0f).endVertex();
            }
            tessellator.draw();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
            this.bindTexture(END_SKY_TEXTURE);
            ++k;
        }
        GlStateManager.disableBlend();
        GlStateManager.disableTexGenCoord(GlStateManager.TexGen.S);
        GlStateManager.disableTexGenCoord(GlStateManager.TexGen.T);
        GlStateManager.disableTexGenCoord(GlStateManager.TexGen.R);
        GlStateManager.enableLighting();
        GlStateManager.enableFog();
    }

    private FloatBuffer getBuffer(float p_188193_1_, float p_188193_2_, float p_188193_3_, float p_188193_4_) {
        this.buffer.clear();
        this.buffer.put(p_188193_1_).put(p_188193_2_).put(p_188193_3_).put(p_188193_4_);
        this.buffer.flip();
        return this.buffer;
    }

    @Override
    public boolean isGlobalRenderer(TileEntityEndGateway te) {
        return te.isSpawning() || te.isCoolingDown();
    }
}

