/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandListener;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class CommandBase
implements ICommand {
    private static ICommandListener commandListener;

    protected static SyntaxErrorException toSyntaxException(JsonParseException e) {
        Throwable throwable = ExceptionUtils.getRootCause((Throwable)e);
        String s = "";
        if (throwable != null && (s = throwable.getMessage()).contains("setLenient")) {
            s = s.substring(s.indexOf("to accept ") + 10);
        }
        return new SyntaxErrorException("commands.tellraw.jsonException", s);
    }

    protected static NBTTagCompound entityToNBT(Entity theEntity) {
        ItemStack itemstack;
        NBTTagCompound nbttagcompound = theEntity.func_189511_e(new NBTTagCompound());
        if (theEntity instanceof EntityPlayer && (itemstack = ((EntityPlayer)theEntity).inventory.getCurrentItem()) != null && itemstack.getItem() != null) {
            nbttagcompound.setTag("SelectedItem", itemstack.writeToNBT(new NBTTagCompound()));
        }
        return nbttagcompound;
    }

    public int getRequiredPermissionLevel() {
        return 4;
    }

    @Override
    public List<String> getCommandAliases() {
        return Collections.emptyList();
    }

    @Override
    public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
        return sender.canCommandSenderUseCommand(this.getRequiredPermissionLevel(), this.getCommandName());
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    public static int parseInt(String input) throws NumberInvalidException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException var2) {
            throw new NumberInvalidException("commands.generic.num.invalid", input);
        }
    }

    public static int parseInt(String input, int min) throws NumberInvalidException {
        return CommandBase.parseInt(input, min, Integer.MAX_VALUE);
    }

    public static int parseInt(String input, int min, int max) throws NumberInvalidException {
        int i = CommandBase.parseInt(input);
        if (i < min) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", i, min);
        }
        if (i > max) {
            throw new NumberInvalidException("commands.generic.num.tooBig", i, max);
        }
        return i;
    }

    public static long parseLong(String input) throws NumberInvalidException {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException var2) {
            throw new NumberInvalidException("commands.generic.num.invalid", input);
        }
    }

    public static long parseLong(String input, long min, long max) throws NumberInvalidException {
        long i = CommandBase.parseLong(input);
        if (i < min) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", i, min);
        }
        if (i > max) {
            throw new NumberInvalidException("commands.generic.num.tooBig", i, max);
        }
        return i;
    }

    public static BlockPos parseBlockPos(ICommandSender sender, String[] args, int startIndex, boolean centerBlock) throws NumberInvalidException {
        BlockPos blockpos = sender.getPosition();
        return new BlockPos(CommandBase.parseDouble(blockpos.getX(), args[startIndex], -30000000, 30000000, centerBlock), CommandBase.parseDouble(blockpos.getY(), args[startIndex + 1], 0, 256, false), CommandBase.parseDouble(blockpos.getZ(), args[startIndex + 2], -30000000, 30000000, centerBlock));
    }

    public static double parseDouble(String input) throws NumberInvalidException {
        try {
            double d0 = Double.parseDouble(input);
            if (!Doubles.isFinite((double)d0)) {
                throw new NumberInvalidException("commands.generic.num.invalid", input);
            }
            return d0;
        }
        catch (NumberFormatException var3) {
            throw new NumberInvalidException("commands.generic.num.invalid", input);
        }
    }

    public static double parseDouble(String input, double min) throws NumberInvalidException {
        return CommandBase.parseDouble(input, min, Double.MAX_VALUE);
    }

    public static double parseDouble(String input, double min, double max) throws NumberInvalidException {
        double d0 = CommandBase.parseDouble(input);
        if (d0 < min) {
            throw new NumberInvalidException("commands.generic.double.tooSmall", d0, min);
        }
        if (d0 > max) {
            throw new NumberInvalidException("commands.generic.double.tooBig", d0, max);
        }
        return d0;
    }

    public static boolean parseBoolean(String input) throws CommandException {
        if (!"true".equals(input) && !"1".equals(input)) {
            if (!"false".equals(input) && !"0".equals(input)) {
                throw new CommandException("commands.generic.boolean.invalid", input);
            }
            return false;
        }
        return true;
    }

    public static EntityPlayerMP getCommandSenderAsPlayer(ICommandSender sender) throws PlayerNotFoundException {
        if (sender instanceof EntityPlayerMP) {
            return (EntityPlayerMP)sender;
        }
        throw new PlayerNotFoundException("You must specify which player you wish to perform this action on.", new Object[0]);
    }

    public static EntityPlayerMP getPlayer(MinecraftServer server, ICommandSender sender, String target) throws PlayerNotFoundException {
        EntityPlayerMP entityplayermp = EntitySelector.matchOnePlayer(sender, target);
        if (entityplayermp == null) {
            try {
                entityplayermp = server.getPlayerList().getPlayerByUUID(UUID.fromString(target));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (entityplayermp == null) {
            entityplayermp = server.getPlayerList().getPlayerByUsername(target);
        }
        if (entityplayermp == null) {
            throw new PlayerNotFoundException();
        }
        return entityplayermp;
    }

    public static Entity getEntity(MinecraftServer server, ICommandSender sender, String target) throws EntityNotFoundException {
        return CommandBase.getEntity(server, sender, target, Entity.class);
    }

    public static <T extends Entity> T getEntity(MinecraftServer server, ICommandSender sender, String target, Class<? extends T> targetClass) throws EntityNotFoundException {
        Object entity = EntitySelector.matchOneEntity(sender, target, targetClass);
        if (entity == null) {
            entity = server.getPlayerList().getPlayerByUsername(target);
        }
        if (entity == null) {
            try {
                UUID uuid = UUID.fromString(target);
                entity = server.getEntityFromUuid(uuid);
                if (entity == null) {
                    entity = server.getPlayerList().getPlayerByUUID(uuid);
                }
            }
            catch (IllegalArgumentException var6) {
                throw new EntityNotFoundException("commands.generic.entity.invalidUuid", new Object[0]);
            }
        }
        if (entity != null && targetClass.isAssignableFrom(entity.getClass())) {
            return entity;
        }
        throw new EntityNotFoundException();
    }

    public static List<Entity> getEntityList(MinecraftServer server, ICommandSender sender, String target) throws EntityNotFoundException {
        return EntitySelector.hasArguments(target) ? EntitySelector.matchEntities(sender, target, Entity.class) : Lists.newArrayList((Object[])new Entity[]{CommandBase.getEntity(server, sender, target)});
    }

    public static String getPlayerName(MinecraftServer server, ICommandSender sender, String target) throws PlayerNotFoundException {
        try {
            return CommandBase.getPlayer(server, sender, target).getName();
        }
        catch (PlayerNotFoundException playernotfoundexception) {
            if (target != null && !target.startsWith("@")) {
                return target;
            }
            throw playernotfoundexception;
        }
    }

    public static String getEntityName(MinecraftServer server, ICommandSender sender, String target) throws EntityNotFoundException {
        try {
            return CommandBase.getPlayer(server, sender, target).getName();
        }
        catch (PlayerNotFoundException var6) {
            try {
                return CommandBase.getEntity(server, sender, target).func_189512_bd();
            }
            catch (EntityNotFoundException entitynotfoundexception) {
                if (target != null && !target.startsWith("@")) {
                    return target;
                }
                throw entitynotfoundexception;
            }
        }
    }

    public static ITextComponent getChatComponentFromNthArg(ICommandSender sender, String[] args, int index) throws CommandException, PlayerNotFoundException {
        return CommandBase.getChatComponentFromNthArg(sender, args, index, false);
    }

    public static ITextComponent getChatComponentFromNthArg(ICommandSender sender, String[] args, int index, boolean p_147176_3_) throws PlayerNotFoundException {
        TextComponentString itextcomponent = new TextComponentString("");
        int i = index;
        while (i < args.length) {
            if (i > index) {
                itextcomponent.appendText(" ");
            }
            ITextComponent itextcomponent1 = new TextComponentString(args[i]);
            if (p_147176_3_) {
                ITextComponent itextcomponent2 = EntitySelector.matchEntitiesToTextComponent(sender, args[i]);
                if (itextcomponent2 == null) {
                    if (EntitySelector.hasArguments(args[i])) {
                        throw new PlayerNotFoundException();
                    }
                } else {
                    itextcomponent1 = itextcomponent2;
                }
            }
            itextcomponent.appendSibling(itextcomponent1);
            ++i;
        }
        return itextcomponent;
    }

    public static String buildString(String[] args, int startPos) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = startPos;
        while (i < args.length) {
            if (i > startPos) {
                stringbuilder.append(" ");
            }
            String s = args[i];
            stringbuilder.append(s);
            ++i;
        }
        return stringbuilder.toString();
    }

    public static CoordinateArg parseCoordinate(double base, String selectorArg, boolean centerBlock) throws NumberInvalidException {
        return CommandBase.parseCoordinate(base, selectorArg, -30000000, 30000000, centerBlock);
    }

    public static CoordinateArg parseCoordinate(double base, String selectorArg, int min, int max, boolean centerBlock) throws NumberInvalidException {
        boolean flag = selectorArg.startsWith("~");
        if (flag && Double.isNaN(base)) {
            throw new NumberInvalidException("commands.generic.num.invalid", base);
        }
        double d0 = 0.0;
        if (!flag || selectorArg.length() > 1) {
            boolean flag1 = selectorArg.contains(".");
            if (flag) {
                selectorArg = selectorArg.substring(1);
            }
            d0 += CommandBase.parseDouble(selectorArg);
            if (!flag1 && !flag && centerBlock) {
                d0 += 0.5;
            }
        }
        double d1 = d0 + (flag ? base : 0.0);
        if (min != 0 || max != 0) {
            if (d1 < (double)min) {
                throw new NumberInvalidException("commands.generic.double.tooSmall", d1, min);
            }
            if (d1 > (double)max) {
                throw new NumberInvalidException("commands.generic.double.tooBig", d1, max);
            }
        }
        return new CoordinateArg(d1, d0, flag);
    }

    public static double parseDouble(double base, String input, boolean centerBlock) throws NumberInvalidException {
        return CommandBase.parseDouble(base, input, -30000000, 30000000, centerBlock);
    }

    public static double parseDouble(double base, String input, int min, int max, boolean centerBlock) throws NumberInvalidException {
        double d0;
        boolean flag = input.startsWith("~");
        if (flag && Double.isNaN(base)) {
            throw new NumberInvalidException("commands.generic.num.invalid", base);
        }
        double d = d0 = flag ? base : 0.0;
        if (!flag || input.length() > 1) {
            boolean flag1 = input.contains(".");
            if (flag) {
                input = input.substring(1);
            }
            d0 += CommandBase.parseDouble(input);
            if (!flag1 && !flag && centerBlock) {
                d0 += 0.5;
            }
        }
        if (min != 0 || max != 0) {
            if (d0 < (double)min) {
                throw new NumberInvalidException("commands.generic.double.tooSmall", d0, min);
            }
            if (d0 > (double)max) {
                throw new NumberInvalidException("commands.generic.double.tooBig", d0, max);
            }
        }
        return d0;
    }

    public static Item getItemByText(ICommandSender sender, String id) throws NumberInvalidException {
        ResourceLocation resourcelocation = new ResourceLocation(id);
        Item item = Item.REGISTRY.getObject(resourcelocation);
        if (item == null) {
            throw new NumberInvalidException("commands.give.item.notFound", resourcelocation);
        }
        return item;
    }

    public static Block getBlockByText(ICommandSender sender, String id) throws NumberInvalidException {
        ResourceLocation resourcelocation = new ResourceLocation(id);
        if (!Block.REGISTRY.containsKey(resourcelocation)) {
            throw new NumberInvalidException("commands.give.block.notFound", resourcelocation);
        }
        Block block = Block.REGISTRY.getObject(resourcelocation);
        if (block == null) {
            throw new NumberInvalidException("commands.give.block.notFound", resourcelocation);
        }
        return block;
    }

    public static String joinNiceString(Object[] elements) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = 0;
        while (i < elements.length) {
            String s = elements[i].toString();
            if (i > 0) {
                if (i == elements.length - 1) {
                    stringbuilder.append(" and ");
                } else {
                    stringbuilder.append(", ");
                }
            }
            stringbuilder.append(s);
            ++i;
        }
        return stringbuilder.toString();
    }

    public static ITextComponent join(List<ITextComponent> components) {
        TextComponentString itextcomponent = new TextComponentString("");
        int i = 0;
        while (i < components.size()) {
            if (i > 0) {
                if (i == components.size() - 1) {
                    itextcomponent.appendText(" and ");
                } else if (i > 0) {
                    itextcomponent.appendText(", ");
                }
            }
            itextcomponent.appendSibling(components.get(i));
            ++i;
        }
        return itextcomponent;
    }

    public static String joinNiceStringFromCollection(Collection<String> strings) {
        return CommandBase.joinNiceString(strings.toArray(new String[strings.size()]));
    }

    public static List<String> getTabCompletionCoordinate(String[] inputArgs, int index, @Nullable BlockPos pos) {
        String s;
        if (pos == null) {
            return Lists.newArrayList((Object[])new String[]{"~"});
        }
        int i = inputArgs.length - 1;
        if (i == index) {
            s = Integer.toString(pos.getX());
        } else if (i == index + 1) {
            s = Integer.toString(pos.getY());
        } else {
            if (i != index + 2) {
                return Collections.emptyList();
            }
            s = Integer.toString(pos.getZ());
        }
        return Lists.newArrayList((Object[])new String[]{s});
    }

    @Nullable
    public static List<String> getTabCompletionCoordinateXZ(String[] inputArgs, int index, @Nullable BlockPos lookedPos) {
        String s;
        if (lookedPos == null) {
            return Lists.newArrayList((Object[])new String[]{"~"});
        }
        int i = inputArgs.length - 1;
        if (i == index) {
            s = Integer.toString(lookedPos.getX());
        } else {
            if (i != index + 1) {
                return null;
            }
            s = Integer.toString(lookedPos.getZ());
        }
        return Lists.newArrayList((Object[])new String[]{s});
    }

    public static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] args, String ... possibilities) {
        return CommandBase.getListOfStringsMatchingLastWord(args, Arrays.asList(possibilities));
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (String s1 : Iterables.transform(possibleCompletions, (Function)Functions.toStringFunction())) {
                if (!CommandBase.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
            if (list.isEmpty()) {
                for (Object object : possibleCompletions) {
                    if (!(object instanceof ResourceLocation) || !CommandBase.doesStringStartWith(s, ((ResourceLocation)object).getResourcePath())) continue;
                    list.add(String.valueOf(object));
                }
            }
        }
        return list;
    }

    @Override
    public boolean isUsernameIndex(String[] args, int index) {
        return false;
    }

    public static void notifyCommandListener(ICommandSender sender, ICommand command, String translationKey, Object ... translationArgs) {
        CommandBase.notifyCommandListener(sender, command, 0, translationKey, translationArgs);
    }

    public static void notifyCommandListener(ICommandSender sender, ICommand command, int flags, String translationKey, Object ... translationArgs) {
        if (commandListener != null) {
            commandListener.notifyListener(sender, command, flags, translationKey, translationArgs);
        }
    }

    public static void setCommandListener(ICommandListener listener) {
        commandListener = listener;
    }

    @Override
    public int compareTo(ICommand p_compareTo_1_) {
        return this.getCommandName().compareTo(p_compareTo_1_.getCommandName());
    }

    public static class CoordinateArg {
        private final double result;
        private final double amount;
        private final boolean isRelative;

        protected CoordinateArg(double resultIn, double amountIn, boolean relative) {
            this.result = resultIn;
            this.amount = amountIn;
            this.isRelative = relative;
        }

        public double getResult() {
            return this.result;
        }

        public double getAmount() {
            return this.amount;
        }

        public boolean isRelative() {
            return this.isRelative;
        }
    }
}

