/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIPanic
extends EntityAIBase {
    private final EntityCreature theEntityCreature;
    protected double speed;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public EntityAIPanic(EntityCreature creature, double speedIn) {
        this.theEntityCreature = creature;
        this.speed = speedIn;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (this.theEntityCreature.getAITarget() == null && !this.theEntityCreature.isBurning()) {
            return false;
        }
        if (!this.theEntityCreature.isBurning()) {
            Vec3d vec3d = RandomPositionGenerator.findRandomTarget(this.theEntityCreature, 5, 4);
            if (vec3d == null) {
                return false;
            }
            this.randPosX = vec3d.xCoord;
            this.randPosY = vec3d.yCoord;
            this.randPosZ = vec3d.zCoord;
            return true;
        }
        BlockPos blockpos = this.getRandPos(this.theEntityCreature.worldObj, this.theEntityCreature, 5, 4);
        if (blockpos == null) {
            return false;
        }
        this.randPosX = blockpos.getX();
        this.randPosY = blockpos.getY();
        this.randPosZ = blockpos.getZ();
        return true;
    }

    @Override
    public void startExecuting() {
        this.theEntityCreature.getNavigator().tryMoveToXYZ(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    @Override
    public boolean continueExecuting() {
        return !this.theEntityCreature.getNavigator().noPath();
    }

    private BlockPos getRandPos(World worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos blockpos = new BlockPos(entityIn);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = blockpos.getX();
        int j = blockpos.getY();
        int k = blockpos.getZ();
        float f = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos blockpos1 = null;
        int l = i - horizontalRange;
        while (l <= i + horizontalRange) {
            int i1 = j - verticalRange;
            while (i1 <= j + verticalRange) {
                int j1 = k - horizontalRange;
                while (j1 <= k + horizontalRange) {
                    float f1;
                    blockpos$mutableblockpos.set(l, i1, j1);
                    IBlockState iblockstate = worldIn.getBlockState(blockpos$mutableblockpos);
                    Block block = iblockstate.getBlock();
                    if ((block == Blocks.WATER || block == Blocks.FLOWING_WATER) && (f1 = (float)((l - i) * (l - i) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k))) < f) {
                        f = f1;
                        blockpos1 = new BlockPos(blockpos$mutableblockpos);
                    }
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
        return blockpos1;
    }
}

