/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityArmorStand
extends EntityLivingBase {
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    public static final DataParameter<Byte> STATUS = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.BYTE);
    public static final DataParameter<Rotations> HEAD_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> BODY_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> LEFT_ARM_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> RIGHT_ARM_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> LEFT_LEG_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    public static final DataParameter<Rotations> RIGHT_LEG_ROTATION = EntityDataManager.createKey(EntityArmorStand.class, DataSerializers.ROTATIONS);
    private static final Predicate<Entity> IS_RIDEABLE_MINECART = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityMinecart && ((EntityMinecart)p_apply_1_).getType() == EntityMinecart.Type.RIDEABLE;
        }
    };
    private final ItemStack[] handItems = new ItemStack[2];
    private final ItemStack[] armorItems = new ItemStack[4];
    private boolean canInteract;
    public long punchCooldown;
    private int disabledSlots;
    private boolean wasMarker;
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;

    public EntityArmorStand(World worldIn) {
        super(worldIn);
        this.noClip = this.func_189652_ae();
        this.setSize(0.5f, 1.975f);
    }

    public EntityArmorStand(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.setPosition(posX, posY, posZ);
    }

    @Override
    public boolean isServerWorld() {
        return super.isServerWorld() && !this.func_189652_ae();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(STATUS, (byte)0);
        this.dataManager.register(HEAD_ROTATION, DEFAULT_HEAD_ROTATION);
        this.dataManager.register(BODY_ROTATION, DEFAULT_BODY_ROTATION);
        this.dataManager.register(LEFT_ARM_ROTATION, DEFAULT_LEFTARM_ROTATION);
        this.dataManager.register(RIGHT_ARM_ROTATION, DEFAULT_RIGHTARM_ROTATION);
        this.dataManager.register(LEFT_LEG_ROTATION, DEFAULT_LEFTLEG_ROTATION);
        this.dataManager.register(RIGHT_LEG_ROTATION, DEFAULT_RIGHTLEG_ROTATION);
    }

    @Override
    public Iterable<ItemStack> getHeldEquipment() {
        return Arrays.asList(this.handItems);
    }

    @Override
    public Iterable<ItemStack> getArmorInventoryList() {
        return Arrays.asList(this.armorItems);
    }

    @Override
    @Nullable
    public ItemStack getItemStackFromSlot(EntityEquipmentSlot slotIn) {
        ItemStack itemstack = null;
        switch (slotIn.getSlotType()) {
            case HAND: {
                itemstack = this.handItems[slotIn.getIndex()];
                break;
            }
            case ARMOR: {
                itemstack = this.armorItems[slotIn.getIndex()];
            }
        }
        return itemstack;
    }

    @Override
    public void setItemStackToSlot(EntityEquipmentSlot slotIn, @Nullable ItemStack stack) {
        switch (slotIn.getSlotType()) {
            case HAND: {
                this.playEquipSound(stack);
                this.handItems[slotIn.getIndex()] = stack;
                break;
            }
            case ARMOR: {
                this.playEquipSound(stack);
                this.armorItems[slotIn.getIndex()] = stack;
            }
        }
    }

    @Override
    public boolean replaceItemInInventory(int inventorySlot, @Nullable ItemStack itemStackIn) {
        EntityEquipmentSlot entityequipmentslot;
        if (inventorySlot == 98) {
            entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        } else if (inventorySlot == 99) {
            entityequipmentslot = EntityEquipmentSlot.OFFHAND;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.HEAD.getIndex()) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.CHEST.getIndex()) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.LEGS.getIndex()) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else {
            if (inventorySlot != 100 + EntityEquipmentSlot.FEET.getIndex()) {
                return false;
            }
            entityequipmentslot = EntityEquipmentSlot.FEET;
        }
        if (itemStackIn != null && !EntityLiving.isItemStackInSlot(entityequipmentslot, itemStackIn) && entityequipmentslot != EntityEquipmentSlot.HEAD) {
            return false;
        }
        this.setItemStackToSlot(entityequipmentslot, itemStackIn);
        return true;
    }

    public static void func_189805_a(DataFixer p_189805_0_) {
        p_189805_0_.registerWalker(FixTypes.ENTITY, new ItemStackDataLists("ArmorStand", "ArmorItems", "HandItems"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] itemStackArray = this.armorItems;
        int n = this.armorItems.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemstack = itemStackArray[n2];
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (itemstack != null) {
                itemstack.writeToNBT(nbttagcompound);
            }
            nbttaglist.appendTag(nbttagcompound);
            ++n2;
        }
        compound.setTag("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        ItemStack[] itemStackArray2 = this.handItems;
        int n3 = this.handItems.length;
        n = 0;
        while (n < n3) {
            ItemStack itemstack1 = itemStackArray2[n];
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (itemstack1 != null) {
                itemstack1.writeToNBT(nbttagcompound1);
            }
            nbttaglist1.appendTag(nbttagcompound1);
            ++n;
        }
        compound.setTag("HandItems", nbttaglist1);
        if (this.getAlwaysRenderNameTag() && (this.getCustomNameTag() == null || this.getCustomNameTag().isEmpty())) {
            compound.setBoolean("CustomNameVisible", this.getAlwaysRenderNameTag());
        }
        compound.setBoolean("Invisible", this.isInvisible());
        compound.setBoolean("Small", this.isSmall());
        compound.setBoolean("ShowArms", this.getShowArms());
        compound.setInteger("DisabledSlots", this.disabledSlots);
        compound.setBoolean("NoBasePlate", this.hasNoBasePlate());
        if (this.hasMarker()) {
            compound.setBoolean("Marker", this.hasMarker());
        }
        compound.setTag("Pose", this.readPoseFromNBT());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        if (compound.hasKey("ArmorItems", 9)) {
            NBTTagList nbttaglist = compound.getTagList("ArmorItems", 10);
            int i = 0;
            while (i < this.armorItems.length) {
                this.armorItems[i] = ItemStack.loadItemStackFromNBT(nbttaglist.getCompoundTagAt(i));
                ++i;
            }
        }
        if (compound.hasKey("HandItems", 9)) {
            NBTTagList nbttaglist1 = compound.getTagList("HandItems", 10);
            int j = 0;
            while (j < this.handItems.length) {
                this.handItems[j] = ItemStack.loadItemStackFromNBT(nbttaglist1.getCompoundTagAt(j));
                ++j;
            }
        }
        this.setInvisible(compound.getBoolean("Invisible"));
        this.setSmall(compound.getBoolean("Small"));
        this.setShowArms(compound.getBoolean("ShowArms"));
        this.disabledSlots = compound.getInteger("DisabledSlots");
        this.setNoBasePlate(compound.getBoolean("NoBasePlate"));
        this.setMarker(compound.getBoolean("Marker"));
        this.wasMarker = !this.hasMarker();
        this.noClip = this.func_189652_ae();
        NBTTagCompound nbttagcompound = compound.getCompoundTag("Pose");
        this.writePoseToNBT(nbttagcompound);
    }

    private void writePoseToNBT(NBTTagCompound tagCompound) {
        NBTTagList nbttaglist = tagCompound.getTagList("Head", 5);
        this.setHeadRotation(nbttaglist.hasNoTags() ? DEFAULT_HEAD_ROTATION : new Rotations(nbttaglist));
        NBTTagList nbttaglist1 = tagCompound.getTagList("Body", 5);
        this.setBodyRotation(nbttaglist1.hasNoTags() ? DEFAULT_BODY_ROTATION : new Rotations(nbttaglist1));
        NBTTagList nbttaglist2 = tagCompound.getTagList("LeftArm", 5);
        this.setLeftArmRotation(nbttaglist2.hasNoTags() ? DEFAULT_LEFTARM_ROTATION : new Rotations(nbttaglist2));
        NBTTagList nbttaglist3 = tagCompound.getTagList("RightArm", 5);
        this.setRightArmRotation(nbttaglist3.hasNoTags() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(nbttaglist3));
        NBTTagList nbttaglist4 = tagCompound.getTagList("LeftLeg", 5);
        this.setLeftLegRotation(nbttaglist4.hasNoTags() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(nbttaglist4));
        NBTTagList nbttaglist5 = tagCompound.getTagList("RightLeg", 5);
        this.setRightLegRotation(nbttaglist5.hasNoTags() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(nbttaglist5));
    }

    private NBTTagCompound readPoseFromNBT() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!DEFAULT_HEAD_ROTATION.equals(this.headRotation)) {
            nbttagcompound.setTag("Head", this.headRotation.writeToNBT());
        }
        if (!DEFAULT_BODY_ROTATION.equals(this.bodyRotation)) {
            nbttagcompound.setTag("Body", this.bodyRotation.writeToNBT());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals(this.leftArmRotation)) {
            nbttagcompound.setTag("LeftArm", this.leftArmRotation.writeToNBT());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals(this.rightArmRotation)) {
            nbttagcompound.setTag("RightArm", this.rightArmRotation.writeToNBT());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals(this.leftLegRotation)) {
            nbttagcompound.setTag("LeftLeg", this.leftLegRotation.writeToNBT());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals(this.rightLegRotation)) {
            nbttagcompound.setTag("RightLeg", this.rightLegRotation.writeToNBT());
        }
        return nbttagcompound;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    protected void collideWithEntity(Entity entityIn) {
    }

    @Override
    protected void collideWithNearbyEntities() {
        List<Entity> list = this.worldObj.getEntitiesInAABBexcluding(this, this.getEntityBoundingBox(), IS_RIDEABLE_MINECART);
        int i = 0;
        while (i < list.size()) {
            Entity entity = list.get(i);
            if (this.getDistanceSqToEntity(entity) <= 0.2) {
                entity.applyEntityCollision(this);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EnumActionResult applyPlayerInteraction(EntityPlayer player, Vec3d vec, @Nullable ItemStack stack, EnumHand hand) {
        block12: {
            block14: {
                block15: {
                    block13: {
                        if (this.hasMarker()) {
                            return EnumActionResult.PASS;
                        }
                        if (this.worldObj.isRemote || player.isSpectator()) break block12;
                        entityequipmentslot = EntityEquipmentSlot.MAINHAND;
                        flag = stack != null;
                        v0 = item = flag != false ? stack.getItem() : null;
                        if (flag && item instanceof ItemArmor) {
                            entityequipmentslot = ((ItemArmor)item).armorType;
                        }
                        if (flag && (item == Items.SKULL || item == Item.getItemFromBlock(Blocks.PUMPKIN))) {
                            entityequipmentslot = EntityEquipmentSlot.HEAD;
                        }
                        d0 = 0.1;
                        d1 = 0.9;
                        d2 = 0.4;
                        d3 = 1.6;
                        entityequipmentslot1 = EntityEquipmentSlot.MAINHAND;
                        flag1 = this.isSmall();
                        v1 = d4 = flag1 != false ? vec.yCoord * 2.0 : vec.yCoord;
                        if (!(d4 >= 0.1)) break block13;
                        v2 = flag1 != false ? 0.8 : 0.45;
                        if (!(d4 < 0.1 + v2) || this.getItemStackFromSlot(EntityEquipmentSlot.FEET) == null) break block13;
                        entityequipmentslot1 = EntityEquipmentSlot.FEET;
                        break block14;
                    }
                    v3 = flag1 != false ? 0.3 : 0.0;
                    if (!(d4 >= 0.9 + v3)) break block15;
                    v4 = flag1 != false ? 1.0 : 0.7;
                    if (!(d4 < 0.9 + v4) || this.getItemStackFromSlot(EntityEquipmentSlot.CHEST) == null) break block15;
                    entityequipmentslot1 = EntityEquipmentSlot.CHEST;
                    break block14;
                }
                if (!(d4 >= 0.4)) ** GOTO lbl-1000
                v5 = flag1 != false ? 1.0 : 0.8;
                if (d4 < 0.4 + v5 && this.getItemStackFromSlot(EntityEquipmentSlot.LEGS) != null) {
                    entityequipmentslot1 = EntityEquipmentSlot.LEGS;
                } else if (d4 >= 1.6 && this.getItemStackFromSlot(EntityEquipmentSlot.HEAD) != null) {
                    entityequipmentslot1 = EntityEquipmentSlot.HEAD;
                }
            }
            v6 = flag2 = this.getItemStackFromSlot(entityequipmentslot1) != null;
            if (this.isDisabled(entityequipmentslot1) || this.isDisabled(entityequipmentslot)) {
                entityequipmentslot1 = entityequipmentslot;
                if (this.isDisabled(entityequipmentslot)) {
                    return EnumActionResult.FAIL;
                }
            }
            if (flag && entityequipmentslot == EntityEquipmentSlot.MAINHAND && !this.getShowArms()) {
                return EnumActionResult.FAIL;
            }
            if (flag) {
                this.swapItem(player, entityequipmentslot, stack, hand);
            } else if (flag2) {
                this.swapItem(player, entityequipmentslot1, stack, hand);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean isDisabled(EntityEquipmentSlot slotIn) {
        return (this.disabledSlots & 1 << slotIn.getSlotIndex()) != 0;
    }

    private void swapItem(EntityPlayer player, EntityEquipmentSlot p_184795_2_, @Nullable ItemStack p_184795_3_, EnumHand hand) {
        ItemStack itemstack = this.getItemStackFromSlot(p_184795_2_);
        if (!(itemstack != null && (this.disabledSlots & 1 << p_184795_2_.getSlotIndex() + 8) != 0 || itemstack == null && (this.disabledSlots & 1 << p_184795_2_.getSlotIndex() + 16) != 0)) {
            if (player.capabilities.isCreativeMode && (itemstack == null || itemstack.getItem() == Item.getItemFromBlock(Blocks.AIR)) && p_184795_3_ != null) {
                ItemStack itemstack2 = p_184795_3_.copy();
                itemstack2.stackSize = 1;
                this.setItemStackToSlot(p_184795_2_, itemstack2);
            } else if (p_184795_3_ != null && p_184795_3_.stackSize > 1) {
                if (itemstack == null) {
                    ItemStack itemstack1 = p_184795_3_.copy();
                    itemstack1.stackSize = 1;
                    this.setItemStackToSlot(p_184795_2_, itemstack1);
                    --p_184795_3_.stackSize;
                }
            } else {
                this.setItemStackToSlot(p_184795_2_, p_184795_3_);
                player.setHeldItem(hand, itemstack);
            }
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.worldObj.isRemote && !this.isDead) {
            if (DamageSource.outOfWorld.equals(source)) {
                this.setDead();
                return false;
            }
            if (!(this.isEntityInvulnerable(source) || this.canInteract || this.hasMarker())) {
                if (source.isExplosion()) {
                    this.dropContents();
                    this.setDead();
                    return false;
                }
                if (DamageSource.inFire.equals(source)) {
                    if (this.isBurning()) {
                        this.damageArmorStand(0.15f);
                    } else {
                        this.setFire(5);
                    }
                    return false;
                }
                if (DamageSource.onFire.equals(source) && this.getHealth() > 0.5f) {
                    this.damageArmorStand(4.0f);
                    return false;
                }
                boolean flag = "arrow".equals(source.getDamageType());
                boolean flag1 = "player".equals(source.getDamageType());
                if (!flag1 && !flag) {
                    return false;
                }
                if (source.getSourceOfDamage() instanceof EntityArrow) {
                    source.getSourceOfDamage().setDead();
                }
                if (source.getEntity() instanceof EntityPlayer && !((EntityPlayer)source.getEntity()).capabilities.allowEdit) {
                    return false;
                }
                if (source.isCreativePlayer()) {
                    this.playParticles();
                    this.setDead();
                    return false;
                }
                long i = this.worldObj.getTotalWorldTime();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.worldObj.setEntityState(this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.dropBlock();
                    this.playParticles();
                    this.setDead();
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void handleStatusUpdate(byte id) {
        if (id == 32) {
            if (this.worldObj.isRemote) {
                this.worldObj.playSound(this.posX, this.posY, this.posZ, SoundEvents.ENTITY_ARMORSTAND_HIT, this.getSoundCategory(), 0.3f, 1.0f, false);
                this.punchCooldown = this.worldObj.getTotalWorldTime();
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Override
    public boolean isInRangeToRenderDist(double distance) {
        double d0 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.worldObj instanceof WorldServer) {
            ((WorldServer)this.worldObj).spawnParticle(EnumParticleTypes.BLOCK_DUST, this.posX, this.posY + (double)this.height / 1.5, this.posZ, 10, (double)(this.width / 4.0f), (double)(this.height / 4.0f), (double)(this.width / 4.0f), 0.05, Block.getStateId(Blocks.PLANKS.getDefaultState()));
        }
    }

    private void damageArmorStand(float damage) {
        float f = this.getHealth();
        if ((f -= damage) <= 0.5f) {
            this.dropContents();
            this.setDead();
        } else {
            this.setHealth(f);
        }
    }

    private void dropBlock() {
        Block.spawnAsEntity(this.worldObj, new BlockPos(this), new ItemStack(Items.ARMOR_STAND));
        this.dropContents();
    }

    private void dropContents() {
        this.worldObj.playSound(null, this.posX, this.posY, this.posZ, SoundEvents.ENTITY_ARMORSTAND_BREAK, this.getSoundCategory(), 1.0f, 1.0f);
        int i = 0;
        while (i < this.handItems.length) {
            if (this.handItems[i] != null && this.handItems[i].stackSize > 0) {
                if (this.handItems[i] != null) {
                    Block.spawnAsEntity(this.worldObj, new BlockPos(this).up(), this.handItems[i]);
                }
                this.handItems[i] = null;
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorItems.length) {
            if (this.armorItems[j] != null && this.armorItems[j].stackSize > 0) {
                if (this.armorItems[j] != null) {
                    Block.spawnAsEntity(this.worldObj, new BlockPos(this).up(), this.armorItems[j]);
                }
                this.armorItems[j] = null;
            }
            ++j;
        }
    }

    @Override
    protected float updateDistance(float p_110146_1_, float p_110146_2_) {
        this.prevRenderYawOffset = this.prevRotationYaw;
        this.renderYawOffset = this.rotationYaw;
        return 0.0f;
    }

    @Override
    public float getEyeHeight() {
        return this.isChild() ? this.height * 0.5f : this.height * 0.9f;
    }

    @Override
    public double getYOffset() {
        return this.hasMarker() ? 0.0 : (double)0.1f;
    }

    @Override
    public void moveEntityWithHeading(float strafe, float forward) {
        if (!this.func_189652_ae()) {
            super.moveEntityWithHeading(strafe, forward);
        }
    }

    @Override
    public void onUpdate() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.onUpdate();
        Rotations rotations = this.dataManager.get(HEAD_ROTATION);
        if (!this.headRotation.equals(rotations)) {
            this.setHeadRotation(rotations);
        }
        if (!this.bodyRotation.equals(rotations1 = this.dataManager.get(BODY_ROTATION))) {
            this.setBodyRotation(rotations1);
        }
        if (!this.leftArmRotation.equals(rotations2 = this.dataManager.get(LEFT_ARM_ROTATION))) {
            this.setLeftArmRotation(rotations2);
        }
        if (!this.rightArmRotation.equals(rotations3 = this.dataManager.get(RIGHT_ARM_ROTATION))) {
            this.setRightArmRotation(rotations3);
        }
        if (!this.leftLegRotation.equals(rotations4 = this.dataManager.get(LEFT_LEG_ROTATION))) {
            this.setLeftLegRotation(rotations4);
        }
        if (!this.rightLegRotation.equals(rotations5 = this.dataManager.get(RIGHT_LEG_ROTATION))) {
            this.setRightLegRotation(rotations5);
        }
        boolean flag = this.hasMarker();
        if (!this.wasMarker && flag) {
            this.updateBoundingBox(false);
            this.preventEntitySpawning = false;
        } else {
            if (!this.wasMarker || flag) {
                return;
            }
            this.updateBoundingBox(true);
            this.preventEntitySpawning = true;
        }
        this.wasMarker = flag;
    }

    private void updateBoundingBox(boolean p_181550_1_) {
        double d0 = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        if (p_181550_1_) {
            this.setSize(0.5f, 1.975f);
        } else {
            this.setSize(0.0f, 0.0f);
        }
        this.setPosition(d0, d1, d2);
    }

    @Override
    protected void updatePotionMetadata() {
        this.setInvisible(this.canInteract);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.canInteract = invisible;
        super.setInvisible(invisible);
    }

    @Override
    public boolean isChild() {
        return this.isSmall();
    }

    @Override
    public void onKillCommand() {
        this.setDead();
    }

    @Override
    public boolean isImmuneToExplosions() {
        return this.isInvisible();
    }

    private void setSmall(boolean small) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 1, small));
    }

    public boolean isSmall() {
        return (this.dataManager.get(STATUS) & 1) != 0;
    }

    private void setShowArms(boolean showArms) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 4, showArms));
    }

    public boolean getShowArms() {
        return (this.dataManager.get(STATUS) & 4) != 0;
    }

    private void setNoBasePlate(boolean noBasePlate) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 8, noBasePlate));
    }

    public boolean hasNoBasePlate() {
        return (this.dataManager.get(STATUS) & 8) != 0;
    }

    private void setMarker(boolean marker) {
        this.dataManager.set(STATUS, this.setBit(this.dataManager.get(STATUS), 16, marker));
    }

    public boolean hasMarker() {
        return (this.dataManager.get(STATUS) & 0x10) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setHeadRotation(Rotations vec) {
        this.headRotation = vec;
        this.dataManager.set(HEAD_ROTATION, vec);
    }

    public void setBodyRotation(Rotations vec) {
        this.bodyRotation = vec;
        this.dataManager.set(BODY_ROTATION, vec);
    }

    public void setLeftArmRotation(Rotations vec) {
        this.leftArmRotation = vec;
        this.dataManager.set(LEFT_ARM_ROTATION, vec);
    }

    public void setRightArmRotation(Rotations vec) {
        this.rightArmRotation = vec;
        this.dataManager.set(RIGHT_ARM_ROTATION, vec);
    }

    public void setLeftLegRotation(Rotations vec) {
        this.leftLegRotation = vec;
        this.dataManager.set(LEFT_LEG_ROTATION, vec);
    }

    public void setRightLegRotation(Rotations vec) {
        this.rightLegRotation = vec;
        this.dataManager.set(RIGHT_LEG_ROTATION, vec);
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    @Override
    public boolean canBeCollidedWith() {
        return super.canBeCollidedWith() && !this.hasMarker();
    }

    @Override
    public EnumHandSide getPrimaryHand() {
        return EnumHandSide.RIGHT;
    }

    @Override
    protected SoundEvent getFallSound(int heightIn) {
        return SoundEvents.ENTITY_ARMORSTAND_FALL;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound() {
        return SoundEvents.ENTITY_ARMORSTAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_ARMORSTAND_BREAK;
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt lightningBolt) {
    }

    @Override
    public boolean canBeHitWithPotion() {
        return false;
    }
}

