/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;

public class EntityMinecartEmpty
extends EntityMinecart {
    public EntityMinecartEmpty(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartEmpty(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public static void func_189673_a(DataFixer p_189673_0_) {
        EntityMinecart.func_189669_a(p_189673_0_, "MinecartRideable");
    }

    @Override
    public boolean processInitialInteract(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        if (player.isSneaking()) {
            return false;
        }
        if (this.isBeingRidden()) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            player.startRiding(this);
        }
        return true;
    }

    @Override
    public void onActivatorRailPass(int x, int y, int z, boolean receivingPower) {
        if (receivingPower) {
            if (this.isBeingRidden()) {
                this.removePassengers();
            }
            if (this.getRollingAmplitude() == 0) {
                this.setRollingDirection(-this.getRollingDirection());
                this.setRollingAmplitude(10);
                this.setDamage(50.0f);
                this.setBeenAttacked();
            }
        }
    }

    @Override
    public EntityMinecart.Type getType() {
        return EntityMinecart.Type.RIDEABLE;
    }
}

