/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.world.World;

public class RecipesBanners {
    void addRecipes(CraftingManager manager) {
        EnumDyeColor[] enumDyeColorArray = EnumDyeColor.values();
        int n = enumDyeColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumDyeColor enumdyecolor = enumDyeColorArray[n2];
            manager.addRecipe(new ItemStack(Items.BANNER, 1, enumdyecolor.getDyeDamage()), "###", "###", " | ", Character.valueOf('#'), new ItemStack(Blocks.WOOL, 1, enumdyecolor.getMetadata()), Character.valueOf('|'), Items.STICK);
            ++n2;
        }
        manager.addRecipe(new RecipeDuplicatePattern());
        manager.addRecipe(new RecipeAddPattern());
    }

    static class RecipeAddPattern
    implements IRecipe {
        private RecipeAddPattern() {
        }

        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            boolean flag = false;
            int i = 0;
            while (i < inv.getSizeInventory()) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack != null && itemstack.getItem() == Items.BANNER) {
                    if (flag) {
                        return false;
                    }
                    if (TileEntityBanner.getPatterns(itemstack) >= 6) {
                        return false;
                    }
                    flag = true;
                }
                ++i;
            }
            if (!flag) {
                return false;
            }
            return this.matchPatterns(inv) != null;
        }

        @Override
        @Nullable
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            ItemStack itemstack = null;
            int i = 0;
            while (i < inv.getSizeInventory()) {
                ItemStack itemstack1 = inv.getStackInSlot(i);
                if (itemstack1 != null && itemstack1.getItem() == Items.BANNER) {
                    itemstack = itemstack1.copy();
                    itemstack.stackSize = 1;
                    break;
                }
                ++i;
            }
            TileEntityBanner.EnumBannerPattern tileentitybanner$enumbannerpattern = this.matchPatterns(inv);
            if (tileentitybanner$enumbannerpattern != null) {
                NBTTagList nbttaglist;
                int k = 0;
                int j = 0;
                while (j < inv.getSizeInventory()) {
                    ItemStack itemstack2 = inv.getStackInSlot(j);
                    if (itemstack2 != null && itemstack2.getItem() == Items.DYE) {
                        k = itemstack2.getMetadata();
                        break;
                    }
                    ++j;
                }
                NBTTagCompound nbttagcompound1 = itemstack.getSubCompound("BlockEntityTag", true);
                if (nbttagcompound1.hasKey("Patterns", 9)) {
                    nbttaglist = nbttagcompound1.getTagList("Patterns", 10);
                } else {
                    nbttaglist = new NBTTagList();
                    nbttagcompound1.setTag("Patterns", nbttaglist);
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setString("Pattern", tileentitybanner$enumbannerpattern.getPatternID());
                nbttagcompound.setInteger("Color", k);
                nbttaglist.appendTag(nbttagcompound);
            }
            return itemstack;
        }

        @Override
        public int getRecipeSize() {
            return 10;
        }

        @Override
        @Nullable
        public ItemStack getRecipeOutput() {
            return null;
        }

        @Override
        public ItemStack[] getRemainingItems(InventoryCrafting inv) {
            ItemStack[] aitemstack = new ItemStack[inv.getSizeInventory()];
            int i = 0;
            while (i < aitemstack.length) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack != null && itemstack.getItem().hasContainerItem()) {
                    aitemstack[i] = new ItemStack(itemstack.getItem().getContainerItem());
                }
                ++i;
            }
            return aitemstack;
        }

        @Nullable
        private TileEntityBanner.EnumBannerPattern matchPatterns(InventoryCrafting invCrafting) {
            TileEntityBanner.EnumBannerPattern[] enumBannerPatternArray = TileEntityBanner.EnumBannerPattern.values();
            int n = enumBannerPatternArray.length;
            int n2 = 0;
            while (n2 < n) {
                TileEntityBanner.EnumBannerPattern tileentitybanner$enumbannerpattern = enumBannerPatternArray[n2];
                if (tileentitybanner$enumbannerpattern.hasValidCrafting()) {
                    boolean flag = true;
                    if (tileentitybanner$enumbannerpattern.hasCraftingStack()) {
                        boolean flag1 = false;
                        boolean flag2 = false;
                        int i = 0;
                        while (i < invCrafting.getSizeInventory() && flag) {
                            ItemStack itemstack = invCrafting.getStackInSlot(i);
                            if (itemstack != null && itemstack.getItem() != Items.BANNER) {
                                if (itemstack.getItem() == Items.DYE) {
                                    if (flag2) {
                                        flag = false;
                                        break;
                                    }
                                    flag2 = true;
                                } else {
                                    if (flag1 || !itemstack.isItemEqual(tileentitybanner$enumbannerpattern.getCraftingStack())) {
                                        flag = false;
                                        break;
                                    }
                                    flag1 = true;
                                }
                            }
                            ++i;
                        }
                        if (!flag1) {
                            flag = false;
                        }
                    } else if (invCrafting.getSizeInventory() == tileentitybanner$enumbannerpattern.getCraftingLayers().length * tileentitybanner$enumbannerpattern.getCraftingLayers()[0].length()) {
                        int j = -1;
                        int k = 0;
                        while (k < invCrafting.getSizeInventory() && flag) {
                            int l = k / 3;
                            int i1 = k % 3;
                            ItemStack itemstack1 = invCrafting.getStackInSlot(k);
                            if (itemstack1 != null && itemstack1.getItem() != Items.BANNER) {
                                if (itemstack1.getItem() != Items.DYE) {
                                    flag = false;
                                    break;
                                }
                                if (j != -1 && j != itemstack1.getMetadata()) {
                                    flag = false;
                                    break;
                                }
                                if (tileentitybanner$enumbannerpattern.getCraftingLayers()[l].charAt(i1) == ' ') {
                                    flag = false;
                                    break;
                                }
                                j = itemstack1.getMetadata();
                            } else if (tileentitybanner$enumbannerpattern.getCraftingLayers()[l].charAt(i1) != ' ') {
                                flag = false;
                                break;
                            }
                            ++k;
                        }
                    } else {
                        flag = false;
                    }
                    if (flag) {
                        return tileentitybanner$enumbannerpattern;
                    }
                }
                ++n2;
            }
            return null;
        }
    }

    static class RecipeDuplicatePattern
    implements IRecipe {
        private RecipeDuplicatePattern() {
        }

        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            ItemStack itemstack = null;
            ItemStack itemstack1 = null;
            int i = 0;
            while (i < inv.getSizeInventory()) {
                ItemStack itemstack2 = inv.getStackInSlot(i);
                if (itemstack2 != null) {
                    boolean flag;
                    if (itemstack2.getItem() != Items.BANNER) {
                        return false;
                    }
                    if (itemstack != null && itemstack1 != null) {
                        return false;
                    }
                    int j = TileEntityBanner.getBaseColor(itemstack2);
                    boolean bl = flag = TileEntityBanner.getPatterns(itemstack2) > 0;
                    if (itemstack != null) {
                        if (flag) {
                            return false;
                        }
                        if (j != TileEntityBanner.getBaseColor(itemstack)) {
                            return false;
                        }
                        itemstack1 = itemstack2;
                    } else if (itemstack1 != null) {
                        if (!flag) {
                            return false;
                        }
                        if (j != TileEntityBanner.getBaseColor(itemstack1)) {
                            return false;
                        }
                        itemstack = itemstack2;
                    } else if (flag) {
                        itemstack = itemstack2;
                    } else {
                        itemstack1 = itemstack2;
                    }
                }
                ++i;
            }
            return itemstack != null && itemstack1 != null;
        }

        @Override
        @Nullable
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            int i = 0;
            while (i < inv.getSizeInventory()) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack != null && TileEntityBanner.getPatterns(itemstack) > 0) {
                    ItemStack itemstack1 = itemstack.copy();
                    itemstack1.stackSize = 1;
                    return itemstack1;
                }
                ++i;
            }
            return null;
        }

        @Override
        public int getRecipeSize() {
            return 2;
        }

        @Override
        @Nullable
        public ItemStack getRecipeOutput() {
            return null;
        }

        @Override
        public ItemStack[] getRemainingItems(InventoryCrafting inv) {
            ItemStack[] aitemstack = new ItemStack[inv.getSizeInventory()];
            int i = 0;
            while (i < aitemstack.length) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack != null) {
                    if (itemstack.getItem().hasContainerItem()) {
                        aitemstack[i] = new ItemStack(itemstack.getItem().getContainerItem());
                    } else if (itemstack.hasTagCompound() && TileEntityBanner.getPatterns(itemstack) > 0) {
                        aitemstack[i] = itemstack.copy();
                        aitemstack[i].stackSize = 1;
                    }
                }
                ++i;
            }
            return aitemstack;
        }
    }
}

