/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import optfine.Config;
import optfine.CustomColors;

public class PotionUtils {
    public static List<PotionEffect> getEffectsFromStack(ItemStack stack) {
        return PotionUtils.getEffectsFromTag(stack.getTagCompound());
    }

    public static List<PotionEffect> mergeEffects(PotionType potionIn, Collection<PotionEffect> effects) {
        ArrayList list = Lists.newArrayList();
        list.addAll(potionIn.getEffects());
        list.addAll(effects);
        return list;
    }

    public static List<PotionEffect> getEffectsFromTag(NBTTagCompound tag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(PotionUtils.getPotionTypeFromNBT(tag).getEffects());
        PotionUtils.addCustomPotionEffectToList(tag, list);
        return list;
    }

    public static List<PotionEffect> getFullEffectsFromItem(ItemStack itemIn) {
        return PotionUtils.getFullEffectsFromTag(itemIn.getTagCompound());
    }

    public static List<PotionEffect> getFullEffectsFromTag(NBTTagCompound tag) {
        ArrayList list = Lists.newArrayList();
        PotionUtils.addCustomPotionEffectToList(tag, list);
        return list;
    }

    public static void addCustomPotionEffectToList(NBTTagCompound tag, List<PotionEffect> effectList) {
        if (tag != null && tag.hasKey("CustomPotionEffects", 9)) {
            NBTTagList nbttaglist = tag.getTagList("CustomPotionEffects", 10);
            int i = 0;
            while (i < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                PotionEffect potioneffect = PotionEffect.readCustomPotionEffectFromNBT(nbttagcompound);
                if (potioneffect != null) {
                    effectList.add(potioneffect);
                }
                ++i;
            }
        }
    }

    public static int getPotionColor(PotionType potionIn) {
        return PotionUtils.getPotionColorFromEffectList(potionIn.getEffects());
    }

    public static int getPotionColorFromEffectList(Collection<PotionEffect> effects) {
        int i = 3694022;
        if (effects.isEmpty()) {
            return Config.isCustomColors() ? CustomColors.getPotionColor(null, i) : 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (PotionEffect potioneffect : effects) {
            if (!potioneffect.doesShowParticles()) continue;
            int k = potioneffect.getPotion().getLiquidColor();
            if (Config.isCustomColors()) {
                k = CustomColors.getPotionColor(potioneffect.getPotion(), k);
            }
            int l = potioneffect.getAmplifier() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static PotionType getPotionFromItem(ItemStack itemIn) {
        return PotionUtils.getPotionTypeFromNBT(itemIn.getTagCompound());
    }

    public static PotionType getPotionTypeFromNBT(NBTTagCompound tag) {
        return tag == null ? PotionTypes.WATER : PotionType.getPotionTypeForName(tag.getString("Potion"));
    }

    public static ItemStack addPotionToItemStack(ItemStack itemIn, PotionType potionIn) {
        ResourceLocation resourcelocation = PotionType.REGISTRY.getNameForObject(potionIn);
        if (resourcelocation != null) {
            NBTTagCompound nbttagcompound = itemIn.hasTagCompound() ? itemIn.getTagCompound() : new NBTTagCompound();
            nbttagcompound.setString("Potion", resourcelocation.toString());
            itemIn.setTagCompound(nbttagcompound);
        }
        return itemIn;
    }

    public static ItemStack appendEffects(ItemStack itemIn, Collection<PotionEffect> effects) {
        if (effects.isEmpty()) {
            return itemIn;
        }
        NBTTagCompound nbttagcompound = (NBTTagCompound)Objects.firstNonNull((Object)itemIn.getTagCompound(), (Object)new NBTTagCompound());
        NBTTagList nbttaglist = nbttagcompound.getTagList("CustomPotionEffects", 9);
        for (PotionEffect potioneffect : effects) {
            nbttaglist.appendTag(potioneffect.writeCustomPotionEffectToNBT(new NBTTagCompound()));
        }
        nbttagcompound.setTag("CustomPotionEffects", nbttaglist);
        itemIn.setTagCompound(nbttagcompound);
        return itemIn;
    }

    public static void addPotionTooltip(ItemStack itemIn, List<String> lores, float durationFactor) {
        List<PotionEffect> list = PotionUtils.getEffectsFromStack(itemIn);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = I18n.translateToLocal("effect.none").trim();
            lores.add((Object)((Object)TextFormatting.GRAY) + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.translateToLocal(potioneffect.getEffectName()).trim();
                Potion potion = potioneffect.getPotion();
                Map<IAttribute, AttributeModifier> map = potion.getAttributeModifierMap();
                if (!map.isEmpty()) {
                    for (Map.Entry<IAttribute, AttributeModifier> entry : map.entrySet()) {
                        AttributeModifier attributemodifier = entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.getName(), potion.getAttributeModifierAmount(potioneffect.getAmplifier(), attributemodifier), attributemodifier.getOperation());
                        list1.add(new Tuple<String, AttributeModifier>(entry.getKey().getAttributeUnlocalizedName(), attributemodifier1));
                    }
                }
                if (potioneffect.getAmplifier() > 0) {
                    s1 = String.valueOf(s1) + " " + I18n.translateToLocal("potion.potency." + potioneffect.getAmplifier()).trim();
                }
                if (potioneffect.getDuration() > 20) {
                    s1 = String.valueOf(s1) + " (" + Potion.getPotionDurationString(potioneffect, durationFactor) + ")";
                }
                if (potion.isBadEffect()) {
                    lores.add((Object)((Object)TextFormatting.RED) + s1);
                    continue;
                }
                lores.add((Object)((Object)TextFormatting.BLUE) + s1);
            }
        }
        if (!list1.isEmpty()) {
            lores.add("");
            lores.add((Object)((Object)TextFormatting.DARK_PURPLE) + I18n.translateToLocal("potion.whenDrank"));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.getSecond();
                double d0 = attributemodifier2.getAmount();
                double d1 = attributemodifier2.getOperation() != 1 && attributemodifier2.getOperation() != 2 ? attributemodifier2.getAmount() : attributemodifier2.getAmount() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Object)((Object)TextFormatting.BLUE) + I18n.translateToLocalFormatted("attribute.modifier.plus." + attributemodifier2.getOperation(), ItemStack.DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)tuple.getFirst())));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Object)((Object)TextFormatting.RED) + I18n.translateToLocalFormatted("attribute.modifier.take." + attributemodifier2.getOperation(), ItemStack.DECIMALFORMAT.format(d1 *= -1.0), I18n.translateToLocal("attribute.name." + (String)tuple.getFirst())));
            }
        }
    }
}

