/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHopper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityHopper
extends TileEntityLockableLoot
implements IHopper,
ITickable {
    private ItemStack[] inventory = new ItemStack[5];
    private String customName;
    private int transferCooldown = -1;

    public static void func_189683_a(DataFixer p_189683_0_) {
        p_189683_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists("Hopper", new String[]{"Items"}));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.inventory = new ItemStack[this.getSizeInventory()];
        if (compound.hasKey("CustomName", 8)) {
            this.customName = compound.getString("CustomName");
        }
        this.transferCooldown = compound.getInteger("TransferCooldown");
        if (!this.checkLootAndRead(compound)) {
            NBTTagList nbttaglist = compound.getTagList("Items", 10);
            int i = 0;
            while (i < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                byte j = nbttagcompound.getByte("Slot");
                if (j >= 0 && j < this.inventory.length) {
                    this.inventory[j] = ItemStack.loadItemStackFromNBT(nbttagcompound);
                }
                ++i;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.checkLootAndWrite(p_189515_1_)) {
            NBTTagList nbttaglist = new NBTTagList();
            int i = 0;
            while (i < this.inventory.length) {
                if (this.inventory[i] != null) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.setByte("Slot", (byte)i);
                    this.inventory[i].writeToNBT(nbttagcompound);
                    nbttaglist.appendTag(nbttagcompound);
                }
                ++i;
            }
            p_189515_1_.setTag("Items", nbttaglist);
        }
        p_189515_1_.setInteger("TransferCooldown", this.transferCooldown);
        if (this.hasCustomName()) {
            p_189515_1_.setString("CustomName", this.customName);
        }
        return p_189515_1_;
    }

    @Override
    public int getSizeInventory() {
        return this.inventory.length;
    }

    @Override
    @Nullable
    public ItemStack getStackInSlot(int index) {
        this.fillWithLoot(null);
        return this.inventory[index];
    }

    @Override
    @Nullable
    public ItemStack decrStackSize(int index, int count) {
        this.fillWithLoot(null);
        return ItemStackHelper.getAndSplit(this.inventory, index, count);
    }

    @Override
    @Nullable
    public ItemStack removeStackFromSlot(int index) {
        this.fillWithLoot(null);
        return ItemStackHelper.getAndRemove(this.inventory, index);
    }

    @Override
    public void setInventorySlotContents(int index, @Nullable ItemStack stack) {
        this.fillWithLoot(null);
        this.inventory[index] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.hopper";
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customNameIn) {
        this.customName = customNameIn;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.pos) != this ? false : player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void update() {
        if (this.worldObj != null && !this.worldObj.isRemote) {
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper();
            }
        }
    }

    public boolean updateHopper() {
        if (this.worldObj != null && !this.worldObj.isRemote) {
            if (!this.isOnTransferCooldown() && BlockHopper.isEnabled(this.getBlockMetadata())) {
                boolean flag = false;
                if (!this.isEmpty()) {
                    flag = this.transferItemsOut();
                }
                if (!this.isFull()) {
                    boolean bl = flag = TileEntityHopper.captureDroppedItems(this) || flag;
                }
                if (flag) {
                    this.setTransferCooldown(8);
                    this.markDirty();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isEmpty() {
        ItemStack[] itemStackArray = this.inventory;
        int n = this.inventory.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemstack = itemStackArray[n2];
            if (itemstack != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isFull() {
        ItemStack[] itemStackArray = this.inventory;
        int n = this.inventory.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemstack = itemStackArray[n2];
            if (itemstack == null || itemstack.stackSize != itemstack.getMaxStackSize()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean transferItemsOut() {
        IInventory iinventory = this.getInventoryForHopperTransfer();
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = BlockHopper.getFacing(this.getBlockMetadata()).getOpposite();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            return false;
        }
        int i = 0;
        while (i < this.getSizeInventory()) {
            if (this.getStackInSlot(i) != null) {
                ItemStack itemstack = this.getStackInSlot(i).copy();
                ItemStack itemstack1 = TileEntityHopper.putStackInInventoryAllSlots(iinventory, this.decrStackSize(i, 1), enumfacing);
                if (itemstack1 == null || itemstack1.stackSize == 0) {
                    iinventory.markDirty();
                    return true;
                }
                this.setInventorySlotContents(i, itemstack);
            }
            ++i;
        }
        return false;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] nArray = aint = isidedinventory.getSlotsForFace(side);
            int n = aint.length;
            int n2 = 0;
            while (n2 < n) {
                int k = nArray[n2];
                ItemStack itemstack1 = isidedinventory.getStackInSlot(k);
                if (itemstack1 == null || itemstack1.stackSize != itemstack1.getMaxStackSize()) {
                    return false;
                }
                ++n2;
            }
        } else {
            int i = inventoryIn.getSizeInventory();
            int j = 0;
            while (j < i) {
                ItemStack itemstack = inventoryIn.getStackInSlot(j);
                if (itemstack == null || itemstack.stackSize != itemstack.getMaxStackSize()) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] nArray = aint = isidedinventory.getSlotsForFace(side);
            int n = aint.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (isidedinventory.getStackInSlot(i) != null) {
                    return false;
                }
                ++n2;
            }
        } else {
            int j = inventoryIn.getSizeInventory();
            int k = 0;
            while (k < j) {
                if (inventoryIn.getStackInSlot(k) != null) {
                    return false;
                }
                ++k;
            }
        }
        return true;
    }

    public static boolean captureDroppedItems(IHopper hopper) {
        IInventory iinventory = TileEntityHopper.getHopperInventory(hopper);
        if (iinventory != null) {
            EnumFacing enumfacing = EnumFacing.DOWN;
            if (TileEntityHopper.isInventoryEmpty(iinventory, enumfacing)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                int[] nArray = aint = isidedinventory.getSlotsForFace(enumfacing);
                int n = aint.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (TileEntityHopper.pullItemFromSlot(hopper, iinventory, i, enumfacing)) {
                        return true;
                    }
                    ++n2;
                }
            } else {
                int j = iinventory.getSizeInventory();
                int k = 0;
                while (k < j) {
                    if (TileEntityHopper.pullItemFromSlot(hopper, iinventory, k, enumfacing)) {
                        return true;
                    }
                    ++k;
                }
            }
        } else {
            for (EntityItem entityitem : TileEntityHopper.getCaptureItems(hopper.getWorld(), hopper.getXPos(), hopper.getYPos(), hopper.getZPos())) {
                if (!TileEntityHopper.putDropInInventoryAllSlots(hopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, EnumFacing direction) {
        ItemStack itemstack = inventoryIn.getStackInSlot(index);
        if (itemstack != null && TileEntityHopper.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = TileEntityHopper.putStackInInventoryAllSlots(hopper, inventoryIn.decrStackSize(index, 1), null);
            if (itemstack2 == null || itemstack2.stackSize == 0) {
                inventoryIn.markDirty();
                return true;
            }
            inventoryIn.setInventorySlotContents(index, itemstack1);
        }
        return false;
    }

    public static boolean putDropInInventoryAllSlots(IInventory p_145898_0_, EntityItem itemIn) {
        boolean flag = false;
        if (itemIn == null) {
            return false;
        }
        ItemStack itemstack = itemIn.getEntityItem().copy();
        ItemStack itemstack1 = TileEntityHopper.putStackInInventoryAllSlots(p_145898_0_, itemstack, null);
        if (itemstack1 != null && itemstack1.stackSize != 0) {
            itemIn.setEntityItemStack(itemstack1);
        } else {
            flag = true;
            itemIn.setDead();
        }
        return flag;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.getSlotsForFace(side);
            int k = 0;
            while (k < aint.length && stack != null && stack.stackSize > 0) {
                stack = TileEntityHopper.insertStack(inventoryIn, stack, aint[k], side);
                ++k;
            }
        } else {
            int i = inventoryIn.getSizeInventory();
            int j = 0;
            while (j < i && stack != null && stack.stackSize > 0) {
                stack = TileEntityHopper.insertStack(inventoryIn, stack, j, side);
                ++j;
            }
        }
        if (stack != null && stack.stackSize == 0) {
            stack = null;
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !inventoryIn.isItemValidForSlot(index, stack) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).canInsertItem(index, stack, side);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).canExtractItem(index, stack, side);
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.getStackInSlot(index);
        if (TileEntityHopper.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            boolean flag = false;
            if (itemstack == null) {
                inventoryIn.setInventorySlotContents(index, stack);
                stack = null;
                flag = true;
            } else if (TileEntityHopper.canCombine(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.stackSize;
                int j = Math.min(stack.stackSize, i);
                stack.stackSize -= j;
                itemstack.stackSize += j;
                boolean bl = flag = j > 0;
            }
            if (flag) {
                if (inventoryIn instanceof TileEntityHopper) {
                    TileEntityHopper tileentityhopper = (TileEntityHopper)inventoryIn;
                    if (tileentityhopper.mayTransfer()) {
                        tileentityhopper.setTransferCooldown(8);
                    }
                    inventoryIn.markDirty();
                }
                inventoryIn.markDirty();
            }
        }
        return stack;
    }

    private IInventory getInventoryForHopperTransfer() {
        EnumFacing enumfacing = BlockHopper.getFacing(this.getBlockMetadata());
        return TileEntityHopper.getInventoryAtPosition(this.getWorld(), this.getXPos() + (double)enumfacing.getFrontOffsetX(), this.getYPos() + (double)enumfacing.getFrontOffsetY(), this.getZPos() + (double)enumfacing.getFrontOffsetZ());
    }

    public static IInventory getHopperInventory(IHopper hopper) {
        return TileEntityHopper.getInventoryAtPosition(hopper.getWorld(), hopper.getXPos(), hopper.getYPos() + 1.0, hopper.getZPos());
    }

    public static List<EntityItem> getCaptureItems(World worldIn, double p_184292_1_, double p_184292_3_, double p_184292_5_) {
        return worldIn.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(p_184292_1_ - 0.5, p_184292_3_, p_184292_5_ - 0.5, p_184292_1_ + 0.5, p_184292_3_ + 1.5, p_184292_5_ + 0.5), EntitySelectors.IS_ALIVE);
    }

    public static IInventory getInventoryAtPosition(World worldIn, double x, double y, double z) {
        List<Entity> list;
        TileEntity tileentity;
        int k;
        int j;
        IInventory iinventory = null;
        int i = MathHelper.floor_double(x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor_double(y), k = MathHelper.floor_double(z));
        Block block = worldIn.getBlockState(blockpos).getBlock();
        if (block.hasTileEntity() && (tileentity = worldIn.getTileEntity(blockpos)) instanceof IInventory && (iinventory = (IInventory)((Object)tileentity)) instanceof TileEntityChest && block instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_189418_a(worldIn, blockpos, true);
        }
        if (iinventory == null && !(list = worldIn.getEntitiesInAABBexcluding(null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelectors.HAS_INVENTORY)).isEmpty()) {
            iinventory = (IInventory)((Object)list.get(worldIn.rand.nextInt(list.size())));
        }
        return iinventory;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() != stack2.getItem() ? false : (stack1.getMetadata() != stack2.getMetadata() ? false : (stack1.stackSize > stack1.getMaxStackSize() ? false : ItemStack.areItemStackTagsEqual(stack1, stack2)));
    }

    @Override
    public double getXPos() {
        return (double)this.pos.getX() + 0.5;
    }

    @Override
    public double getYPos() {
        return (double)this.pos.getY() + 0.5;
    }

    @Override
    public double getZPos() {
        return (double)this.pos.getZ() + 0.5;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown <= 1;
    }

    @Override
    public String getGuiID() {
        return "minecraft:hopper";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.fillWithLoot(playerIn);
        return new ContainerHopper(playerInventory, this, playerIn);
    }

    @Override
    public int getField(int id) {
        return 0;
    }

    @Override
    public void setField(int id, int value) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.fillWithLoot(null);
        int i = 0;
        while (i < this.inventory.length) {
            this.inventory[i] = null;
            ++i;
        }
    }
}

